/***************************************************************************
                          converter.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Jul 3 1999                                           
    copyright            : (C) 1999 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef rcsid
static const char rcsid[]="$Id: converter.cpp,v 2.6 1999/10/13 00:51:20 ral Exp $";
//const char*converter_rcs(){return rcsid;}
#endif

#include "converter.h"
#include "htmlconverter.h"
#include "latexconverter.h"

/** Constructor */
CConverter::CConverter()
{
    count = 0;
}
CConverter::~CConverter(){
}

/** Retrieves a converter-object
 * This is the one and only way to get an instance.
 * The identifier identifies what type of converter
 * is requested. (C_HTML, C_LATEX)
*/
CConverter* CConverter::get_converter(ConvertTypes type)
{
    if (type < 0)
	return 0;
    switch (type) {
    case 0:
	return new CHtmlConverter;
	break;
    case 1:
	return new CLatexConverter;
	break;
    default:
	return 0;
    }
    return 0;
}

const char* CConverter::convert(const char*what)
{
    if (count == 0 || what == 0)
	return 0;
    source = what;
    dest = what;
    std::string::size_type str_iter;
    if (dest.size() > 0) {
	for (int i = 0;i < count;i++) {
	    str_iter=0;
	    str_iter = dest.find(source_idents[i],str_iter);
	    while ( str_iter != std::string::npos) {
		dest.erase(str_iter,source_idents[i].size());
		dest.insert(str_iter,target_idents[i]);
		str_iter+=target_idents[i].size();
		//str_iter++;
		str_iter = dest.find(source_idents[i],str_iter);
	    }
	    //dest.replace(source_idents[i].c_str(),target_idents[i].c_str());
	}
    }
    return dest.c_str();
}
