#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_utils.h"
#include "udm_alias.h"
#include "udm_xmalloc.h"


static int cmpalias(const void *s1,const void *s2){
	return(strcmp(((const UDM_ALIAS*)(s1))->find,((const UDM_ALIAS*)(s2))->find));
}

void UdmSortAliases(UDM_ENV * Conf){
	qsort((void*)Conf->Alias,Conf->naliases,sizeof(UDM_ALIAS),cmpalias);
}

__INDLIB__ int UdmAddAlias(UDM_ENV * Conf,char * find,char *replace){
	if(Conf->naliases>=Conf->maliases){
		if(Conf->maliases){
			Conf->maliases+=16;
			Conf->Alias=(UDM_ALIAS *)UdmXrealloc(Conf->Alias,Conf->maliases*sizeof(UDM_ALIAS));
		}else{
			Conf->maliases=16;
			Conf->Alias=(UDM_ALIAS *)UdmXmalloc(Conf->maliases*sizeof(UDM_ALIAS));
		}
	}
	Conf->Alias[Conf->naliases].find=strdup(find);
	Conf->Alias[Conf->naliases].replace=strdup(replace);
	Conf->naliases++;
	return(0);
}

void UdmFreeAliases(UDM_ENV * Conf){
	size_t i;
	for(i=0;i<Conf->naliases;i++){
		free(Conf->Alias[i].find);
		free(Conf->Alias[i].replace);
	}
	Conf->naliases=0;
	Conf->maliases=0;
	UDM_FREE(Conf->Alias);
}

UDM_ALIAS * UdmFindAlias(UDM_ENV * Conf,char * alias){
	size_t i;
	for(i=0;i<Conf->naliases;i++){
		if(!strncmp(Conf->Alias[i].find,alias,strlen(Conf->Alias[i].find))){
			return(&Conf->Alias[i]);
		}
	}
	return(NULL);

	/*
	int l,c,r,res;
	l=0;r=Conf->naliases-1;
	while(l<=r){
		c=(l+r)>>1;
		res=strncmp(Conf->Alias[c].find,alias,strlen(Conf->Alias[c].find));
		if(res<0){
			l=c+1;
		}else
		if(res>0){
			r=c-1;	
		}else{
			return(&Conf->Alias[c]);
		}
	}
	return(NULL);
	*/
}
