#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udm_common.h"
#include "udm_socket.h"
#include "udm_host.h"
#include "udm_utils.h"
#include "udm_xmalloc.h"
#include "udm_http.h"
#include "udm_conf.h"


int http_connect(UDM_ENV * Conf,UDM_CONN *connp, char *hostname, int port, int timeout){
	size_t len;
    
        if (!connp)
                return -1;

        if (!hostname)
    		return -1;

	if (!port)
		return -1;
	connp->port = port;
	connp->timeout = timeout;

        len = strlen(hostname);
        connp->hostname = UdmXrealloc(connp->hostname, len+1);
        udm_snprintf(connp->hostname, len+1, "%s", hostname);

        if (UdmHostLookup(Conf,connp))
                return -1;

        if (socket_open(connp))
                return -1;

        if (socket_connect(connp))
                return -1;
					        				
	return 0;
}

UDM_HTTP_HDR * http_parse_header(char *buf){
char *header, *tok, *lt;
UDM_HTTP_HDR *http_hdr;

	http_hdr = UdmXmalloc(sizeof(UDM_HTTP_HDR));

        if ((http_hdr->body_ptr = strstr(buf, "\r\n\r\n")))
                http_hdr->body_ptr +=4;
        else if ((http_hdr->body_ptr = strstr(buf, "\n\n")))
                http_hdr->body_ptr +=2;
	else 
		return NULL;

	http_hdr->hdr_size = http_hdr->body_ptr-buf;
	header = UdmXmalloc(http_hdr->hdr_size+1);
	memcpy(header, buf, http_hdr->hdr_size);

        tok=UdmGetToken(header,"\r\n",&lt);
        while(tok){
                if(!UDM_STRNCASECMP(tok,"HTTP/")){
                        http_hdr->status=atoi(tok+8);
			http_hdr->http_lo_version = atoi(tok+7);
                }else
                /*
                FIXME!!!
                if ((Force1251) && (!UDM_STRNCASECMP(tok,"Server: "))){
                        char * sname;
			sname=UdmTrim(tok+7," ");
                        if (!UDM_STRNCASECMP(sname,"Microsoft")||
                                !UDM_STRNCASECMP(sname,"IIS")){
					http_hdr->charset = UdmXmalloc(13);
                                        sprintf(http_hdr->charset, "windows-1251");
			}
                }else
                */
                if(!UDM_STRNCASECMP(tok,"Content-Type: ")){
                        char *p;
			http_hdr->content_type = strdup(tok+14);
                        if((p=strstr(http_hdr->content_type,"charset=")))
	                        http_hdr->charset = strdup(p+8);
                }else
                if(!UDM_STRNCASECMP(tok,"Location: ")){
                        http_hdr->location=strdup(tok+10);
                }else
                if(!UDM_STRNCASECMP(tok,"Content-Length: ")){
                        http_hdr->content_length=atoi(tok+16);
                }else
                if(!UDM_STRNCASECMP(tok,"Content-Range: ")){
                        char *p;
                        if((p=strchr(tok+14, '/')))
                    		http_hdr->content_range=atoi(p+1);
                }else
                if(!UDM_STRNCASECMP(tok,"Subject: ")){
			http_hdr->subject = strdup(tok+9);
                }else
                if(!UDM_STRNCASECMP(tok,"From: ")){
                        http_hdr->from = strdup(tok+6);
                }else
                if(!UDM_STRNCASECMP(tok,"Newsgroups: ")){
                        http_hdr->newsgroups = strdup(tok+12);
                }else
                if(!UDM_STRNCASECMP(tok,"Date: ")){
                        http_hdr->date = strdup(tok+6);
                }else
                if(!UDM_STRNCASECMP(tok,"References: ")){
                        http_hdr->references = strdup(tok+12);
                }else
                if(!UDM_STRNCASECMP(tok,"Last-Modified: ")){
                        http_hdr->last_modified=UdmHttpDate2Time_t(tok+15);
                }
                if(!UDM_STRNCASECMP(tok,"Accept-Ranges:")){
                        http_hdr->accept_ranges=1;
                }
/*                UdmLog(Indexer,UDM_LOG_DEBUG,"%s",tok);*/
                tok=UdmGetToken(NULL,"\r\n",&lt);
        }
	UDM_FREE(header);
	return http_hdr;	
}

void http_hdr_free(UDM_HTTP_HDR *http_hdr){
	
	if (!http_hdr)
		return;
        UDM_FREE(http_hdr->content_type);
        UDM_FREE(http_hdr->charset);
        UDM_FREE(http_hdr->location);
        UDM_FREE(http_hdr->subject);
        UDM_FREE(http_hdr->from);
        UDM_FREE(http_hdr->newsgroups);
        UDM_FREE(http_hdr->date);
        UDM_FREE(http_hdr->references);

	UDM_FREE(http_hdr);
	return;
}
