# copyright (C) 1997-2002 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: odbcquery.tcl,v 1.5 2002/01/19 12:15:54 jfontain Exp $}


package provide odbcquery [lindex {$Revision: 1.5 $} 1]
if {[lsearch -exact $auto_path /usr/lib]<0} {                         ;# in case Tcl/Tk is somewhere else than in the /usr hierarchy
    lappend auto_path /usr/lib
}
package require tclodbc 2                                           ;# so that it works with both UNIX 2.2.1 et Windows 2.3 versions


namespace eval odbcquery {

    array set data {
        updates 0
        0,label {} 0,type integer 0,message {row number in order of arrival}
        pollTimes {10 5 20 30 60 120 300}
        switches {--dsn 1 --password 1 -q 1 --query 1 --swap 0 -t 1 --table 1 --user 1}
        sort {0 increasing}
    }
    set file [open odbcquery.htm]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable connection
        variable data
        variable statement

        if {![info exists options(--dsn)]} {
            error {data source name (--dsn) must be specified}
        }
        catch {set query $options(-q)}
        catch {set query $options(--query)}                                                                     ;# favor long option
        catch {set table $options(-t)}
        catch {set table $options(--table)}                                                                     ;# favor long option
        if {[info exists query]&&[info exists table]} {
            error {use either table or query option but not both}
        }
        if {[info exists query]} {
            set statement $query
        } elseif {[info exists table]} {
            set statement "select * from $table"
        } else {
            error {either query (-q (--query)) or table (-t (--table)) must be specified}
        }
        catch {set user $::env(USER)}                                                                                  ;# by default
        catch {set user $::env(LOGNAME)}                                                          ;# more common in UNIX and even NT
        catch {set user $options(--user)}
        set arguments [list $options(--dsn)]
        catch {lappend arguments $user}
        catch {lappend arguments $options(--password)}
        set connection [eval database odbc $arguments]                                               ;# use a unique connection name
        set data(identifier) odbcquery($options(--dsn))
        $connection statement $connection.query $statement
        set column 1
        foreach list [$connection.query columns label type typename displaysize] {
            foreach {name code type width} $list {}
            set data($column,label) $name
            if {($code==-6)||($code==-5)||(($code>=2)&&($code<=8))} {                                                ;# numeric type
                set data($column,type) real                     ;# so that cell may be dropped in viewers that expect a numeric type
                set data($column,message) "$name ($type)"            ;# do not display width, which equals zero, at least with MySQL
            } elseif {($code==-1)||($code==1)||($code==12)} {                                                         ;# string type
                set data($column,type) ascii
                set data($column,anchor) left
                set data($column,message) "$name (${type}($width))"
            } else {
                set data($column,type) ascii
                set data($column,message) "$name ($type)"
            }
            incr column
        }
        if {[info exists options(--swap)]} {
            for {set index 0} {$index<$column} {incr index} {
                lappend indices $index
            }
            set data(views) [list [list indices $indices swap 1]]
        }
        $connection.query execute
        while {[llength [$connection.query fetch]]>0} {}
        $connection.query drop
    }

    proc update {} {
        variable connection
        variable statement
        variable data

        array unset data {[0-9]*,[0-9]*}                                                                    ;# clear data every time
        if {[catch {$connection statement $connection.query $statement; $connection.query execute} message]} {
            flashMessage "odbcquery error: $message"                                                      ;# problem reaching server
        } else {
            set row 0
            while {[llength [set list [$connection.query fetch]]]>0} {
                set data($row,0) $row
                set column 1
                foreach value $list {
                    set data($row,$column) $value
                    incr column
                }
                incr row
            }
        }
        catch {$connection.query drop}                ;# ignore connection errors at this point (they will be reported at next poll)
        incr data(updates)
    }

    proc terminate {} {
        variable connection
        catch {$connection disconnect}
    }

}
