package mysqladmin;


/** Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.1 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import javax.swing.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;
import javax.swing.JPanel; 
import javax.swing.JFrame;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.border.*;


public class Admin extends JFrame implements WindowListener, ActionListener, MouseListener {

    private static String version = "1.1";
    private SplashScreen Splash;
    ImageIcon genImgIcon;
    JPopupMenu popup;
    JLayeredPane lc;
    JInternalFrame desktop;
    JList tableList;
    String[] table;
    String newdb;
    private Properties prop;
    private Qbe qbePanel;
    private AutoForm formPanel;
    private JCheckBoxMenuItem m30;
    private Color defaultColor;

    private ChooseColor cg;
    private JMenuBar menubar;
    private JInternalFrame msgFrame, qbeFrame, createFrame, createIdxFrame, formFrame,dropperFrame, aboutFrame,colorFrame,gplFrame,payFrame;
    private JTable tableView;
    public JCheckBox[] userChoice;
    public JTextField  hostHost, hostDB, userHost,userDb, userUser, dbHost, dbUser, dbDb,  User, propsHost, propsDB, propsmySQL;
    public JTextArea query, dbInfo, tableInfo, msgBoard;
    // public JPasswordField password,userPassword;
    public JTextField password, userPassword;

    private CreateTable crTa;
    private DataBaseLogin logOn;

    private MsgBoard mb;

    int mouseX;
    
    /**
       * Get the value of mouseX.
       * @return Value of mouseX.
       */
    public int getMouseX() {
	if (mouseX < 1) mouseX = 1;
	return mouseX;
    }
    
    /**
       * Set the value of mouseX.
       * @param v  Value to assign to mouseX.
       */
    public void setMouseX(int  v) {this.mouseX = v;}
    


    int mouseY;
    
    /**
       * Get the value of mouseY.
       * @return Value of mouseY.
       */
    public int getMouseY() {

	if ( mouseY < 1) mouseY=1;
	return mouseY;
    }
    
    /**
       * Set the value of mouseY.
       * @param v  Value to assign to mouseY.
       */
    public void setMouseY(int  v) {this.mouseY = v;}
    
    /**
       * Get the value of .
       * @return Value of .
       */

    private boolean testConnection() {

        String msg = "Connection established";
	boolean ok = true;
	String rdbms = " ";
        t_connect con = new t_connect(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase());
       if (con.getError() != null) {
           msg=con.getError();
	   ok = false;
       } else {
	   try {
	       DatabaseMetaData md = con.con.getMetaData();
	       rdbms =  md.getDatabaseProductName();
	       con.close();
	   } catch (Exception exception) {
	       msg=exception.getMessage().toString();
               ok = false;
	   }
       }
        mb.addText("JDBC-Driver: " + con.iJDBC);
	mb.addText("JDBC-URL: " + con.iURL);
        mb.addText("DBMS: " + rdbms);
        mb.addText(msg);
        if ( ! ok) { 
	    mb.addText("Something is wrong,\ncan not connect to database");    
	}
        return ok;
    }


    private String getRDBMS() {
	String rdbms = " ";
        t_connect con = new t_connect(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase());
       if (con.getError() != null) {
           message(con.getError());
       } else {
	   try {
	       DatabaseMetaData md = con.con.getMetaData();
	       rdbms =  md.getDatabaseProductName();
	       con.close();
	   } catch (Exception exception) {
	       message(exception.getMessage().toString());
	   }
       }
       return rdbms;

    }
    
 

    public static  void main (String args[]) {

	Admin a = new Admin();
    }



    public Admin(){

    super("Fredy's SQL Admintool Version: "+ version);


    this.setIconImage(Toolkit.getDefaultToolkit().getImage(Admin.class.getResource("images"+ File.separator + "icon.gif")));

    splash();
    // Load Properties
    prop = new Properties();
 
    // this is the same dir as the class: Admin.class.getResourceAsStream
    // but we put the props-File in the user's home-dir
    try {
	FileInputStream fip = new FileInputStream(System.getProperty("user.home")+File.separator+"admin.props");
	prop.load(fip);
    }
    catch (Exception ioex) {
	System.out.println("Exception while loading props:" +ioex + "\n\nCreating default-file admin.props\nhost=localhost\nuser="+System.getProperty("user.name")+"\ndb=none\nwidth=600\nheigth=400\nmysqladmin=/usr/local/mysql/bin/mysqladmin\nusePassword=yes\nJDBCdriver=org.gjt.mm.mysql.Driver\nJDBCurl=jdbc:mysql://\nDatabasePort=3306\nRDBMS=mysql");
       prop.put("host","localhost");
       prop.put("user",System.getProperty("user.name"));
       prop.put("db","");
       prop.put("width","600");
       prop.put("heigth","400");
       prop.put("mysqladmin","/usr/local/mysql/bin/mysqladmin");
       prop.put("usePassword","yes");
       prop.put("JDBCdriver","org.gjt.mm.mysql.Driver");
       prop.put("JDBCurl","jdbc:mysql://");
       prop.put("DatabasePort","3306");
       prop.put("RDBMS","mysql");
    }

    genImgIcon = loadImage("generated.gif");
	

    lc = new JDesktopPane();
    lc.setOpaque(false);
    defaultColor = lc.getBackground();

    mb = new MsgBoard();

    lc.add(login(),JLayeredPane.PALETTE_LAYER);

    JScrollPane mc = new JScrollPane();   
    mc.getViewport().add(lc);

    this.getContentPane().setLayout(new BorderLayout());
    this.getContentPane().add("Center",mc);
    this.addMouseListener(this);


    this.setSize(Integer.parseInt(prop.getProperty("width")),Integer.parseInt(prop.getProperty("heigth")));

    Splash.close();


    this.setVisible(true);
    } 


    public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand();
     if (command.equals("exit")) goodbye(); 
    }
    public void windowClosing(WindowEvent evt) {goodbye();}  
    public void windowActivated(WindowEvent evt) {;}  
    public void windowDeactivated(WindowEvent evt) {;}  
    public void windowIconified(WindowEvent evt) {;}  
    public void windowDeiconified(WindowEvent evt) {;}  
    public void windowOpened(WindowEvent evt) {;}  
    public void windowClosed(WindowEvent evt) {;}  
 
    public void processMouseEvent(MouseEvent e) {
        
	if ((popup != null) && e.isPopupTrigger()) {
	    popup.show(this,e.getX(), e.getY());
	    setMouseX(e.getX());
	    setMouseY(e.getY());   
	}
    }
    public void mouseClicked(MouseEvent e) {
	if ((popup != null) && e.isPopupTrigger()) {
	    popup.show(this,e.getX(), e.getY());
	    setMouseX(e.getX());
	    setMouseY(e.getY());
	}
        else {
	super.processMouseEvent(e);
	}
    }
    public void mousePressed(MouseEvent e) {;}
    public void mouseReleased(MouseEvent e) {;}
    public void mouseEntered(MouseEvent e) {;}
    public void mouseExited(MouseEvent e) {;}


    private void splash() {


        Splash= new SplashScreen(loadImage("admin.gif"));
           try{
	     
             Splash.showStatus("Welcome to Fredy's");
             Thread.sleep(1500);
             Splash.showStatus("Admin-Tool for SQL V"+version);
             Thread.sleep(1500);
             Splash.showStatus("Fredy Fischer");
             Thread.sleep(1500);
             Splash.showStatus("Hulmenweg 36");
             Thread.sleep(1500);
             Splash.showStatus("CH-8405 Winterthur");

           } catch(Exception e){e.printStackTrace();}


    }



    private JInternalFrame login() {


       Container contentPane;

       JInternalFrame log = new JInternalFrame("Login",true,false,true,true);
       contentPane = log.getContentPane();
       contentPane.setLayout(new FlowLayout());      

       logOn = new DataBaseLogin(prop.getProperty("RDBMS"));

       Dimension dim = new Dimension(logOn.getPreferredSize());
       log.setBounds(getMouseX(), getMouseY(), dim.width, dim.height+30);


       setLogOnValues();

       contentPane.add(logOn);

       logOn.lPassword.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       saveConnectProperties();
               if (testConnection()) {
		   lc.add(pm());
		   normalMenu();
	       }
	       }});
       

       logOn.connect.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       saveConnectProperties();
	       if (testConnection()) {
		   lc.add(pm());
		   normalMenu();
	       }
	       }});
       

       logOn.cancel.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
             String string1 = "Yes";
             String string2 = "No";
             Object[] options = {string1, string2};
             int n = JOptionPane.showOptionDialog(null,
                              "Do you really want to leave?",
                              "Quit Admin?",
                              JOptionPane.YES_NO_OPTION,
                              JOptionPane.QUESTION_MESSAGE,
                              null,     //don't use a custom Icon
                              options,  //the titles of buttons
                              string2); //the title of the default button
               if (n == JOptionPane.YES_OPTION)   System.exit(0);
	       }});
       return log;
    }
 


   private JInternalFrame users() {

       
       Container contentPane;

       JInternalFrame frame = new JInternalFrame("User",true,true,true,true);
       contentPane = frame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       frame.setBounds(getMouseX(), getMouseY(), 400, 300);

       JPanel     panel = new JPanel();
       panel.setLayout(new BorderLayout());


       JPanel     panel1 = new JPanel();
          ColumnLayout layout1 = new ColumnLayout(5,5,10,2);
          panel1.setLayout(layout1);
           JLabel label = new JLabel();
	   label.setText("Host");
	   panel1.add(label);


           JLabel label3 = new JLabel("Database");
           panel1.add(label3);

           JLabel label1 = new JLabel();
	   label1.setText("User");
           panel1.add(label1);


           JLabel label2 = new JLabel();
	   label2.setText("Password");
           panel1.add(label2);



       JPanel     panel2 = new JPanel();
          ColumnLayout layout2 = new ColumnLayout(5,5,5,0);
          panel2.setLayout(layout2);

          userHost = new JTextField(15);
	  userHost.setText("%");
	  userUser = new JTextField(15);
          userDb   = new JTextField(15);
	  //userPassword = new JPasswordField(null,15);
	  userPassword = new JTextField(null,15);

	  panel2.add(userHost);
	  panel2.add(userDb);
	  panel2.add(userUser);
	  panel2.add(userPassword);

          JLabel l = new JLabel(loadImage("mysql-06.gif"));
          panel2.add(l);


       Box box1 = Box.createVerticalBox();
	   String[] choices = { "Select Priv", "Insert Priv", "Update Priv", 
				"Delete Priv", "Create Priv", "Drop Priv",
	                        "Reload Priv", "Shutdown Priv", "Process Priv", "File Priv","Grant_priv","References_priv","Index_priv","Alter_priv"};
	   String[] tips = { "Select Privilegs", "Insert Privilegs", "Update Privilegs", 
				"Delete Privilegs", "Create Privilegs", "Drop Privilegs",
	                        "Reload Privilegs", "Shutdown Privilegs","Process Privilegs", "File Privilegs","Grant","Ref","Index","Alter" }; 

      userChoice = new JCheckBox[choices.length];
      for (int i = 0; i < choices.length; i++) {
	   userChoice[i] = new JCheckBox(choices[i]);
	   userChoice[i].setToolTipText(tips[i]);
	   box1.add(userChoice[i]);
      }



     JPanel buttonPanel = new JPanel();
     buttonPanel.setLayout(new FlowLayout());
     buttonPanel.setBorder(BorderFactory.createEtchedBorder());

     JButton list = new JButton("List");
     JButton insert = new JButton("Insert");
     JButton delete = new JButton("Delete");

      insert.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
	    String pos = " ";

             t_connect con = new t_connect(logOn.getHost(), logOn.getUser(), logOn.getPassword(),"mysql");
	     if (con.getError() != null) {
                 message(con.getError());
             } else {
		 try
		     {
			 // first insert into user-Table of mysql
			 pos = "user";
			 int records = con.stmt.executeUpdate("insert into user " +
				"values ('"+userHost.getText()+"', '"+userUser.getText() + "',PASSWORD('"+userPassword.getText()+"')" +
						       ", '" + checkPriv(userChoice[0]) + 
						       "', '" + checkPriv(userChoice[1]) +
						       "', '" + checkPriv(userChoice[2]) + 
						       "', '" + checkPriv(userChoice[3]) + 
						       "', '" + checkPriv(userChoice[4]) + 
						       "', '" + checkPriv(userChoice[5]) +
						       "', '" + checkPriv(userChoice[6]) +
						       "', '" + checkPriv(userChoice[7]) +
						       "', '" + checkPriv(userChoice[8]) +
						       "', '" + checkPriv(userChoice[9]) +
						       "', '" + checkPriv(userChoice[10]) +
						       "', '" + checkPriv(userChoice[11]) +
						       "', '" + checkPriv(userChoice[12]) +
						       "', '" + checkPriv(userChoice[13]) + "')");
			 // then insert into DB
			 pos = "db";
			 int records1 = con.stmt.executeUpdate("insert into db " + 
				  "values ('"+userHost.getText() +"','"+userDb.getText() + "','"+userUser.getText() +  
						       "', '" + checkPriv(userChoice[0]) + 
						       "', '" + checkPriv(userChoice[1]) +
						       "', '" + checkPriv(userChoice[2]) + 
						       "', '" + checkPriv(userChoice[3]) + 
						       "', '" + checkPriv(userChoice[4]) + 
						       "', '" + checkPriv(userChoice[5]) +
						       "', '" + checkPriv(userChoice[6]) +
						       "', '" + checkPriv(userChoice[7]) +
						       "', '" + checkPriv(userChoice[8]) +
						       "', '" + checkPriv(userChoice[9]) + "')");
			 con.close();
		     }
		 catch (Exception excpt) {
		     message("affected: " + pos + "\n"+excpt.getMessage().toString());
		 }
	     }
        }});
     

      delete.addActionListener(new ActionListener() {
	  public void actionPerformed(ActionEvent e) {


            t_connect con = new t_connect(logOn.getHost(), logOn.getUser(), logOn.getPassword(),"mysql");
	    if (con.getError() != null) {
                 message(con.getError());
            } else {
	      try
	      {
		 // first delete from user-Table of mysql
		  int records = con.stmt.executeUpdate("delete from user where User = '"+ userUser.getText()+"'");
		  // then delete from DB
                 int records1 = con.stmt.executeUpdate("delete from db where User = '"+ userUser.getText()+"'"); 
		 con.close();
	      }
	      catch (Exception excpt) {
		  message(excpt.getMessage().toString());
	      }
	    }  
      }});
      


      list.addActionListener(new ActionListener() {
	  public void actionPerformed(ActionEvent e) {
	     sqlTable sqlt = new sqlTable(logOn.getHost(),logOn.getUser(),logOn.getPassword(),"mysql","select * from user");
	     sqlt.setBounds(getMouseX(), getMouseY(),500,215);
	     sqlt.setTitle("User-List");
	     lc.add(sqlt,4);	     
	     sqlt.moveToFront();
      }});
	  
      buttonPanel.add(list);
      buttonPanel.add(insert);
      buttonPanel.add(delete);


       panel.add("West",panel1);
       panel.add("Center",panel2);
       panel.add("East",box1);
       panel.add("South",buttonPanel);


       JScrollPane mc = new JScrollPane();   
       mc.getViewport().add(panel);

       contentPane.add("Center",mc);

       return frame;
       }

    private String checkPriv(JCheckBox b) {
	if (b.isSelected()) {
	    return "Y";
        }
        else {
	    return"N";
	}


    }       


    private void message(String msg) {
        //JOptionPane.showMessageDialog(this, msg);
        JOptionPane.showMessageDialog(null, msg,"Message",JOptionPane.WARNING_MESSAGE);
    }


 
   private JInternalFrame dbs() {


       Container contentPane;

       JInternalFrame frame = new JInternalFrame("Databases",true,false,true,true);
       contentPane = frame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       frame.setBounds(getMouseX(), getMouseY(), 400, 215);

       JPanel     panel = new JPanel();
       panel.setLayout(new BorderLayout());


       JPanel     panel1 = new JPanel();
          ColumnLayout layout1 = new ColumnLayout(5,5,10,2);
          panel1.setLayout(layout1);
           JLabel label = new JLabel();
	   label.setText("Host");
	   panel1.add(label);

           JLabel label1 = new JLabel();
	   label1.setText("Db");
           panel1.add(label1);


           JLabel label2 = new JLabel();
	   label2.setText("User");
           panel1.add(label2);



       JPanel     panel2 = new JPanel();
          ColumnLayout layout2 = new ColumnLayout(5,5,5,0);
          panel2.setLayout(layout2);

          dbHost = new JTextField(15);
	  dbDb   = new JTextField(15);
	  dbUser = new JTextField(15);

	  panel2.add(dbHost);
	  panel2.add(dbDb);
	  panel2.add(dbUser);

          JLabel l = new JLabel(loadImage("mysql-06.gi"));
          panel2.add(l);


       Box box1 = Box.createVerticalBox();
	   String[] choices = { "Select Priv", "Insert Priv", "Update Priv", 
				"Delete Priv", "Create Priv", "Drop Priv"};
	   String[] tips = { "Select Privilegs", "Insert Privilegs", "Update Privilegs", 
			     "Delete Privilegs", "Create Privilegs", "Drop Privilegs"};
      for (int i = 0; i < choices.length; i++) {
	   JCheckBox b = new JCheckBox(choices[i]);
	   b.setToolTipText(tips[i]);
	   box1.add(b);
      }


     JPanel buttonPanel = new JPanel();
     buttonPanel.setLayout(new FlowLayout());
     buttonPanel.setBorder(BorderFactory.createEtchedBorder());

     JButton list = new JButton("List");
     JButton modify = new JButton("Modify");
     JButton insert = new JButton("Insert");
     JButton delete = new JButton("Delete");

     buttonPanel.add(list);
     buttonPanel.add(modify);
     buttonPanel.add(insert);
     buttonPanel.add(delete);


       panel.add("West",panel1);
       panel.add("Center",panel2);
       panel.add("East",box1);
       panel.add("South",buttonPanel);


       JScrollPane mc = new JScrollPane();   
       mc.getViewport().add(panel);

       contentPane.add("Center",mc);

       return frame;
    }

    private JInternalFrame setColor() {
       Container contentPane;

       colorFrame = new JInternalFrame("Color",true,true,true,true);
       contentPane = colorFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       colorFrame.setBounds(getMouseX(), getMouseY(), 420, 400);

       cg = new ChooseColor(defaultColor);
       contentPane.add("Center",cg);
       cg.select.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       lc.setBackground(cg.getColor());
	       lc.updateUI();
	       colorFrame.dispose();
	       }});
       cg.cancel.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       colorFrame.dispose();
	       }});
       return colorFrame;

    }

    

    private JInternalFrame qbe() {
       Container contentPane;

       qbeFrame = new JInternalFrame("QBE",true,true,true,true);
       contentPane = qbeFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       qbeFrame.setBounds(getMouseX(), getMouseY(), 560, 310);
       qbeFrame.setFrameIcon(genImgIcon);

       qbePanel = new Qbe(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase());

     qbePanel.cancel.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
	     qbeFrame.dispose();
	 }});
 
     qbePanel.execQuery.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
	      sqlTable sqlt = new sqlTable(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase(),qbePanel.getQuery());
	       sqlt.setBounds(getMouseX(), getMouseY(),500,215);
	       sqlt.setTitle("Generated query");
	       sqlt.setFrameIcon(genImgIcon);
               lc.add(sqlt,4);
	       qbeFrame.moveToBack();
	       sqlt.moveToFront();

	 }});


       JScrollPane mc = new JScrollPane();   
       mc.getViewport().add(qbePanel);

       contentPane.add("Center",mc);

       return qbeFrame;
    }

   private JInternalFrame form() {
       Container contentPane;

       formFrame = new JInternalFrame("Form",true,true,true,true);
       contentPane = formFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       formFrame.setBounds(getMouseX(), getMouseY(), 560, 310);
       formFrame.setFrameIcon(genImgIcon);

       formPanel = new AutoForm(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase());

       formFrame.addComponentListener(new ComponentAdapter() {
	   public void componentHidden(ComponentEvent e) {}
	   public void componentMoved(ComponentEvent e) {}
	   public void componentResized(ComponentEvent e) {
	       Dimension d = new Dimension();
	       d = formFrame.getSize();
	       Integer intx = new Integer(d.width);
	       Integer inty = new Integer(d.height);
	       double fx = intx.floatValue() * 0.75;
	       double fy = inty.floatValue() * 0.65;
	       Double dfx = new Double(fx);
	       Double dfy = new Double(fy);
 
	       formPanel.setVSize(dfx.intValue(), dfy.intValue() );
	       formPanel.setFormSize();
	   }
	   public void componentShown(ComponentEvent e) {}
       });
       

      
     formPanel.cancel.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
	    formFrame.dispose();
	 }});
     
       JScrollPane mc = new JScrollPane();   
       mc.getViewport().add(formPanel);
    
       contentPane.add("Center",mc);

       return formFrame;
    }

   private JInternalFrame dropTable() {
       Container contentPane;

       dropperFrame = new JInternalFrame("Drop Table",true,true,true,true);
       contentPane = dropperFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       dropperFrame.setBounds(getMouseX(), getMouseY(),300, 220);
       dropperFrame.setFrameIcon(genImgIcon);

       DropTable panel = new DropTable(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase());

      
      panel.cancel.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
	    dropperFrame.dispose();
	 }});
     
       JScrollPane mc = new JScrollPane();   
       mc.getViewport().add(panel);
    
       contentPane.add("Center",mc);

       return dropperFrame;
    }


    private JInternalFrame select() {


       Container contentPane;

       final JInternalFrame frame = new JInternalFrame("SQL",true,true,true,true);
       contentPane = frame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       frame.setBounds(getMouseX(), getMouseY(), 400, 215);

       JPanel panel = new JPanel();
       panel.setLayout(new BorderLayout());

       query = new JTextArea("",10,30);
  
	JScrollPane scrollpane = new JScrollPane();
        scrollpane.getViewport().add(query);


     JPanel buttonPanel = new JPanel();
     buttonPanel.setLayout(new FlowLayout());
     buttonPanel.setBorder(BorderFactory.createEtchedBorder());

     JButton button = new JButton("Execute");
	button.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {


	    /** if it is a query send it to the table, otherwise execute
	     *  the command and display the result of the command in the
	     *  message board
	     */
	    if ( query.getText().toLowerCase().startsWith("select") | query.getText().toLowerCase().startsWith("show") ) {
         	    sqlTable sqlt = new sqlTable(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase(),query.getText());
	           sqlt.setBounds(getMouseX(), getMouseY(),500,215);
	           sqlt.setTitle("Query on " + logOn.getDatabase());
         	   lc.add(sqlt,4);
		   sqlt.moveToFront();

	    } else {
               t_connect con = new t_connect(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase());
	     if (con.getError() != null) {
                 message(con.getError());
             } else {
	     try
	       {
		  int records = con.stmt.executeUpdate(query.getText());
		  message(Integer.toString(records)+" rows affected");
		  con.close();
	       } catch (Exception excpt) {
               message(excpt.getMessage().toString());
               } 
	     }
	    }
        }});
     
	JButton clear = new JButton("Clear");
	clear.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
	  query.setText(null);;
        }});


	JButton cancel = new JButton("Cancel");
	cancel.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		frame.dispose();
		}});
	
     
       buttonPanel.add(button);
       buttonPanel.add(clear);
       buttonPanel.add(cancel);


       panel.add("Center",scrollpane);
       panel.add("South",buttonPanel);


       JScrollPane mc = new JScrollPane();   
       mc.getViewport().add(panel);

       contentPane.add("Center",mc);

       return frame;
    }


    private JMenu dbOpsMenu() {

	JMenu m0 = new JMenu("Database operations");

 	JMenuItem m01 = new JMenuItem("Create Tables");
        m01.setActionCommand("createTables");
	m01.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
	      lc.add(createTable(),4);
        }});

 	JMenuItem m0a = new JMenuItem("Create Index");
	m0a.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
	      lc.add(createIndex(),4);
        }});

 	JMenuItem m02 = new JMenuItem("Drop Tables");
        m02.setActionCommand("dropTables");
	m02.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
           lc.add(dropTable(),4);
	   dropperFrame.moveToFront();
        }});

 	JMenuItem m03 = new JMenuItem("Create User");
        m03.setToolTipText("must have acces to mysql-database");
	m03.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
	    lc.add(users(),3); ;
        }});
	
 	JMenuItem m04 = new JMenuItem("Create Database");
        m04.setToolTipText("must have acces to mysql-database and File-Create Permissions");
	m04.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
	    createDB();
        }});
	
 	JMenuItem m05 = new JMenuItem("Drop Database");
        m05.setToolTipText("must have acces to mysql-database and File-Create Permissions");
	m05.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
	    deleteDB();
        }});
      m0.add(m02);
      m0.add(m01);
      m0.add(m0a);
      m0.add(m03);
      m0.add(m04);
      m0.add(m05);

      return m0;

    }

 
    private JMenu dataOpsMenu() {
	JMenu m1 = new JMenu("Data operations");

 	JMenuItem m10 = new JMenuItem("guided query");
        m1.add(m10);
	m10.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            lc.add(qbe(),4);
        }});

 	JMenuItem m11 = new JMenuItem("Form");
        m1.add(m11);
	m11.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            lc.add(form(),4);
        }});

 	JMenuItem m12 = new JMenuItem("SQL Monitor");
        m1.add(m12);
	m12.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            lc.add(select(),4);
        }});

	return m1;

    }


    private JMenuItem dbInfoMenu() {

 	JMenuItem m2 = new JMenuItem("Database Info");
	m2.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            databaseInfo(logOn.getDatabase());
        }});
	return m2;
    }



    private JMenuItem generateCode() {

 	JMenuItem m2 = new JMenuItem("Generate Java-Code");
	m2.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
	   GenerateCode gc = new GenerateCode(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase());
	   Dimension dim = gc.getPreferredSize();
           newFrame(gc,"Generate Java-Code",true, true, true, true, getMouseX(), getMouseY(),dim.width,dim.height + 20,gc.cancel);
        }});
	return m2;
    }    

    private JMenu propsMenu() {


	JMenu m3 = new JMenu("Properties");
        m30 = new JCheckBoxMenuItem("Save on exit");
	m30.setState(true);
	m30.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {		
	}});
 
	m3.add(m30);
	
	JMenuItem m31 = new JMenuItem("Select background color");
	m31.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) { 
	      lc.add(setColor(),4);
		}});
	
	m3.add(m31);

	return m3;
    }



    private JMenu progMenu() {
	JMenu m4 = new JMenu("Programs");
	JMenuItem m40 = new JMenuItem("Execute Command");
	m40.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		execCMD();
	}});
	m4.add(m40);
	return m4;

    }


    private JMenuItem aboutMenu() {

	JMenuItem m5 = new JMenuItem("About");
	m5.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		about();
		}});
	
	return m5;
    }


    private JMenu laf() {

	JMenu lookfeel = new JMenu("Look & Feel");
	ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem windowsMenuItem = (JRadioButtonMenuItem) lookfeel.add(new JRadioButtonMenuItem("Windows Style Look and Feel"));
	windowsMenuItem.addActionListener(new ActionListener() {
	                       public void actionPerformed(ActionEvent e) {
				   lnfchange("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
			       }});
	windowsMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Windows"));
	group.add(windowsMenuItem);
	windowsMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1, ActionEvent.ALT_MASK));

        JRadioButtonMenuItem motifMenuItem = (JRadioButtonMenuItem) lookfeel.add(new JRadioButtonMenuItem("Motif Look and Feel"));
	motifMenuItem.addActionListener(new ActionListener() {
	                       public void actionPerformed(ActionEvent e) {
				   lnfchange("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
			       }});
	motifMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("CDE/Motif"));
	group.add(motifMenuItem);
	motifMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_2, ActionEvent.ALT_MASK));

        JRadioButtonMenuItem metalMenuItem = (JRadioButtonMenuItem) lookfeel.add(new JRadioButtonMenuItem("Metal Look and Feel"));
	metalMenuItem.addActionListener(new ActionListener() {
	                       public void actionPerformed(ActionEvent e) {
				   lnfchange("javax.swing.plaf.metal.MetalLookAndFeel");
			       }});
	metalMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Metal"));
	metalMenuItem.setSelected(true);
	group.add(metalMenuItem);

	return lookfeel;

    }


    private JMenuItem exitMenu() {

	JMenuItem mx = new JMenuItem("Exit");
        mx.setActionCommand("exit");
        popup.add(mx);
	mx.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
	    goodbye();
        }});

	return mx;

    }


    private void normalMenu() {

	menubar = new JMenuBar();
	JMenu fileMenu = new JMenu("File");
	JMenu helpMenu = new JMenu("Help");
	fileMenu.add(dbInfoMenu());
	fileMenu.add(new JSeparator());
	fileMenu.add(generateCode());
	fileMenu.add(new JSeparator());
	fileMenu.add(exitMenu());
	helpMenu.add(aboutMenu());

	menubar.add(fileMenu);
	menubar.add(dataOpsMenu());
	menubar.add(dbOpsMenu());
	menubar.add(propsMenu());
	menubar.add(progMenu());
	menubar.add(laf());
	menubar.add(Box.createHorizontalGlue());
	menubar.add(helpMenu);
	menubar.setEnabled(false);
	this.getContentPane().add("North",menubar);
	//	this.pack();
	this.setSize(Integer.parseInt(prop.getProperty("width"))+1,Integer.parseInt(prop.getProperty("heigth"))+1);
	this.setSize(Integer.parseInt(prop.getProperty("width")),Integer.parseInt(prop.getProperty("heigth")));
    }


    private JPopupMenu pm() {


	popup = new JPopupMenu("Main Menu");


	popup.add(aboutMenu());
	popup.add(dbInfoMenu());
	popup.add(generateCode());
        popup.add(dataOpsMenu());
	popup.add(dbOpsMenu());
	popup.add(propsMenu());
	popup.add(progMenu());
	popup.add(new JSeparator());
	popup.add(laf());
	popup.add(new JSeparator());
        popup.add(exitMenu());

	return popup;
    }


    public void lnfchange(String lnf) {
            try {
		UIManager.setLookAndFeel(lnf);
		SwingUtilities.updateComponentTreeUI(this);
            } 
	    catch (Exception exc) {
               message("can not load look & feel: " + lnf);
            }
	    this.setSize(Integer.parseInt(prop.getProperty("width")),Integer.parseInt(prop.getProperty("heigth")));
	    //this.setVisible(true);
	    //this.pack();
    }


    private void databaseInfo(String db) {

       Container contentPane;

       tableList = new JList();

       JInternalFrame frame = new JInternalFrame("DB-Info",true,true,true,true);
       contentPane = frame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       frame.setBounds(getMouseX(), getMouseY(), 360, 220);

       JPanel     panel = new JPanel();
       panel.setLayout(new BorderLayout());


       JPanel     panel1 = new JPanel();
       panel1.setLayout(new ColumnLayout(5,5,5,0));
 
       dbInfo = new JTextArea("",3,20);
       dbInfo.setEditable(false);
       JScrollPane scrollpane = new JScrollPane();
       scrollpane.getViewport().add(dbInfo);

       panel1.add((JLabel) new JLabel("About"));
       panel1.add(scrollpane);

       /**
       tableInfo = new JTextArea("",5,10);
       JScrollPane tablepane = new JScrollPane();
       tablepane.getViewport().add(tableInfo);
       panel1.add((JLabel) new JLabel("Table Info"));
       panel1.add(tableInfo);
       **/


     JPanel buttonPanel = new JPanel();
     buttonPanel.setLayout(new FlowLayout());
     buttonPanel.setBorder(BorderFactory.createEtchedBorder());



       t_connect con = new t_connect(logOn.getHost(),logOn.getUser(),logOn.getPassword(),db);
       if (con.getError() != null) {
           message(con.getError());
       } else {
	   try {
	       DatabaseMetaData md = con.con.getMetaData();
	       dbInfo.append("DBMS: \t" + md.getDatabaseProductName() +
			     md.getDatabaseProductVersion()+"\n");
	       dbInfo.append("JDBC Driver: \t" + md.getDriverName() + 
			     md.getDriverVersion()+"\n");
	       dbInfo.append("Database: \t" + db);

	       ResultSet r = md.getTables(db,null,null,null);
	       int i = 0;
	       while (r.next()) { i++;}

	       ResultSet rs = md.getTables(db,null,null,null);
	       table = new String[i];
	       i = 0;
	       while (rs.next()) {
		   table[i] = rs.getString(3);
		   i++;
	       }
	       tableList.setListData(table);
	       con.close();
	   } catch (Exception exception) {
	       message(exception.getMessage().toString());
	   }
       }

       MouseListener mouseListener = new MouseAdapter() {
       public void mouseClicked(MouseEvent e) {
         if (e.getClickCount() == 2) {
             int index = tableList.locationToIndex(e.getPoint());
	     /** this part is especially for mySQL

	     sqlTable sqlt = new sqlTable(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase(),"show columns from " + tableList.getModel().getElementAt(index).toString());
	     sqlt.setBounds(getMouseX(), getMouseY(),500,215);
	     sqlt.setTitle("Info on Table: " + tableList.getModel().getElementAt(index).toString());
	     lc.add(sqlt,4);	     
	     sqlt.moveToFront();

	     sqlTable sqlt1 = new sqlTable(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase(),"show index from " + tableList.getModel().getElementAt(index).toString());
	     sqlt1.setBounds(getMouseX()+20, getMouseY()+30,500,215);
	     sqlt1.setTitle("Index Info on Table: " + tableList.getModel().getElementAt(index).toString());
	     lc.add(sqlt1,4);	     
	     sqlt1.moveToBack();

	     **/

	    TableMetaData tmd = new  TableMetaData(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase(),tableList.getModel().getElementAt(index).toString());
	     newFrame(tmd,"Info on: " + tableList.getModel().getElementAt(index).toString(), true,true,true,true, getMouseX(), getMouseY(),500,215, tmd.cancel);
       
	 }
       }};
       tableList.addMouseListener(mouseListener);


       JScrollPane listPane = new JScrollPane();
       listPane.getViewport().add(tableList);
       JPanel panel2 = new JPanel();
       panel2.setLayout(new ColumnLayout(5,5,5,0));
       panel2.add((JLabel) new JLabel("Tables"));
       panel2.add(listPane);

       panel.add("West",panel1);
       panel.add("East",panel2);

       JScrollPane mc = new JScrollPane();   
       mc.getViewport().add(panel);

       contentPane.add("Center",mc);
       lc.add(frame,4);
       frame.moveToFront();
    }

      private void newFrame (JPanel panel, String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable, int x, int y, int width, int height,JButton cancel) {
      
       final JInternalFrame frame;
       Container contentPane;
       //final JButton cancel;
       //cancel = cancelButton;


       frame = new JInternalFrame(title, resizable, closable, maximizable, iconifiable);
       contentPane = frame.getContentPane();
       contentPane.setLayout(new BorderLayout());      

       JScrollPane scrollpane = new JScrollPane(panel);

       contentPane.add("Center",scrollpane);
       if ( cancel != null ) {
	   cancel.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       frame.dispose();
	       }});
       } 


       // dimension JInternalFrame TEST
       Dimension dim = contentPane.getPreferredSize();
       frame.setBounds(x,y, dim.width, dim.height);

       lc.add(frame,4);
       frame.moveToFront();
       
      }
    public void createDB() {

	if (  ( newdb = JOptionPane.showInputDialog(this,"Please enter Database-Name")) != null ) {

	   try {
	    Runtime rt = Runtime.getRuntime();
	    Process prcs = rt.exec(prop.getProperty("mysqladmin") + " create " + newdb);
	    
	    DataInputStream d = new DataInputStream(
		     prcs.getInputStream());
	    String line;
	    while ( (line=d.readLine() ) != null )
		message(line);
	}
	catch (IOException ioe) {
	    message("IO-Exception: " + ioe);
	}
    }

    }
    public void deleteDB() {

	if (  ( newdb = JOptionPane.showInputDialog(this,"Please enter Database-Name to delete")) != null ) {

	   try {
	    Runtime rt = Runtime.getRuntime();
	    Process prcs = rt.exec(prop.getProperty("mysqladmin") + " drop " + newdb);
	    DataInputStream d = new DataInputStream(
		     prcs.getInputStream());
	    String line;
	    while ( (line=d.readLine() ) != null )
		message(line);
	}
	catch (IOException ioe) {
	    message("IO-Exception: " + ioe);
	}
    }

    }


    public void execCMD() {
	if (  ( newdb = JOptionPane.showInputDialog(this,"Please enter command")) != null ) {

	   messageBoard();
	   try {
	    Runtime rt = Runtime.getRuntime();
	    Process prcs = rt.exec(newdb);
	    DataInputStream d = new DataInputStream(
		     prcs.getInputStream());
	    String line;
	    msgBoard.setText("");
	    while ( (line=d.readLine() ) != null )
		msgBoard.append(line+"\n");
	}
	catch (IOException ioe) {
	    message("IO-Exception: " + ioe);
	}
    }


    }

    private void setLogOnValues() {
	logOn.setHost(prop.getProperty("host"));
	logOn.setUser(prop.getProperty("user"));
	logOn.setUsePassword(prop.getProperty("usePassword"));
	logOn.setDatabase(prop.getProperty("db"));
	logOn.setDriver(prop.getProperty("JDBCdriver"));
	logOn.setUrl(prop.getProperty("JDBCurl"));
	logOn.setPort(prop.getProperty("DatabasePort"));
    }


    public void goodbye() {
       if ( m30.getState()) saveProperties();
       System.exit(0);
    }

    private void saveProperties() {

       Dimension dim = this.getSize();
	prop.put("width",Integer.toString(dim.width));
	prop.put("heigth",Integer.toString(dim.height));
	prop.put("host",logOn.getHost());
	prop.put("user",logOn.getUser());
	prop.put("db",logOn.getDatabase());
        prop.put("usePassword",logOn.getUsePassword());
        prop.put("JDBCdriver",logOn.getDriver());
        prop.put("JDBCurl",logOn.getUrl());
        prop.put("DatabasePort",logOn.getPort());
	prop.put("RDBMS",getRDBMS());
      
	try {

	    // Does this File exist?
	    File f = new File (System.getProperty("user.home")+File.separator+"admin.props");
            boolean df = f.delete();
	    FileOutputStream fops = new FileOutputStream(System.getProperty("user.home")+File.separator+"admin.props");
	    prop.save(fops,"Properties for Admin");
	    fops.flush();
	    fops.close();
       } catch (Exception e) {
	    System.out.println("Error saving admin.props :"+e);
       }
       saveConnectProperties();
    }


    private void saveConnectProperties() {
	Properties tProps = new Properties();
        tProps.put("JDBCdriver",prop.getProperty("JDBCdriver"));
        tProps.put("JDBCurl",prop.getProperty("JDBCurl"));
        tProps.put("DatabasePort",prop.getProperty("DatabasePort"));
	tProps.put("usePassword",prop.getProperty("usePassword"));
	tProps.put("DebugMode","off");
	try {

	    // Does this File exist?
	    File f = new File (System.getProperty("user.home")+File.separator+"t_connect.props");
            boolean df = f.delete();
	    FileOutputStream fops = new FileOutputStream(System.getProperty("user.home")+File.separator+"t_connect.props");
	    tProps.save(fops,"Properties for t_connect");
	    fops.flush();
	    fops.close();
       } catch (Exception e) {
	    System.out.println("Error saving t_connect.props :"+e);
       }

    }



    public void messageBoard() {

       Container contentPane;

       msgFrame = new JInternalFrame("MessageBoard",true,true,true,true);
       contentPane = msgFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       msgFrame.setBounds(200,200, 400, 250);

       msgBoard = new JTextArea("",10,30);
       msgBoard.setEditable(false);
       JScrollPane scrollpane = new JScrollPane();
       scrollpane.getViewport().add(msgBoard);

       contentPane.add("Center",scrollpane);

       JPanel panel1 = new JPanel();
       panel1.setLayout(new FlowLayout());

       JButton close = new JButton("Close");
       close.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       msgFrame.dispose();
	       }});
       
       panel1.add(close);
       contentPane.add("South",panel1);

       lc.add(msgFrame,4);
       aboutFrame.moveToFront();
    }



    private JInternalFrame createTable() {
      Container contentPane;

       createFrame = new JInternalFrame("Create Table",true,true,true,true);
       contentPane = createFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       createFrame.setBounds(getMouseX(), getMouseY(), 550, 270);
       createFrame.setFrameIcon(genImgIcon);

       crTa = new CreateTable();

       crTa.cancel.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
	     createFrame.dispose();
	 }});

       crTa.create.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       execSQL(crTa.getSqlCommand());
	       }});
       
 
       JScrollPane mc = new JScrollPane();   
       mc.getViewport().add(crTa);

       contentPane.add("Center",mc);

       return createFrame;
    }


    private JInternalFrame createIndex() {
      Container contentPane;

       createIdxFrame = new JInternalFrame("Create Index",true,true,true,true);
       contentPane = createIdxFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       createIdxFrame.setBounds(getMouseX(), getMouseY(), 550, 270);
       createIdxFrame.setFrameIcon(genImgIcon);

       CreateIndex crIdx = new CreateIndex(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase());

       crIdx.cancel.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
	     createIdxFrame.dispose();
	 }});

 
       JScrollPane mc = new JScrollPane();   
       mc.getViewport().add(crIdx);

       contentPane.add("Center",mc);

       return createIdxFrame;
    }

    private void execSQL(String sqlQuery) {
       t_connect con = new t_connect(logOn.getHost(),logOn.getUser(),logOn.getPassword(),logOn.getDatabase());
       if (con.getError() != null) {
          message(con.getError());
       } else {
	 try
	  {
	    int records = con.stmt.executeUpdate(sqlQuery);
	    message(Integer.toString(records)+" rows affected");
	    con.close();
	  } catch (Exception excpt) {
            message(excpt.getMessage().toString());
            } 
       }
    }

    public String getInfo() {

	return "Admin is a Tool around mySQL to do basic jobs" +"\n" +
    "for DB-Administrations, like:" +"\n" +
    "- create/ drop tables" +"\n" +
    "- create  indices" +"\n" +
    "- perform sql-statements" +"\n" +
    "- simple form" +"\n" +
    "- a guided query" +"\n" +
    "and a other usefull things in DB-arena" +"\n" +
    "" +"\n" +
    "Admin V1.0 " +"\n" +
    "Copyright (c) 1999 Fredy Fischer" +"\n" +
    "                   se-afs@dial.eunet.ch" +"\n" +
    "" +"\n" +
    "		       Fredy Fischer" +"\n" +
    "		       Hulmenweg 36" +"\n" +
    "		       8405 Winterthur" +"\n" +
    "		       Switzerland" +"\n" +
    "" +"\n" +
    "This program is free software; you can redistribute it and/or modify" +"\n" +
    "it under the terms of the GNU General Public License as published by" +"\n" +
    "the Free Software Foundation; either version 2 of the License, or" +"\n" +
    "any later version." +"\n" +
    "" +"\n" +
    "This program is distributed in the hope that it will be useful," +"\n" +
    "but WITHOUT ANY WARRANTY; without even the implied warranty of" +"\n" +
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the" +"\n" +
    "GNU General Public License for more details." +"\n" +
    "" +"\n" +
    "You should have received a copy of the GNU General Public License" +"\n" +
    "along with this program; if not, write to the Free Software" +"\n" +
    "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
    }


    private void about() {

       Container contentPane;

       aboutFrame = new JInternalFrame("About",true,true,true,true);
       contentPane = aboutFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       aboutFrame.setBounds(200,200, 450, 250);

       JTextArea a = new JTextArea("",10,35);
       a.setEditable(false);
       a.setText(getInfo());

       JScrollPane scrollpane = new JScrollPane();
       scrollpane.getViewport().add(a);

       contentPane.add("Center",scrollpane);

       JPanel panel1 = new JPanel();
       panel1.setLayout(new FlowLayout());


       JButton gpl = new JButton("GNU GENERAL PUBLIC LICENSE");
       gpl.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       displayGpl();
       }});
       

       JButton close = new JButton("Close");
       close.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       aboutFrame.dispose();
	       }});
       

       JButton pay = new JButton("Pay");
       pay.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       payFor();
	       }});
       

       panel1.add(gpl);
       panel1.add(close);
       panel1.add(pay);
       contentPane.add("South",panel1);

       lc.add(aboutFrame,4);
       
       

    }


    private ImageIcon loadImage(String image) {

        ImageIcon img = new ImageIcon(Admin.class.getResource("images"+ File.separator + image));
        return img;
    }


    private void payFor() {
	Container contentPane;

       payFrame = new JInternalFrame("Pay?",true,true,true,true);
       payFrame.setBackground(Color.blue);
       contentPane = payFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       payFrame.setBounds(200,200, 500, 324);

       JPanel panel = new JPanel();
       panel.setBackground(Color.blue);
       panel.setLayout(new BorderLayout());
       JLabel l = new JLabel(loadImage("virago.gif"));
       panel.add("North",l);

       java.awt.Font f = new  java.awt.Font("Helvetica", Font.BOLD, 24);
       JLabel np = new JLabel("Admin is FREE!!",SwingConstants.CENTER);
       np.setFont(f);
       np.setForeground(Color.yellow);
       panel.add("Center",np);


       JTextArea a = new JTextArea("",10,35);
       a.setEditable(false);
       a.setText("In fact this product is under GNU public License\n"+
		 "what means it is free.\n"+
		 "But, if you want to pay something for it, because you\n"+
		 "think I did a good job and this must be paid....\n"+
		 "then I'm happy to get a little amount so I can still\n"+
		 "hope to be once in the future the proud owner of a\n"+
		 "Yamaha Virago XV750, I'm really dreaming of....");

       panel.add("South",a);

       JScrollPane scrollpane = new JScrollPane();
       scrollpane.getViewport().add(panel);

       JPanel panel1 = new JPanel();
       panel1.setLayout(new FlowLayout());

       JButton close = new JButton("Close");
       close.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       payFrame.dispose();
	       }});
       
       panel1.add(close);
       contentPane.add("South",panel1);

       contentPane.add("Center",scrollpane);
       lc.add(payFrame,4);       
       payFrame.moveToFront();

    }

    private void displayGpl() {
	Container contentPane;

       gplFrame = new JInternalFrame("GPL",true,true,true,true);
       contentPane = gplFrame.getContentPane();
       contentPane.setLayout(new BorderLayout());      
       gplFrame.setBounds(200,200, 600, 300);

       JTextArea a = new JTextArea("",10,35);
       a.setEditable(false);
       a.setText(getGpl());

       JScrollPane scrollpane = new JScrollPane();
       scrollpane.getViewport().add(a);

       JPanel panel1 = new JPanel();
       panel1.setLayout(new FlowLayout());

       JButton close = new JButton("Close");
       close.addActionListener(new ActionListener() {
	   public void actionPerformed(ActionEvent e) {
	       gplFrame.dispose();
	       }});
       
       panel1.add(close);
       contentPane.add("South",panel1);

       contentPane.add("Center",scrollpane);
       lc.add(gplFrame,4);       
       gplFrame.moveToFront();
    }


    private String getGpl() {

	return "\n" +
"\n"+
"                    GNU GENERAL PUBLIC LICENSE\n"+
"                       Version 2, June 1991\n"+
"\n"+
"Copyright (C) 1989, 1991 Free Software Foundation, Inc.\n"+
"                      59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n"+
"Everyone is permitted to copy and distribute verbatim copies\n"+
"of this license document, but changing it is not allowed.\n"+
"\n"+
"                            Preamble\n"+
"\n"+
"  The licenses for most software are designed to take away your\n"+
"freedom to share and change it.  By contrast, the GNU General Public\n"+
"License is intended to guarantee your freedom to share and change free\n"+
"software--to make sure the software is free for all its users.  This\n"+
"General Public License applies to most of the Free Software\n"+
"Foundation's software and to any other program whose authors commit to\n"+
"using it.  (Some other Free Software Foundation software is covered by\n"+
"the GNU Library General Public License instead.)  You can apply it to\n"+
"your programs, too.\n"+
"\n"+
"  When we speak of free software, we are referring to freedom, not\n"+
"price.  Our General Public Licenses are designed to make sure that you\n"+
"have the freedom to distribute copies of free software (and charge for\n"+
"this service if you wish), that you receive source code or can get it\n"+
"if you want it, that you can change the software or use pieces of it\n"+
"in new free programs; and that you know you can do these things.\n"+
"\n"+
"  To protect your rights, we need to make restrictions that forbid\n"+
"anyone to deny you these rights or to ask you to surrender the rights.\n"+
"These restrictions translate to certain responsibilities for you if you\n"+
"distribute copies of the software, or if you modify it.\n"+
"\n"+
"  For example, if you distribute copies of such a program, whether\n"+
"gratis or for a fee, you must give the recipients all the rights that\n"+
"you have.  You must make sure that they, too, receive or can get the\n"+
"source code.  And you must show them these terms so they know their\n"+
"rights.\n"+
"\n"+
"  We protect your rights with two steps: (1) copyright the software, and\n"+
"(2) offer you this license which gives you legal permission to copy,\n"+
"distribute and/or modify the software.\n"+
"\n"+
"  Also, for each author's protection and ours, we want to make certain\n"+
"that everyone understands that there is no warranty for this free\n"+
"software.  If the software is modified by someone else and passed on, we\n"+
"want its recipients to know that what they have is not the original, so\n"+
"that any problems introduced by others will not reflect on the original\n"+
"authors' reputations.\n"+
"\n"+
"  Finally, any free program is threatened constantly by software\n"+
"patents.  We wish to avoid the danger that redistributors of a free\n"+
"program will individually obtain patent licenses, in effect making the\n"+
"program proprietary.  To prevent this, we have made it clear that any\n"+
"patent must be licensed for everyone's free use or not licensed at all.\n"+
"\n"+
"  The precise terms and conditions for copying, distribution and\n"+
"modification follow.\n"+
"\n"+
"                    GNU GENERAL PUBLIC LICENSE\n"+
"   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"+
"\n"+
"  0. This License applies to any program or other work which contains\n"+
"a notice placed by the copyright holder saying it may be distributed\n"+
"under the terms of this General Public License.  The \"Program\", below,\n"+
"refers to any such program or work, and a \"work based on the Program\"\n"+
"means either the Program or any derivative work under copyright law:\n"+
"that is to say, a work containing the Program or a portion of it,\n"+
"either verbatim or with modifications and/or translated into another\n"+
"language.  (Hereinafter, translation is included without limitation in\n"+
"the term \"modification\".)  Each licensee is addressed as \"you\".\n"+
"\n"+
"Activities other than copying, distribution and modification are not\n"+
"covered by this License; they are outside its scope.  The act of\n"+
"running the Program is not restricted, and the output from the Program\n"+
"is covered only if its contents constitute a work based on the\n"+
"Program (independent of having been made by running the Program).\n"+
"Whether that is true depends on what the Program does.\n"+
"\n"+
"  1. You may copy and distribute verbatim copies of the Program's\n"+
"source code as you receive it, in any medium, provided that you\n"+
"conspicuously and appropriately publish on each copy an appropriate\n"+
"copyright notice and disclaimer of warranty; keep intact all the\n"+
"notices that refer to this License and to the absence of any warranty;\n"+
"and give any other recipients of the Program a copy of this License\n"+
"along with the Program.\n"+
"\n"+
"You may charge a fee for the physical act of transferring a copy, and\n"+
"you may at your option offer warranty protection in exchange for a fee.\n"+
"\n"+
"  2. You may modify your copy or copies of the Program or any portion\n"+
"of it, thus forming a work based on the Program, and copy and\n"+
"distribute such modifications or work under the terms of Section 1\n"+
"above, provided that you also meet all of these conditions:\n"+
"\n"+
"    a) You must cause the modified files to carry prominent notices\n"+
"    stating that you changed the files and the date of any change.\n"+
"\n"+
"    b) You must cause any work that you distribute or publish, that in\n"+
"    whole or in part contains or is derived from the Program or any\n"+
"    part thereof, to be licensed as a whole at no charge to all third\n"+
"    parties under the terms of this License.\n"+
"\n"+
"    c) If the modified program normally reads commands interactively\n"+
"    when run, you must cause it, when started running for such\n"+
"    interactive use in the most ordinary way, to print or display an\n"+
"    announcement including an appropriate copyright notice and a\n"+
"    notice that there is no warranty (or else, saying that you provide\n"+
"    a warranty) and that users may redistribute the program under\n"+
"    these conditions, and telling the user how to view a copy of this\n"+
"    License.  (Exception: if the Program itself is interactive but\n"+
"    does not normally print such an announcement, your work based on\n"+
"    the Program is not required to print an announcement.)\n"+
"\n"+
"These requirements apply to the modified work as a whole.  If\n"+
"identifiable sections of that work are not derived from the Program,\n"+
"and can be reasonably considered independent and separate works in\n"+
"themselves, then this License, and its terms, do not apply to those\n"+
"sections when you distribute them as separate works.  But when you\n"+
"distribute the same sections as part of a whole which is a work based\n"+
"on the Program, the distribution of the whole must be on the terms of\n"+
"this License, whose permissions for other licensees extend to the\n"+
"entire whole, and thus to each and every part regardless of who wrote it.\n"+
"\n"+
"Thus, it is not the intent of this section to claim rights or contest\n"+
"your rights to work written entirely by you; rather, the intent is to\n"+
"exercise the right to control the distribution of derivative or\n"+
"collective works based on the Program.\n"+
"\n"+
"In addition, mere aggregation of another work not based on the Program\n"+
"with the Program (or with a work based on the Program) on a volume of\n"+
"a storage or distribution medium does not bring the other work under\n"+
"the scope of this License.\n"+
"\n"+
"  3. You may copy and distribute the Program (or a work based on it,\n"+
"under Section 2) in object code or executable form under the terms of\n"+
"Sections 1 and 2 above provided that you also do one of the following:\n"+
"\n"+
"    a) Accompany it with the complete corresponding machine-readable\n"+
"    source code, which must be distributed under the terms of Sections\n"+
"    1 and 2 above on a medium customarily used for software interchange; or,\n"+
"\n"+
"    b) Accompany it with a written offer, valid for at least three\n"+
"    years, to give any third party, for a charge no more than your\n"+
"    cost of physically performing source distribution, a complete\n"+
"    machine-readable copy of the corresponding source code, to be\n"+
"    distributed under the terms of Sections 1 and 2 above on a medium\n"+
"    customarily used for software interchange; or,\n"+
"\n"+
"    c) Accompany it with the information you received as to the offer\n"+
"    to distribute corresponding source code.  (This alternative is\n"+
"    allowed only for noncommercial distribution and only if you\n"+
"    received the program in object code or executable form with such\n"+
"    an offer, in accord with Subsection b above.)\n"+
"\n"+
"The source code for a work means the preferred form of the work for\n"+
"making modifications to it.  For an executable work, complete source\n"+
"code means all the source code for all modules it contains, plus any\n"+
"associated interface definition files, plus the scripts used to\n"+
"control compilation and installation of the executable.  However, as a\n"+
"special exception, the source code distributed need not include\n"+
"anything that is normally distributed (in either source or binary\n"+
"form) with the major components (compiler, kernel, and so on) of the\n"+
"operating system on which the executable runs, unless that component\n"+
"itself accompanies the executable.\n"+
"\n"+
"If distribution of executable or object code is made by offering\n"+
"access to copy from a designated place, then offering equivalent\n"+
"access to copy the source code from the same place counts as\n"+
"distribution of the source code, even though third parties are not\n"+
"compelled to copy the source along with the object code.\n"+
"\n"+
"  4. You may not copy, modify, sublicense, or distribute the Program\n"+
"except as expressly provided under this License.  Any attempt\n"+
"otherwise to copy, modify, sublicense or distribute the Program is\n"+
"void, and will automatically terminate your rights under this License.\n"+
"However, parties who have received copies, or rights, from you under\n"+
"this License will not have their licenses terminated so long as such\n"+
"parties remain in full compliance.\n"+
"\n"+
"  5. You are not required to accept this License, since you have not\n"+
"signed it.  However, nothing else grants you permission to modify or\n"+
"distribute the Program or its derivative works.  These actions are\n"+
"prohibited by law if you do not accept this License.  Therefore, by\n"+
"modifying or distributing the Program (or any work based on the\n"+
"Program), you indicate your acceptance of this License to do so, and\n"+
"all its terms and conditions for copying, distributing or modifying\n"+
"the Program or works based on it.\n"+
"\n"+
"  6. Each time you redistribute the Program (or any work based on the\n"+
"Program), the recipient automatically receives a license from the\n"+
"original licensor to copy, distribute or modify the Program subject to\n"+
"these terms and conditions.  You may not impose any further\n"+
"restrictions on the recipients' exercise of the rights granted herein.\n"+
"You are not responsible for enforcing compliance by third parties to\n"+
"this License.\n"+
"\n"+
"  7. If, as a consequence of a court judgment or allegation of patent\n"+
"infringement or for any other reason (not limited to patent issues),\n"+
"conditions are imposed on you (whether by court order, agreement or\n"+
"otherwise) that contradict the conditions of this License, they do not\n"+
"excuse you from the conditions of this License.  If you cannot\n"+
"distribute so as to satisfy simultaneously your obligations under this\n"+
"License and any other pertinent obligations, then as a consequence you\n"+
"may not distribute the Program at all.  For example, if a patent\n"+
"license would not permit royalty-free redistribution of the Program by\n"+
"all those who receive copies directly or indirectly through you, then\n"+
"the only way you could satisfy both it and this License would be to\n"+
"refrain entirely from distribution of the Program.\n"+
"\n"+
"If any portion of this section is held invalid or unenforceable under\n"+
"any particular circumstance, the balance of the section is intended to\n"+
"apply and the section as a whole is intended to apply in other\n"+
"circumstances.\n"+
"\n"+
"It is not the purpose of this section to induce you to infringe any\n"+
"patents or other property right claims or to contest validity of any\n"+
"such claims; this section has the sole purpose of protecting the\n"+
"integrity of the free software distribution system, which is\n"+
"implemented by public license practices.  Many people have made\n"+
"generous contributions to the wide range of software distributed\n"+
"through that system in reliance on consistent application of that\n"+
"system; it is up to the author/donor to decide if he or she is willing\n"+
"to distribute software through any other system and a licensee cannot\n"+
"impose that choice.\n"+
"\n"+
"This section is intended to make thoroughly clear what is believed to\n"+
"be a consequence of the rest of this License.\n"+
"\n"+
"  8. If the distribution and/or use of the Program is restricted in\n"+
"certain countries either by patents or by copyrighted interfaces, the\n"+
"original copyright holder who places the Program under this License\n"+
"may add an explicit geographical distribution limitation excluding\n"+
"those countries, so that distribution is permitted only in or among\n"+
"countries not thus excluded.  In such case, this License incorporates\n"+
"the limitation as if written in the body of this License.\n"+
"\n"+
"  9. The Free Software Foundation may publish revised and/or new versions\n"+
"of the General Public License from time to time.  Such new versions will\n"+
"be similar in spirit to the present version, but may differ in detail to\n"+
"address new problems or concerns.\n"+
"\n"+
"Each version is given a distinguishing version number.  If the Program\n"+
"specifies a version number of this License which applies to it and \"any\n"+
"later version\", you have the option of following the terms and conditions\n"+
"either of that version or of any later version published by the Free\n"+
"Software Foundation.  If the Program does not specify a version number of\n"+
"this License, you may choose any version ever published by the Free Software\n"+
"Foundation.\n"+
"\n"+
"  10. If you wish to incorporate parts of the Program into other free\n"+
"programs whose distribution conditions are different, write to the author\n"+
"to ask for permission.  For software which is copyrighted by the Free\n"+
"Software Foundation, write to the Free Software Foundation; we sometimes\n"+
"make exceptions for this.  Our decision will be guided by the two goals\n"+
"of preserving the free status of all derivatives of our free software and\n"+
"of promoting the sharing and reuse of software generally.\n"+
"\n"+
"                            NO WARRANTY\n"+
"\n"+
"  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\n"+
"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\n"+
"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\n"+
"PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\n"+
"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"+
"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\n"+
"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\n"+
"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\n"+
"REPAIR OR CORRECTION.\n"+
"\n"+
"  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n"+
"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\n"+
"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n"+
"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\n"+
"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\n"+
"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\n"+
"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\n"+
"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\n"+
"POSSIBILITY OF SUCH DAMAGES.";



    }


}



class mScrollPane extends JScrollPane {

    public mScrollPane() {
    super();
    JPanel p = new JPanel();
    p.setOpaque(false);
    p.setLayout(new BorderLayout());
    getViewport().add(p);
   }
    
    public Dimension getMinimumSize() {
	return new Dimension(25, 25);
    }
    
    public boolean isOpaque() {
        return true;
    }
}
