package mysqladmin;

/** 

    CreateTable is a part of Admin

    Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.sql.*;
import java.util.Vector;
import javax.swing.table.TableColumn;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

public class Catalog extends JPanel {

    public JButton cancel;
    String host;
    
    /**
       * Get the value of host.
       * @return Value of host.
       */
    public String getHost() {return host;}
    
    /**
       * Set the value of host.
       * @param v  Value to assign to host.
       */
    public void setHost(String  v) {this.host = v;}
    
    String user;
    
    /**
       * Get the value of user.
       * @return Value of user.
       */
    public String getUser() {return user;}
    
    /**
       * Set the value of user.
       * @param v  Value to assign to user.
       */
    public void setUser(String  v) {this.user = v;}
    
    String password;
    
    /**
       * Get the value of password.
       * @return Value of password.
       */
    public String getPassword() {return password;}
    
    /**
       * Set the value of password.
       * @param v  Value to assign to password.
       */
    public void setPassword(String  v) {this.password = v;}
    
    String database;
    
    /**
       * Get the value of database.
       * @return Value of database.
       */
    public String getDatabase() {return database;}
    
    /**
       * Set the value of database.
       * @param v  Value to assign to database.
       */
    public void setDatabase(String  v) {this.database = v;}
    
    String table;
    
    /**
       * Get the value of table.
       * @return Value of table.
       */
    public String getTable() {return table;}
    
    /**
       * Set the value of table.
       * @param v  Value to assign to table.
       */
    public void setTable(String  v) {this.table = v;}
    
    private Vector name, type,size, isNull, remarks, defaults;

    public Catalog(String host, String user, String password, String database, String table) {

       setHost(host);
       setUser(user);
       setPassword(password);
       setDatabase(database);
       setTable(table);
       inits();

       }


    private void inits() { 

	   this.setLayout(new BorderLayout());
	   this.add("Center",infoPanel());
	   this.add("South",buttonPanel());


    }

    private JPanel infoPanel() {

	   JPanel panel = new JPanel();
	   panel.setLayout(new BorderLayout());

	   JTextArea t = new JTextArea();
	   JScrollPane scrollpane = new JScrollPane(t);
	   panel.add("Center",t);



	   t_connect con = new t_connect(getHost(),getUser(),getPassword(),getDatabase());

        try {
	 DatabaseMetaData dmd = con.con.getMetaData();
         //ResultSet rs = dmd.getColumns(null, null, getTable(), null);
 
	 t.setText("SCHEMATAS\n");

         ResultSet rs = dmd.getSchemas();

	 while (rs.next()) { 
	     t.append(rs.getString("TABLE_SCHEM")+"\n");
	 }

         rs = dmd.getCatalogs();
	 t.append("\nCATALOGS\n");
	 while (rs.next()) { 
	     t.append(rs.getString("TABLE_CAT")+"\n");
	 }

         rs = dmd.getColumnPrivileges(null, null, getTable(), "*");
	 t.append("\nPrivilegs\n");
	 while (rs.next()) { 

	     t.append("Table: "   + rs.getString("TABLE_NAME")+"\n");
	     t.append("Grantor: " + rs.getString("GRANTOR")+"\n");
	     t.append("Grantee: " + rs.getString("GRANTEE")+"\n");
	     t.append("Privilege: " + rs.getString("PRIVILEGE")+"\n");
	     t.append("Is Grantable: " + rs.getString("IS_GRANTABLE")+"\n");

	 }

         rs = dmd.getPrimaryKeys(null, null, getTable());
	 t.append("\nPrimary Keys\n");
	 while (rs.next()) { 

	     t.append("Table: "   + rs.getString("TABLE_NAME")+"\n");
	     t.append("Column: " + rs.getString("COLUMN_NAME")+"\n");

	 }


	} catch (SQLException sqe) {;}


	return panel;
    }

       private JPanel buttonPanel() {

	   JPanel panel = new JPanel();
	   panel.setLayout(new FlowLayout());
	   cancel = new JButton("Cancel");
	   panel.add(cancel);
	   return panel;
       }


       public static void main(String args[]) {

	   if (args.length != 5) {
	       System.out.println("Syntax: java Catalog host user password database table");
	       System.exit(0);
	   }

	   JFrame f = new JFrame("Catalog");
	   f.addWindowListener(new WindowAdapter() {
	       public void windowActivated(WindowEvent e) {}
	       public void windowClosed(WindowEvent e) {}
	       public void windowClosing(WindowEvent e) {System.exit(0);}
	       public void windowDeactivated(WindowEvent e) {}
	       public void windowDeiconified(WindowEvent e) {}
	       public void windowIconified(WindowEvent e) {}
	       public void windowOpened(WindowEvent e) {}});
	   f.getContentPane().setLayout(new BorderLayout());
	   Catalog tmd = new Catalog(args[0],args[1],args[2],args[3], args[4]);
	   f.getContentPane().add("Center",tmd);
	   tmd.cancel.addActionListener(new ActionListener() {
	       public void actionPerformed(ActionEvent e) {
		   System.exit(0);
		   }});
	   
	   f.pack();
	   f.setVisible(true);
       }
    }
