package mysqladmin;

/** 

    DropTable is the friendly person deleting tables inside Admin,
    so it is a part of Fredy's Admin

    Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import javax.swing.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;
import javax.swing.JPanel; 
import javax.swing.JFrame;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.border.*;

public class DropTable extends JPanel {

    private JPanel mainPanel;
    private Tables tableList;
    /**
       * Get the value of host.
       * @return Value of host.
       */
    private String host;
    public String getHost() {return host;}
    
    /**
       * Set the value of host.
       * @param v  Value to assign to host.
       */
    public void setHost(String  v) {this.host = v;}
    
    public JButton cancel;

    /** to find out, when the user wants to close
     *  this application, set a listener onto (JButton)AutoForm.cancel 
     **/

    private String user;
    
    /**
       * Get the value of user.
       * @return Value of user.
       */
    public String getUser() {return user;}
    
    /**
       * Set the value of user.
       * @param v  Value to assign to user.
       */
    public void setUser(String  v) {this.user = v;}
    

    private String password;
    
    /**
       * Get the value of password.
       * @return Value of password.
       */
    public String getPassword() {return password;}
    
    /**
       * Set the value of password.
       * @param v  Value to assign to password.
       */
    public void setPassword(String  v) {this.password = v;}


    private String database;
    
    /**
       * Get the value of database.
       * @return Value of database.
       */
    public String getDatabase() {return database;}
    
    /**
       * Set the value of database.
       * @param v  Value to assign to database.
       */
    public void setDatabase(String  v) {this.database = v;}
    
    private String dbTable;
    
    /**
       * Get the value of dbTable.
       * @return Value of dbTable.
       */
    public String getDbTable() {
	dbTable = tableList.getSelectedValue().toString();
	return dbTable;
    }
    
    /**
       * Set the value of dbTable.
       * @param v  Value to assign to dbTable.
       */
    public void setDbTable(String  v) {this.dbTable = v;}
       

    public DropTable  (String host,String user, String password, String database) {
	setHost(host);
	setUser(user);
	setPassword(password);
	setDatabase(database);

	this.setLayout(new BorderLayout());    
	this.add("Center",tablePanel());
	this.add("South",buttonPanel());

    }


    private JPanel tablePanel() {

	tableList = new Tables(getHost(),getUser(),getPassword(),getDatabase());
	JScrollPane scrollpane = new JScrollPane();
	scrollpane.getViewport().add(tableList);
	JPanel mainPanel = new JPanel();
	mainPanel.add(scrollpane);
	return mainPanel;
    }
	
    private JPanel buttonPanel() {

	JPanel panel = new JPanel();
	JButton delete = new JButton("Delete");
	delete.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		dropTable();
		}});
	
	cancel = new JButton("Cancel");
	
	panel.add(delete);
	panel.add(cancel);
	return panel;

    }


    private void dropTable() {
      	String string1 = "Yes";
	String string2 = "No";
	Object[] options = {string1, string2};
	int n = JOptionPane.showOptionDialog(null,
                              "Do you really want to delete " + getDbTable()+"?",
                              "Delete Table ",
                              JOptionPane.YES_NO_OPTION,
                              JOptionPane.QUESTION_MESSAGE,
                              null,     //don't use a custom Icon
                              options,  //the titles of buttons
                              string2); //the title of the default button
	if (n == JOptionPane.YES_OPTION) {	
	    t_connect con = new t_connect(getHost(), getUser(),getPassword(),getDatabase());
	     if (con.getError() != null) {
                 message(con.getError());
             } else {
	     try
	     {
		int records = con.stmt.executeUpdate("drop table "+ getDbTable());
		message(Integer.toString(records)+" rows affected");
	       } catch (Exception excpt) {
               message(excpt.getMessage().toString());
               } 

	     }
	}
	try {
	    this.remove(mainPanel);
	    mainPanel = tablePanel();
	    this.add("Center",mainPanel);
	    this.updateUI();
	} catch (Exception a_damned_stupid_exception) {;}

    }

    private void message(String msg) {
        JOptionPane.showMessageDialog(null, msg,"Message",JOptionPane.WARNING_MESSAGE);
    }
}
