#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qmessagebox.h>

#include "field.h"

void Field::slot_close()
{
	parentWidget()->close();
}

void Field::slot_fire()
{
	QString sql;

	if(field->text().length() == 0)
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter field name."));
		return;
	}

	if(old == field->text())
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter another field name, because field name must be different from old one."));
		return;
	}

	if(database->currentText() == QString("mysql"))
	{
		if(flag)
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create field in mysql database."));
		}
		else
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't change field in mysql database."));
		}
		return;
	}

	if(flag)
	{
		sql += "ALTER TABLE ";
		sql += table->currentText();
		sql += " ADD ";
		sql += field->text();
		sql += " ";
	}
	else
	{
		sql += "ALTER TABLE ";
		sql += table->currentText();
		sql += " CHANGE ";
		sql += old;
		sql += " ";
		sql += field->text();
		sql += " ";
	}

	sql += type->currentText();

	if(length->text().length() == 0)
	{
		sql += " ";
	}
	else
	{
		sql += "(";
		sql += length->text();
		sql += ")";
		sql += " ";
	}

	if(attribute->currentItem() != 0)
	{
		sql += attribute->currentText();
		sql += " ";
	}

	if(null->currentText().contains("NOT"))
	{
		sql += null->currentText();
		sql += " ";
	}

	if(_default->text().length() != 0)
	{
		sql += "DEFAULT ";
		sql += "\'";
		sql += _default->text();
		sql += "\'";
		sql += " ";
	}

	if(extra->currentItem() != 0)
	{
		sql += extra->currentText();
		sql += " ";
	}

	if(flag)
	{
		if(position->currentItem() == 0)
		{
			sql += "FIRST";
			sql += " ";
		}
		else if(position->currentItem() == 1)
		{
		}
		else
		{
			sql += position->currentText();
			sql += " ";
		}
	}

	//debug(sql.latin1());

	if(mysql_query(mysql, sql.latin1()))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		emit signal_error_log();
		return;
	}

	mysql_reload(mysql);
	emit signal_tree();

	if(flag)
	{
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Field ") + field->text() + QString(tr(" is successfully created.")))); 
	}
	else
	{
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Field ") + field->text() + QString(tr(" is successfully changed.")))); 
	}
}

void Field::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is a field window."));
}

void Field::slot_clear()
{
	position->setCurrentItem(0);
	field->setText("");
	type->setCurrentItem(0);
	length->setText("");
	attribute->setCurrentItem(0);
	null->setCurrentItem(0);
	_default->setText("");
	extra->setCurrentItem(0);

	position->setFocus();
}

