#include <qvbox.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qstatusbar.h>
#include <qscrollview.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "resource.h"

#include "background.xpm"
#include "window.xpm"

void MainWindow::make_layout()
{	
	make_menubar();

	make_central_widget();

	make_toolbar();

	make_statusbar();
}

void MainWindow::make_central_widget()
{
	QVBox *l = new QVBox(this);
	l->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
	work_space = new QWorkspace(l);
	setCentralWidget(l);

	statusBar()->message(tr("Ready..."), 3000);
	
	work_space->setBackgroundPixmap(QPixmap(background_xpm));

	setIcon(QPixmap(window_xpm));
}

void MainWindow::make_statusbar()
{
	statusBar();

	statusBar()->message(tr("Ready..."), 3000);
}

void MainWindow::make_toolbar()
{
	toolbar = new QToolBar(this,"");
	addToolBar(toolbar, QMainWindow::Top, TRUE);
	
	database = new QComboBox(toolbar, "");
	database->setFixedWidth(65);
	database->setFixedHeight(20);

	query = new PopupComboBox(TRUE, toolbar, "");
	query->setFixedHeight(20);

	query->setAutoCompletion(TRUE);	

	set_base_color(query,QColor(0xce,0xc6,0xbd));
	set_base_color(database,QColor(0xce,0xc6,0xbd));

	QToolTip::add(database, tr("Select database"));
	QToolTip::add(query, tr("Enter query and press return."));

	toolbar->setStretchableWidget(query);
}

void MainWindow::make_menubar()
{
	QPopupMenu *si;

	si = new QPopupMenu();
	si->setCaption(tr("File"));	
	si->insertTearOffHandle(TOOLBAR_TEAROFF);	
	si->insertItem(tr("&Connect"),this,SLOT(slot_connect()), CTRL+Key_C, TOOLBAR_CONNECT);
	si->insertItem(tr("&Disconnect"),this,SLOT(slot_disconnect()), CTRL+Key_D, TOOLBAR_DISCONNECT);
	si->insertSeparator(); 
	si->insertItem(tr("E&xit"),this,SLOT(slot_exit()), CTRL+Key_X, TOOLBAR_EXIT);
	menuBar()->insertItem(tr("&File"), si);
	
	si = new QPopupMenu();
	si->setCaption(tr("Window"));	
	si->insertTearOffHandle(TOOLBAR_TEAROFF);	
	si->insertItem(tr("&Toolbar"),this,SLOT(slot_hide_toolbar()),0,TOOLBAR_TOOLBAR);
	si->insertItem(tr("&Statusbar"),this,SLOT(slot_hide_statusbar()),0,TOOLBAR_STATUSBAR);
	si->setItemChecked(TOOLBAR_TOOLBAR,TRUE);
	si->setItemChecked(TOOLBAR_STATUSBAR,TRUE);
	menuBar()->insertItem(tr("&Window"), si);
	
	si =new QPopupMenu();
	si->setCaption(tr("Style"));	
	si->insertTearOffHandle(TOOLBAR_TEAROFF);	
	si->insertItem(tr("&Windows"),this,SLOT(slot_windows()),0,TOOLBAR_WINDOWS);
	si->insertItem(tr("&CDE"),this,SLOT(slot_cde()),0,TOOLBAR_CDE);
	si->insertItem(tr("&Motif"),this,SLOT(slot_motif()),0,TOOLBAR_MOTIF);
	si->insertItem(tr("Motif Plus"),this,SLOT(slot_motif_plus()),0,TOOLBAR_MOTIF_PLUS);
	si->insertItem(tr("&Platinum"),this,SLOT(slot_platinum()),0,TOOLBAR_PLATINUM);
	si->insertItem(tr("&SGI"),this,SLOT(slot_sgi()),0,TOOLBAR_SGI);
	si->setItemChecked(TOOLBAR_WINDOWS, TRUE);
	menuBar()->insertItem(tr("&Style"), si);

	si = new QPopupMenu();
	si->setCaption(tr("MySQL"));	
	si->insertTearOffHandle(TOOLBAR_TEAROFF);	
	si->insertItem(tr("&Schema"),this,SLOT(slot_schema()), 0, TOOLBAR_SCHEMA);
	si->insertItem(tr("&User"),this,SLOT(slot_user(int)), 0, TOOLBAR_USER);	
	si->insertItem(tr("T&able"),this,SLOT(slot_table()), 0, TOOLBAR_TABLE);	
	si->insertItem(tr("&Query"),this,SLOT(slot_query_window()), 0, TOOLBAR_QUERY);
	si->insertItem(tr("&Process"),this,SLOT(slot_process()), 0, TOOLBAR_PROCESSLIST);
	si->insertItem(tr("&Xport"),this,SLOT(slot_xport()), 0, TOOLBAR_XPORT);
	si->insertItem(tr("&Status"),this,SLOT(slot_status()), 0, TOOLBAR_STATUS2);
	si->insertItem(tr("&Variables"),this,SLOT(slot_variable()), 0, TOOLBAR_VARIABLES);
	si->insertItem(tr("P&assword"),this,SLOT(slot_password()), 0, TOOLBAR_PASSWORD);
	si->insertItem(tr("P&ing"),this,SLOT(slot_ping()), 0, TOOLBAR_PING);

	//si_ = new QPopupMenu();
	si->insertItem(tr("&Script"),this,SLOT(slot_script_run()), 0, TOOLBAR_SCRIPT);
	si->insertItem(tr("&Edit"),this,SLOT(slot_script_edit()), 0, TOOLBAR_EDIT);
	//si->insertItem(tr("&Script"), si_);
	
	//QPopupMenu *si_;
	//si_ = new QPopupMenu();
	si->insertItem(tr("&Flush"), this, SLOT(slot_flush()), 0, TOOLBAR_FLUSH);
	//si_->insertSeparator();	
	//si_->insertItem(tr("&hosts"),this,SLOT(slot_flush_hosts()), 0, TOOLBAR_HOSTS);
	//si_->insertItem(tr("&logs"),this,SLOT(slot_flush_logs()), 0, TOOLBAR_LOGS);
	//si_->insertItem(tr("&status"),this,SLOT(slot_flush_status()), 0, TOOLBAR_STATUS1);
	//si_->insertItem(tr("&tables"),this,SLOT(slot_flush_tables()), 0, TOOLBAR_TABLES);
	//si_->insertItem(tr("&privileges"),this,SLOT(slot_flush_privilages()), 0, TOOLBAR_PRIVILAGES);
	//si->insertItem(tr("&Flush"), si_);
	si->insertItem(tr("&Log"),this,SLOT(slot_log()), 0, TOOLBAR_LOG);
	
	menuBar()->insertItem(tr("&MySQL"), si);
	
	si = new QPopupMenu();
	si->setCaption(tr("Tools"));	
	si->insertTearOffHandle(TOOLBAR_TEAROFF);	
	si->insertItem(tr("Cl&ose"),this,SLOT(slot_close_window()), 0, TOOLBAR_CLOSE);
	si->insertItem(tr("Close &All"),this,SLOT(slot_close_windows()), 0, TOOLBAR_CLOSE_ALL);
	//si->insertItem("&Terminal", this, SLOT(slot_terminal()), 0, TOOLBAR_TERMINAL);
	si->insertSeparator();
	si->insertItem(tr("&Clear history"),this,SLOT(slot_history()), 0, TOOLBAR_CLEAR);
	menuBar()->insertItem(tr("&Tools"), si);
	
	si = new QPopupMenu();	 	
	si->setCaption(tr("Help"));	
	si->insertTearOffHandle(TOOLBAR_TEAROFF);	
	si->insertItem(tr("&About..."),this,SLOT(about()), Key_F1, TOOLBAR_ABOUT);
	si->insertItem(tr("About &Qt..."),this,SLOT(aboutQt()), 0, TOOLBAR_QT);
	menuBar()->insertItem(tr("&Help"), si);
	menuBar()->setDefaultUp(FALSE);
}

