#include "mainwindow.h"
#include "serverlistviewitem.h"
#include <qmessagebox.h>
#include <qstatusbar.h>
#include <qlineedit.h>
#include <qdom.h>
#include <qfile.h>
#include <stdlib.h>
#include <stdio.h>

void MainWindow::slot_close()
{
	((QWidget *)dialog)->close();
}

void MainWindow::slot_connect()
{
	if(flag)
	{
		return;
	}
	
	if(dialog == NULL)
	{
		dialog = new Connect(this);
		connect((const QObject *)dialog->fire,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_fire()));
		connect((const QObject *)dialog->close,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_close()));
	
		load_server_list(dialog);

		dialog->setCaption(tr("MySQL Navigator"));	
	}
	else
	{
		//dialog->show();
	}

	dialog->list->clearSelection();

	dialog->exec();

	if(flag)
	{
		statusBar()->message(tr("Connected..."),3000);
		
		slot_schema();	
	
		set_database();

		enable_menu();

		load_history();
	}
}

void MainWindow::slot_fire()
{
	if(dialog->host->text().length()==0)
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter host name"));
		dialog->host->setFocus();
		return;
	}
	if(dialog->user->text().length()==0)
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter user name"));
		dialog->user->setFocus();
		return;
	}
	if(dialog->password->text().length()==0)
	{
		QMessageBox::warning (this, tr("MySQL Navigator"), tr("You did not enter password. \nFor security reason, it is very dangerous. \nTherefore MySQL Navigator strongly recommend to change your password, if you succeed login."));

		//QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter password"));
		//dialog->password->setFocus();
		//return;
	}

	if(!mysql_real_connect(&mysql,
							dialog->host->text().latin1(),
							dialog->user->text().latin1(),
							dialog->password->text().latin1(),
							dialog->database->text().length()==0?NULL:dialog->database->text().latin1(),
							dialog->port->text().length()==0?3306:dialog->port->text().toUInt(),
							dialog->socket->text().length()==0?NULL:dialog->socket->text().latin1(),
							0	
							//dialog->flag->text().length()==0?0:dialog->flag->text().toUInt()
							))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error_log();
	}
	else
	{
		host = dialog->host->text();
		user = dialog->user->text();
	
		dialog->host->clear();
		dialog->user->clear();
		dialog->password->clear();
		dialog->database->clear();
		dialog->port->clear();
		dialog->socket->clear();
		//dialog->flag->clear();

		dialog->host->setFocus();
		flag =  TRUE;
		((QWidget *)dialog)->hide();
	}
}

void MainWindow::load_server_list(Connect *dialog)
{
	char buffer[100];

	sprintf(buffer, "%s/.mysql_navigator.rc", getenv("HOME"));

	QFile l(buffer);

	if(l.exists() == FALSE)
	{
		return;
	}

	if(l.open(IO_ReadOnly) == FALSE)
	{
		return;
	}
				
	QDomDocument mysql("mysql");

	if(mysql.setContent(&l) == FALSE)
	{
		l.close();
		return;
	}

	l.close();

	QDomNodeList node= mysql.elementsByTagName("SERVER");

	int count = node.count();

	QListViewItem *dummy = NULL;

	for(int l = 0; l < count; l++)
	{
		QString host;
		QString user;
		QString password;
		QString database;
		QString port;
		QString socket;

		QDomNode l_;

		l_= node.item(l).firstChild();	// host node
		host = l_.firstChild().nodeValue();

		l_= l_.nextSibling();	// user node
		user = l_.firstChild().nodeValue();
					
		l_= l_.nextSibling();	// password node
		password = l_.firstChild().nodeValue();

		l_= l_.nextSibling();	// database node
		database = l_.firstChild().nodeValue();

		l_= l_.nextSibling();	// port node
		port = l_.firstChild().nodeValue();
					
		l_= l_.nextSibling();	// socket node
		socket = l_.firstChild().nodeValue();

		dummy = new ServerListViewItem(dialog->list, dummy, host, host, user, password, database, port, socket);
	
		if(l == 0)
		{
			dialog->slot_server(dummy);
		}
	}
}
