#include <qmenubar.h>
#include <qpopupmenu.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "table.h"

void MainWindow::slot_table()
{
	if(!flag)
	{
		return;	
	}
		
	MDIWindow* window = new MDIWindow(work_space, 0, WDestructiveClose);

	window->setFixedSize(491, 392);
	
	Table *table = new Table(&mysql, window);
	
	connect(table, SIGNAL(signal_error_log()), this, SLOT(slot_error_log()));
	connect(table, SIGNAL(signal_schema()), this, SLOT(slot_tree()));

    window->setCentralWidget(table);
			 
    window->setCaption(tr("Table"));

	QPopupMenu *l = new QPopupMenu();
	l->insertItem(tr("&Fire"), table, SLOT(slot_fire()), CTRL+Key_F);
	l->insertItem(tr("&Close"), table, SLOT(slot_close()), CTRL+Key_C);
	window->menuBar()->insertItem(tr("&File"), l);
	
	l = new QPopupMenu();
	l->insertItem(tr("&About..."), table, SLOT(slot_about()), Key_F1);
	window->menuBar()->insertItem(tr("&Help"), l);

	window->show();
}
