#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qheader.h>

#include "querylistview.h"
#include "multilinelistviewitem.h"

QueryListView::QueryListView(MYSQL *mysql, QWidget *parent)
	: QListView(parent)
{
	this->mysql = mysql;

	setAllColumnsShowFocus(TRUE);
}

QueryListView::~QueryListView()
{
}

void QueryListView::set_sql(const QString &database, const QString &sql)
{
	this->sql = sql;
	this->database = database;
}

bool QueryListView::execute()
{
	int l;

	l = columns();

	for(int i = l - 1; i >=0; i--)
	{
		removeColumn(i);
	}

	clear();

	setSorting(-1);
	
	MultiLineListViewItem *si;

    setRootIsDecorated(FALSE);
	
	if(database.length() == 0)
	{
	}
	else
	{
		mysql_select_db(mysql,database.latin1());
	}

	if((mysql_query(mysql, sql.latin1())))
	{
		emit signal_error_log();
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
	
		return FALSE; 	 
	}

	result = mysql_store_result(mysql);
	
	if(result == NULL)
	{
		return FALSE;
	}

	while((field = mysql_fetch_field(result)))
	{
		addColumn(field->name);
	}

	while((row = mysql_fetch_row(result)))
	{
		si = new MultiLineListViewItem(this);
	
		for(unsigned int l = 0; l < mysql_num_fields(result); l++)
		{
			si->setText(l, QString::fromLocal8Bit(row[l]));
		}

		set_row_height(si);
	}

	mysql_free_result(result);

	return TRUE;
}

void QueryListView::set_row_height(QListViewItem *si)
{
	int height = 1;

	int column = si->listView()->columns();

	for(int l = 0; l < column; l++)
	{
		int si_ = get_newline_number(si->text(l));

		if(si_ > height)
		{
			height = si_;
		}
	}

	((MultiLineListViewItem *)si)->set_height(21 * height);
}

int QueryListView::get_newline_number(const QString &string)
{
	int l = string.length();

	int total = 0;

	for(int si = 0; si < l; si++)
	{
		if(string[si] == '\n')
		{
			total++;
		}
	}

	return total;
}

void QueryListView::slot_clear()
{
	int l;

	l = columns();

	for(int i = l - 1; i >=0; i--)
	{
		removeColumn(i);
	}

	clear();
}

void QueryListView::slot_save()
{
	QString name = QFileDialog::getSaveFileName("", QString::null, this);
	if(name.isEmpty()) 
	{
		return;
    } 

	QString buffer;

	QFile sql(name);

	if(sql.open(IO_WriteOnly) == FALSE)
	{
		debug("open failed");
		return;
	}

	buffer += "# Query result dump utility version 0.0.1\n";
	buffer += "[SQL]\n";
	buffer += this->sql;
	buffer += "\n";
	buffer += "[Field]\n";

	int column = columns();

	for(int i = 0; i < column; i++)
	{
		buffer += header()->label(i);
		buffer += " ";
	}
	buffer += "\n";

	QListViewItemIterator l(this);

	buffer += "[Data]\n";

	for(; l.current(); ++l)
	{
		for(int i = 0; i < column; i++)
		{
			if(l.current()->text(i).isEmpty())
			{
				buffer += "NULL";
			}
			else
			{
				buffer += l.current()->text(i);
			}
			buffer += " ";
		}
		buffer += "\n";
	}

	//debug(buffer.latin1());

	sql.writeBlock(buffer.latin1(), buffer.length());

	sql.close();
}

void QueryListView::slot_close()
{
	parentWidget()->close();
}

void QueryListView::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("Query result window version 0.0.1.\n"));
}
