/********************************************************/
/* mysql_structure_dumper.c
/*
/* Author: Thomas Wana
/* Date  : 1999-08-04 
/*
/* Dumps the structure of all tables in a given Data-
/* base to a file. Useful for documentation purposes.
/*
/* REQUIRES: *) mysql > 3.22.x (tested OK with 3.22.24)
/*
/********************************************************/

#include <stdio.h>
#include <ncurses.h>
#include <string.h>
#include <stdlib.h>
#include <mysql.h>
#include <unistd.h>

#define VERSION "1.0"

char user[20],password[30];
char query[500],database[80];
 
void main(int argc, char **argv)
{
   MYSQL mysql;
   MYSQL_ROW row;
   MYSQL_RES *result;
   MYSQL_FIELD *field;
   FILE *fp;
   char taste,hilf[30],execute[500];
   unsigned long delay;
   int ende,i,j,k,x,y,columns;
   char filename[80], mysqlexe[80];
   int row_width[80];

   printf("MYSQL STRUCTURE DUMPER %s - (c) 1999 by Thomas Wana <wana@ycom.at>\n\n",VERSION);
   printf("Username to connect to MySQL: ");
   gets(user);
   printf("Password to connect to MySQL: ");
   gets(password); 
   printf("Database to dump: ");
   gets(database);
   mysql_init(&mysql);
   printf("Assuming MySQL is on localhost...\n");
   if(mysql_real_connect(&mysql,"localhost",user,password,database,0,NULL,0))
   {
      printf("Successfully connected.\n\n");
      do
      {
         printf("Filename to store the dump: ");
         gets(filename);
         fp=fopen(filename,"w");
      } while(!fp);
      fclose(fp);                       // created empty file
      printf("Tell me where the mysql-executable is (Example: /usr/local/mysql/bin <- NO\nslash here! Enter '.' for active directory): ");
      gets(mysqlexe);
      sprintf(query,"show tables");   
      mysql_query(&mysql,query);
      result=mysql_store_result(&mysql);
      if(mysql_num_rows(result)==0)
      {
         printf("This database is empty!\n");
      }
      else
      {
         while((row=mysql_fetch_row(result))!=NULL)
         {
            printf("Dumping table %s...",row[0]);
            sprintf(execute,"echo -e \"\nTable %s:\" >> %s",row[0],filename);
            system(execute);
            sprintf(execute,"%s/mysql -u %s -p%s %s -t -e 'show columns from %s' >> %s",
              mysqlexe,user,password,database,row[0],filename);
            system(execute);
            printf("done.\n");
         } 
      }
      mysql_free_result(result);
      mysql_close(&mysql);
   }
   else
   {
      printf("Unable to connect.\nError: %s\n",mysql_error(&mysql));
   }
}
