import java.io.*;
import java.awt.datatransfer.*;

public class TextClipBoard 
{
    private TextClipBoard()
    {
	instance = this;
    }

    public static TextClipBoard Instance()
    {
	if (instance == null)
	    {
		new TextClipBoard();
	    }
	return instance;
    }

    public void copyToClipBoard (String text)
    {
	if (text.length() > 0)
	    {
		StringSelection selection = new StringSelection (text);
		java.awt.Toolkit.getDefaultToolkit().getSystemClipboard().setContents (selection, selection);
	    }
    }

    public String getClipBoardContent()
    {
	Transferable trans = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard().getContents (this);
	
	try
	    {
		return new String ((String)trans.getTransferData (DataFlavor.stringFlavor));
	    }
	catch (UnsupportedFlavorException ex1)
	    {
		return new String ("");
	    }
	catch (IOException ex2)
	    {
		return new String ("");
	    }
    }

    private static TextClipBoard instance = null;
}




