/*
 * Decompiled with CFR 0.152.
 */
package twz1.jdbc.mysql;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import java.util.Vector;
import twz1.jdbc.mysql.jdbcMysqlBag;
import twz1.jdbc.mysql.jdbcMysqlBase;
import twz1.jdbc.mysql.jdbcMysqlConnex;
import twz1.jdbc.mysql.jdbcMysqlPSParam;
import twz1.jdbc.mysql.jdbcMysqlRSet;
import twz1.jdbc.mysql.jdbcMysqlResult;
import twz1.jdbc.mysql.jdbcMysqlStmt;

public final class jdbcMysqlPStmt
extends jdbcMysqlStmt
implements PreparedStatement {
    Vector fixedStatement = new Vector();
    Vector parameters = new Vector();
    int fsize;
    int psize;
    int pCommandValue;
    String pCommandWord;

    public jdbcMysqlPStmt(jdbcMysqlConnex jdbcMysqlConnex2, String string) throws SQLException {
        super(jdbcMysqlConnex2);
        this.prepParse(string);
    }

    private void prepParse(String string) throws SQLException {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "?", true);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    if (string3.equals("?")) {
                        this.errHandlerM(21, "");
                    }
                    this.getCommandValue(string3);
                    this.pCommandValue = this.commandValue;
                    this.pCommandWord = this.commandWord;
                    string2 = string3;
                    n = 1;
                    break;
                }
                case 1: {
                    if (string3.equals("?")) {
                        n = 2;
                        break;
                    }
                    string2 = new String(String.valueOf(string2) + string3);
                    break;
                }
                case 2: {
                    if (string3.equals("?")) {
                        string2 = new String(String.valueOf(string2) + "?");
                    } else {
                        this.newFixed(string2);
                        this.newParam();
                        string2 = string3;
                    }
                    n = 1;
                }
            }
        }
        if (n == 0) {
            this.errHandlerM(22, "");
        }
        this.newFixed(string2);
        if (n == 2) {
            this.newParam();
        }
        this.fsize = this.fixedStatement.size();
        this.psize = this.parameters.size();
    }

    private void newFixed(String string) {
        byte[] byArray = string.getBytes();
        this.fixedStatement.addElement(byArray);
    }

    private void newParam() {
        jdbcMysqlPSParam jdbcMysqlPSParam2 = new jdbcMysqlPSParam(this.parameters.size() + 1);
        this.parameters.addElement(jdbcMysqlPSParam2);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.doMe(15, n, null, null, 0);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        int n2 = bl ? 1 : 0;
        this.doMe(16, n, null, null, n2);
    }

    public void setByte(int n, byte by) throws SQLException {
        byte by2 = by;
        this.doMe(17, n, null, null, by2);
    }

    public void setShort(int n, short s) throws SQLException {
        short s2 = s;
        this.doMe(18, n, null, null, s2);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.doMe(19, n, null, null, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        Long l2 = new Long(l);
        this.doMe(20, n, null, l2, 0);
    }

    public void setFloat(int n, float f) throws SQLException {
        Float f2 = new Float(f);
        this.doMe(21, n, null, f2, 0);
    }

    public void setDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        this.doMe(22, n, null, d2, 0);
    }

    public void setString(int n, String string) throws SQLException {
        this.doMe(23, n, string, null, 0);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.doMe(24, n, null, byArray, 0);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.doMe(25, n, null, date, 0);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.doMe(26, n, null, time, 0);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.doMe(27, n, null, timestamp, 0);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.doMe(28, n, null, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.doMe(29, n, null, inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.doMe(30, n, null, inputStream, n2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.doMe(31, n, null, bigDecimal, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.doMe(32, n, null, object, n2);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.doMe(32, n, null, object, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.doMe(32, n, null, object, 0);
    }

    public void clearParameters() throws SQLException {
        this.doMe(33, 0, null, null, 0);
    }

    private void doMe(int n, int n2, String string, Object object, int n3) throws SQLException {
        int n4 = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        jdbcMysqlPSParam jdbcMysqlPSParam2 = null;
        if (n != 33) {
            if (n2 < 1 || n2 > this.psize) {
                this.errHandlerM(24, "");
            }
            jdbcMysqlPSParam2 = (jdbcMysqlPSParam)this.parameters.elementAt(n2 - 1);
        }
        try {
            bl = this.lock(true, n4, this.lTimeout);
            if (!this.open) {
                this.errHandlerM(16, jdbcMysqlStmt.apis[n]);
            }
            switch (n) {
                case 15: {
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.nulled = true;
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    String string2 = String.valueOf(n3);
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string2);
                    break;
                }
                case 20: {
                    Long l = (Long)object;
                    String string3 = l.toString();
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string3);
                    break;
                }
                case 21: {
                    Float f = (Float)object;
                    String string4 = f.toString();
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string4);
                    break;
                }
                case 22: {
                    Double d = (Double)object;
                    String string5 = d.toString();
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string5);
                    break;
                }
                case 23: {
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string);
                    break;
                }
                case 24: {
                    byte[] byArray = (byte[])object;
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addBytes(byArray, -1);
                    break;
                }
                case 25: {
                    Date date = (Date)object;
                    String string6 = date.toString();
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string6);
                    break;
                }
                case 26: {
                    Time time = (Time)object;
                    String string7 = time.toString();
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string7);
                    break;
                }
                case 27: {
                    Timestamp timestamp = (Timestamp)object;
                    String string8 = timestamp.toString();
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string8);
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    InputStream inputStream = (InputStream)object;
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.is = inputStream;
                    jdbcMysqlPSParam2.streamSetSize = n3;
                    break;
                }
                case 31: {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    String string9 = bigDecimal.toString();
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string9);
                    break;
                }
                case 32: {
                    if (n3 == 1111) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.flush();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        jdbcMysqlPSParam2.clear();
                        jdbcMysqlPSParam2.addBytes(byArray, -1);
                        break;
                    }
                    String string10 = object.toString();
                    jdbcMysqlPSParam2.clear();
                    jdbcMysqlPSParam2.addString(string10);
                    break;
                }
                case 33: {
                    int n5 = this.parameters.size();
                    int n6 = 0;
                    while (n6 < n5) {
                        jdbcMysqlPSParam2 = (jdbcMysqlPSParam)this.parameters.elementAt(n6);
                        jdbcMysqlPSParam2.clear();
                        ++n6;
                    }
                    break;
                }
                default: {
                    this.errHandlerM(25, String.valueOf(n));
                }
            }
            bl = this.lock(false, n4, this.lTimeout);
            return;
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, n4, this.lTimeout);
            }
            this.errHandlerE2(23, jdbcMysqlStmt.apis[n], exception);
            return;
        }
    }

    public int executeUpdate() throws SQLException {
        int n = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        int n2 = -1;
        try {
            bl = this.lock(true, n, this.lTimeout);
            if (!this.open) {
                this.errHandlerM(16, "executeUpdate()");
            }
            this.qResult.clear();
            if (this.pCommandValue < 100 || this.pCommandValue > 199) {
                this.errHandlerM(1, this.pCommandWord);
            }
            this.mExecUpdate();
            n2 = this.qResult.getRows();
            bl = this.lock(false, n, this.lTimeout);
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, n, this.lTimeout);
            }
            this.errHandlerE(9, exception);
        }
        return n2;
    }

    void mExecUpdate() throws SQLException {
        String string;
        int n;
        block8: {
            n = -1;
            string = null;
            boolean bl = false;
            try {
                bl = this.cx.lock(true, this.myOID, this.lTimeout);
                this.mxEU();
                bl = this.cx.lock(false, this.myOID, this.lTimeout);
            }
            catch (Exception exception) {
                boolean bl2 = false;
                if (this.cx.broken && this.autoReX) {
                    try {
                        this.cx.xOpen();
                        this.mxEU();
                        bl2 = true;
                    }
                    catch (Exception exception2) {}
                }
                if (bl) {
                    this.cx.lock(false, this.myOID, this.lTimeout);
                }
                if (bl2) break block8;
                this.errHandlerE(2, exception);
            }
        }
        jdbcMysqlResult jdbcMysqlResult2 = this.qResult;
        n = jdbcMysqlResult2.lastStatus;
        if (n == 255) {
            jdbcMysqlResult2 = this.qResult;
            string = jdbcMysqlResult2.sMessage;
            this.errHandlerM(3, String.valueOf(String.valueOf(-1)) + " " + string);
        }
        if (n != 0) {
            this.errHandlerM(4, String.valueOf(n));
        }
    }

    private void mxEU() throws SQLException {
        jdbcMysqlBag jdbcMysqlBag2 = this.outBag;
        jdbcMysqlBag2.maxAt = 4;
        jdbcMysqlBag2.at = 4;
        jdbcMysqlBag2.seq = 0;
        this.outBag.iToB(3, 1);
        this.putParameters();
        this.outBag.write();
        this.qResult.getResult(1, this.commandValue);
    }

    public ResultSet executeQuery() throws SQLException {
        int n = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        ResultSet resultSet = null;
        jdbcMysqlRSet jdbcMysqlRSet2 = null;
        try {
            bl = this.lock(true, n, this.lTimeout);
            if (!this.open) {
                this.errHandlerM(16, "executeQuery()");
            }
            if (this.pCommandValue < 200 || this.pCommandValue > 399) {
                this.errHandlerM(5, this.pCommandWord);
            }
            this.qResult.clear();
            resultSet = this.mExecQuery();
            if (resultSet != null) {
                jdbcMysqlRSet2 = (jdbcMysqlRSet)resultSet;
                jdbcMysqlRSet2.retrieved = true;
            }
            bl = this.lock(false, n, this.lTimeout);
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, n, this.lTimeout);
            }
            this.errHandlerE(10, exception);
        }
        return resultSet;
    }

    ResultSet mExecQuery() throws SQLException {
        jdbcMysqlRSet jdbcMysqlRSet2;
        block8: {
            jdbcMysqlRSet2 = null;
            boolean bl = false;
            try {
                bl = this.cx.lock(true, this.myOID, this.lTimeout);
                jdbcMysqlRSet2 = this.mxEQ();
                if (this.qResult.cacheMode != 2) {
                    bl = this.cx.lock(false, this.myOID, this.lTimeout);
                }
            }
            catch (Exception exception) {
                if (this.cx.broken) {
                    try {
                        this.cx.xOpen();
                        jdbcMysqlRSet2 = this.mxEQ();
                        if (this.qResult.cacheMode != 2) {
                            bl = this.cx.lock(false, this.myOID, this.lTimeout);
                        }
                    }
                    catch (Exception exception2) {}
                }
                if (jdbcMysqlRSet2 != null) break block8;
                if (bl) {
                    this.cx.lock(false, this.myOID, this.lTimeout);
                }
                this.errHandlerE(6, exception);
            }
        }
        return jdbcMysqlRSet2;
    }

    private jdbcMysqlRSet mxEQ() throws SQLException {
        jdbcMysqlBag jdbcMysqlBag2 = this.outBag;
        jdbcMysqlBag2.maxAt = 4;
        jdbcMysqlBag2.at = 4;
        jdbcMysqlBag2.seq = 0;
        this.outBag.iToB(3, 1);
        this.putParameters();
        this.outBag.write();
        this.qResult.getResult(2, this.pCommandValue);
        jdbcMysqlRSet jdbcMysqlRSet2 = new jdbcMysqlRSet(this.qResult);
        return jdbcMysqlRSet2;
    }

    public boolean execute() throws SQLException {
        int n = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        ResultSet resultSet = null;
        try {
            bl = this.lock(true, n, this.lTimeout);
            this.qResult.clear();
            if (this.pCommandValue > 200 && this.pCommandValue < 400) {
                resultSet = this.mExecQuery();
            } else if (this.pCommandValue > 100 && this.pCommandValue < 200) {
                this.mExecUpdate();
            } else {
                this.errHandlerM(13, "");
            }
            bl = this.lock(false, n, this.lTimeout);
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, n, this.lTimeout);
            }
            this.errHandlerE(14, exception);
        }
        return resultSet != null;
    }

    void putParameters() throws SQLException {
        try {
            int n = 0;
            while (n < this.fsize) {
                byte[] byArray = (byte[])this.fixedStatement.elementAt(n);
                this.outBag.putByteArray(byArray, -1);
                if (n < this.psize) {
                    jdbcMysqlPSParam jdbcMysqlPSParam2 = (jdbcMysqlPSParam)this.parameters.elementAt(n);
                    jdbcMysqlPSParam2.bagIt(this.outBag);
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            this.errHandlerE(26, exception);
            return;
        }
    }
}

