/**
*** Program Row.java     
***    in product twz1jdbcForMysql, 
***    Copyright 1997, 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

package twz1.jdbc.mysql;
import java.sql.*;

final class Row
{
byte[] data;
Object[] bytes;
String[] sData;
int[] offsets;
int[] lengths;
int maxField;
boolean fake;
int columns;
jdbcMysqlBag bag;

final static String[] errs = {
       "E2100 Error in Row constructor.",
       "E2101 Error in Row initiation.",
       "E2102 Error in Row.getBytes().",
       "E2103 Error in Row.getString()."
       };

Row(jdbcMysqlResult result) throws SQLException
    {
    try{
        this.columns = result.metadata.cc;
        this.fake = result.cacheMode == result.CM_PHONEY;
        this.offsets = new int[columns];
        this.lengths = new int[columns];
        this.bytes   = new Object[columns];
        this.sData   = new String[columns];
        this.maxField = result.statement.maxFieldSize;
        if(!fake) bag = new jdbcMysqlBag(0);
        }
    catch(Exception e) { errhandler(0, e); }
    }

void init(Object in) throws SQLException
    {
    try {
        if(fake)
            {
            data = null;
            bytes = (Object[]) in;
            for(int i = 0; i < columns; i++) 
                {
                offsets[i] = -1;
                sData[i] = null;
                }
            }        
        else{
            data = (byte[]) in;
            bag.inside = data;
            bag.at = 4;
            bag.maxAt = data.length;
            for(int i = 0; i < columns; i++)
	        {
                int t = bag.xToI();
                offsets[i] = bag.at;
                lengths[i] = t > maxField ? maxField : t;
                if(t != -1) bag.at += t;
                bytes[i] = null;
                sData[i] = null;
                }
           }
        }
    catch(Exception e) { errhandler(1, e); }
    } 

byte[] getBytes(int c) throws SQLException
    {
    byte[] b = null;
    try {
        int o = offsets[c];
        if(o == -1) return (byte[])bytes[c];
        int l = lengths[c];
        if(l > -1)
            { 
            b = new byte[l];
            System.arraycopy(data, o, b, 0, l);
            }
        offsets[c] = -1;
        bytes[c] = b;
        }
    catch(Exception e) { errhandler(2, e); }
    return b;
    }  

String getString(int c) throws SQLException
    {
    String s = null;
    try {
        s = sData[c];
        if(s != null) return s;
        int o = offsets[c];
        if(o < 0) 
            {
            if(bytes[c] != null) s = new String((byte[])bytes[c]);
            }
        else{
            int l = lengths[c];
            if(l > -1) s = new String(data, o, l);
            }
        sData[c] = s;
        }
    catch(Exception e) { errhandler(3, e); }
    return s;
    }
     
private void errhandler(int i, Exception e) throws SQLException
    {
    String u = e.getMessage();
    if(u == null || u.length() == 0) u = e.toString();
    u = "\n" + errs[i] + " " + u;
    jdbcMysqlBase.errMessage(u);
    }
}
