
import twz1.jdbc.mysql.*;
import java.sql.*;
import java.lang.String;
import java.util.Random;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
public class jdbctest1
{
int mutwait;

public static void main(String[] arg)
    {
    new jdbctest1();
    }

jdbctest1()
    {
    int xrc;
    String ws1, ws2, ws3, ws4, ws5;
    boolean brc;

//-------------------------------------------------------------

    header("Loading Driver");

    try {
        Class.forName("twz1.jdbc.mysql.jdbcMysqlDriver");
        }
    catch(Exception e){System.out.println(e);}


//-------------------------------------------------------------

    header("Displaying default properties");

    String t[] = jdbcMysqlBase.getDefaultNames();
    for(int i = 0; i < t.length; i++)
        {
        System.out.println(t[i] + "  " + 
               jdbcMysqlBase.getDefault(t[i]));
        }

//------------------------------------------------------------

    header("The following connex will FAIL");

    Connection cx = null;
    String url = "jdbc:z1MySQxL:";
    try {
        cx = DriverManager.getConnection(url);
        }
    catch(SQLException se){System.out.println(se);} 
 

//------------------------------------------------------------ 

    header("The following connex will succeed");

    cx = null;
    url = "jdbc:z1MySQL:";
    try {
        cx = DriverManager.getConnection(url);
        }
    catch(SQLException se){System.out.println(se);} 
  
//------------------------------------------------------------
  
    header("Setting catalog to jdbctest");

    try {
        cx.setCatalog("jdbctest");
        String s = cx.getCatalog();
        System.out.println("Catalog is now " + s);
        }
    catch(Exception e) { System.out.println(e); }
 
//------------------------------------------------------------ 
     header("test multiple query");
     try{ 
        boolean mc = jdbcMysqlBase.isMultipleQuery((jdbcMysqlConnex) cx);
        System.out.println("Is connection multiple query: " + mc);
        }
    catch(Exception e) { System.out.println(e); }
    
//------------------------------------------------------------ 

    header("Creating statement");

    Statement st = null;

    try {
        st = cx.createStatement();
        }
    catch(Exception e) { e.printStackTrace(); }

//------------------------------------------------------------

    header("Creating table");

    try {
        xrc = st.executeUpdate( "create table books (rownum int not null"
                              +   " auto_increment, bname text not null,"
                              +   " author text not null, pubdate int,"
                              +   " isbn char(20) not null, price decimal(6,2),"
                              +   " primary key(isbn), index(rownum))" ); 
        System.out.println("Returns " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

//------------------------------------------------------------

    header("Loading table via inserts");

    try {
        xrc = st.executeUpdate( "insert into books values(0, 'Essential System Administration', 'Frisch', 1993, '0-937175-80-3', 29.95)");
        System.out.println("Returns " + xrc);
        xrc = st.executeUpdate( "insert into books values(0, 'C, the Complete Reference',  'Schildt', 1987, '0-07-881263-1', 24.95)");
        System.out.println("Returns " + xrc);
        xrc = st.executeUpdate( "insert into books values(0, 'Teach Yourself C++',  'Stevens', 1993, '1-55828-250-5', 29.95)");
        System.out.println("Returns " + xrc);
        xrc = st.executeUpdate( "insert into books values(0, 'Operating Systems, Design and Implementation',  'Tanenbaum', 1987, '0-13-637406-9', 59.95)");
        System.out.println("Returns " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

//-----------------------------------------------------------------
    header("Trying insert via prepared");

   try {
       String s = "insert into books values(?, ?, ?, ?, ?, ?)";
       PreparedStatement ps = cx.prepareStatement(s);
       ps.setInt(1, 0);
       ps.setString(2, "Slackware Linux Unleashed");
       ps.setString(3, "Parker, et al.");
       ps.setInt(4, 1997);
       ps.setString(5, "0-672-31012-0");
       ps.setFloat(6, 49.99F);
       ps.execute();
       ps.close();
 // Testing double-quote escape.
       s = "insert into books values(0, '??', ?, ?, '??', ?)";
       ps = cx.prepareStatement(s);
       ps.setString(1, "Who??");
       ps.setInt(2, 0);
       ps.setFloat(3, 0.0F);
       ps.execute();
       ps.close();
       }
    catch(Exception e) { e.printStackTrace(); }


//-----------------------------------------------------------------

    header("Executing Query by column number");

    try {
        ResultSet rs = st.executeQuery("select * from books");
        while(rs.next())
            {
            String a, b, c, d, e, f;
            a = rs.getString(1);
            b = rs.getString(2);
            c = rs.getString(3);
            d = rs.getString(4);
            e = rs.getString(5);
            f = rs.getString(6);
            System.out.println(a + " - " + b + " - " + c + " - " 
                               + d + " - " + e + " - " + f);
            }
        rs.close();
        }
    catch(Exception e) { e.printStackTrace(); }

//-----------------------------------------------------------------

    header("Creating second statement");

    Statement st2 = null;

    try {
        st2 = cx.createStatement();
        }
    catch(Exception e) { e.printStackTrace(); }

//-----------------------------------------------------------------

    header("Testing delete");

    try { 
        xrc = st2.executeUpdate("delete from books where author like 'Sch%'");
        System.out.println("Result " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }
     

//-----------------------------------------------------------------

    header("Testing failing delete");

    try { 
        xrc = st2.executeUpdate("delete from books where author like 'Sch%'");
        System.out.println("Result " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }
     
//-----------------------------------------------------------------

    header("Testing update");

    try { 
        xrc = st2.executeUpdate("update books set price = 9.91 where author like '%s%'");
        System.out.println("Result " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }
     
//-----------------------------------------------------------------

    header("ReExecuting Query by column name");

    try {
        ResultSet rs = st.executeQuery("select bname, pubdate, price from books");
        while(rs.next())
            {
            String za, zba; byte[] ba;
            int b; short sb; long lb; String zb; float fb;
            String zc; float fc; double dc;
            za = rs.getString("bname");
            ba = rs.getBytes("bname"); zba = new String(ba);
            System.out.println("\nbname: string: " + za + "   bytes: " + zba);

            b = rs.getInt("pubdate");
            sb = rs.getShort("pubdate");
            lb = rs.getLong("pubdate");
            fb = rs.getFloat("pubdate");
            System.out.println( "pubdate int: " + b + "  short " + sb 
                              + " long " + lb + " float " + fb);
           
            zc = rs.getString("price");
            fc = rs.getFloat("price");
            dc = rs.getDouble("price");
            System.out.println( "price: string " + zc + "  float " 
                              + fc + "  double " + dc);
            }
        rs.close();
        }
    catch(Exception e) { e.printStackTrace(); }

//---------------------------------------------------------------------

    header("Testing ResultSetMetadata");

    try {
        ResultSet rs = st.executeQuery("select * from books");
        ResultSetMetaData md = rs.getMetaData();
        int ncols = md.getColumnCount();
        System.out.println ("Number of columns : " + ncols);
        String w1, w2, w3, w4;        
        int i1;
        for(int i = 1 ; i <= ncols; i++)
            {
            System.out.println("");
            w1 = md.getTableName(i);
            w2 = md.getColumnName(i);
            w3 = md.getColumnTypeName(i);
            System.out.println( "\nTable " + w1 + "   Name " + w2 
                              + "   Type " + w3);
            i1 = md.getColumnDisplaySize(i);
            w1 = md.isAutoIncrement(i) ? "true": "false" ;
            w2 = md.isNullable(i) == md.columnNullable ? "true" : "false"; 
            System.out.println( "Display size " + i1 + "   Autoincrement: " 
                              + w1 + "   Nullable : " + w2);
            w4 = md.getCatalogName(i);
            System.out.println("Catalog: " + w4);
            }
        }
    catch(Exception e) { e.printStackTrace(); }

//---------------------------------------------------------------

    header("Executing Query by multiple statements");

    try {
        ResultSet rs1 = st.executeQuery("select * from books");
        ResultSet rs2 = st2.executeQuery("select bname, author from books");
        rs1.next();
        rs2.next();
        rs2.next();
        String a, b;
        a = rs1.getString("bname");
        b = rs2.getString("bname");
        System.out.println("st1 book " + a + "   st2 book " + b);
       
        rs1.close();
        rs2.close();
        }
    catch(Exception e) { e.printStackTrace(); }

//----------------------------------------------------------------

    header("Deleting everything");
    try {
        st.executeUpdate("DELETE FROM books");

        header("ReExecuting Query by column name");
        String za;

        ResultSet rs = st.executeQuery("select bname from books");
        while(rs.next())
            {
            za = rs.getString(1);
            System.out.println("--> " + za);
            }
        rs.close();
        }
    catch(Exception e) { e.printStackTrace(); }

//----------------------------------------------------------------

    header("Dropping table");

    try {
        xrc = st.executeUpdate( "drop table books");
        System.out.println("Returns " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

//---------------------------------------------------------------

    header("closing statements");
    
    try { st.close(); st2.close(); }
    catch(Exception e) { e.printStackTrace(); } 

//---------------------------------------------------------------

    System.out.println("\n\n\n");
    header("Doing it all over with execute()");

//------------------------------------------------------------ 

    header("Creating statement");

    st = null;

    try {
        st = cx.createStatement();
        }
    catch(Exception e) { e.printStackTrace(); }

//------------------------------------------------------------

    header("Creating table");

    try {
        brc = st.execute( "create table books (rownum int not null"
                        +   " auto_increment, bname text not null,"
                        +   " author text not null, pubdate int,"
                        +   " isbn char(20) not null, price decimal(6,2),"
                        +   " primary key(isbn), index(rownum))" );
        System.out.println("table creation execute: " + brc);
        xrc = st.getUpdateCount();
        System.out.println("Returns " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

//------------------------------------------------------------

    header("Loading table via inserts");

    try {
        brc = st.execute( "insert into books values(0, 'Essential System Administration', 'Frisch', 1993, '0-937175-80-3', 29.95)");
        xrc = st.getUpdateCount();
        System.out.println("Returns " + brc + " " + xrc);
        brc = st.execute( "insert into books values(0, 'C, the Complete Reference',  'Schildt', 1987, '0-07-881263-1', 24.95)");
        xrc = st.getUpdateCount();
        System.out.println("Returns " + brc + " " + xrc);
        brc = st.execute( "insert into books values(0, 'Teach Yourself C++',  'Stevens', 1993, '1-55828-250-5', 29.95)");
        xrc = st.getUpdateCount();
        System.out.println("Returns " + brc + " " + xrc);
        brc = st.execute( "insert into books values(0, 'Operating Systems, Design and Implementation',  'Tanenbaum', 1987, '0-13-637406-9', 59.95)");
        xrc = st.getUpdateCount();
        System.out.println("Returns " + brc + " " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

//-----------------------------------------------------------------

    header("Executing Query by column number");

    try {
        brc = st.execute("select * from books");
        ResultSet rs = st.getResultSet();
        while(rs.next())
            {
            String a, b, c, d, e, f;
            a = rs.getString(1);
            b = rs.getString(2);
            c = rs.getString(3);
            d = rs.getString(4);
            e = rs.getString(5);
            f = rs.getString(6);
            System.out.println(a + " - " + b + " - " + c + " - " 
                               + d + " - " + e + " - " + f);
            }
        rs.close();
        }
    catch(Exception e) { e.printStackTrace(); }

//-----------------------------------------------------------------

    header("Creating second statement");

    st2 = null;

    try {
        st2 = cx.createStatement();
        }
    catch(Exception e) { e.printStackTrace(); }

//-----------------------------------------------------------------

    header("Testing delete");

    try { 
        brc = st2.execute("delete from books where author like 'Sch%'");
        xrc = st2.getUpdateCount();
        System.out.println("Result " + brc + " " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }
     

//-----------------------------------------------------------------

    header("Testing failing delete");

    try { 
        brc = st2.execute("delete from books where author like 'Sch%'");
        xrc = st2.getUpdateCount();
        System.out.println("Result " + brc + " " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }
     
//-----------------------------------------------------------------

    header("Testing update");

    try { 
        brc = st2.execute("update books set price = 9.91 where author like 'S%'");
        xrc = st2.getUpdateCount();
        System.out.println("Result " + brc + " " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }
     
//-----------------------------------------------------------------

    header("ReExecuting Query by column name");

    try {
        brc = st.execute("select bname, pubdate, price from books");
        ResultSet rs = st.getResultSet();
        while(rs.next())
            {
            String za, zba; byte[] ba;
            int b; short sb; long lb; String zb; float fb;
            String zc; float fc; double dc;
            za = rs.getString("bname");
            ba = rs.getBytes("bname"); zba = new String(ba);
            System.out.println("\nbname: string: " + za + "   bytes: " + zba);

            b = rs.getInt("pubdate");
            sb = rs.getShort("pubdate");
            lb = rs.getLong("pubdate");
            fb = rs.getFloat("pubdate");
            System.out.println( "pubdate int: " + b + "  short " + sb 
                              + " long " + lb + " float " + fb);
           
            zc = rs.getString("price");
            fc = rs.getFloat("price");
            dc = rs.getDouble("price");
            System.out.println( "price: string " + zc + "  float " 
                              + fc + "  double " + dc);
            }
        rs.close();
        }
    catch(Exception e) { e.printStackTrace(); }

//---------------------------------------------------------------------

    header("Testing ResultSetMetadata");

    try {
        brc = st.execute("select * from books");
        ResultSet rs = st.getResultSet();
        ResultSetMetaData md = rs.getMetaData();
        int ncols = md.getColumnCount();
        System.out.println ("Number of columns : " + ncols);
        String w1, w2, w3;        
        int i1, i2, i3;
        for(int i = 1 ; i <= ncols; i++)
            {
            System.out.println("");
            w1 = md.getTableName(i);
            w2 = md.getColumnName(i);
            w3 = md.getColumnTypeName(i);
            System.out.println( "Table " + w1 + "   Name " + w2 
                              + "   Type " + w3);
            i1 = md.getColumnDisplaySize(i);
            w1 = md.isAutoIncrement(i) ? "true": "false" ;
            w2 = md.isNullable(i) == md.columnNullable ? "true" : "false";
            System.out.println( "Display size " + i1 + "   Autoincrement: " 
                              + w1 + "   Nullable : " + w2);
            if(w3.equals("INTEGER" ) || w3.equals("DECIMAL"))
                {
                i2 = md.getPrecision(i);
                i3 = md.getScale(i);
                System.out.println(w2 + " precision: " + i2 
                                 + "   scale: " + i3);
                }
            }
        }
    catch(Exception e) { e.printStackTrace(); }

//---------------------------------------------------------------

    header("Executing Query by multiple statements");

    try {
        st.execute("select * from books");
        ResultSet rs1 = st.getResultSet();
        st2.execute("select bname, author from books");
        ResultSet rs2 = st2.getResultSet();
        rs1.next();
        rs2.next();
        rs2.next();
        String a, b;
        a = rs1.getString("bname");
        b = rs2.getString("bname");
        System.out.println("st1 book " + a + "   st2 book " + b);

        header("Exercise mutexes hard.");
        mutwait = 0;
        new jdbctest1muts(this, 1, rs1, rs2);
        new jdbctest1muts(this, 2, rs1, rs2); 
        new jdbctest1muts(this, 3, rs1, rs2); 
        new jdbctest1muts(this, 4, rs1, rs2); 
        waitFor(0, 4);
        rs1.close();
        rs2.close();
        }
    catch(Exception e) { e.printStackTrace(); }


//----------------------------------------------------------------

    header("Dropping table");

    try {
        brc = st.execute( "drop table books");
        xrc = st.getUpdateCount();
        System.out.println("Returns " + brc + " " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

//---------------------------------------------------------------

    header("closing statements");
    
    try { st.close(); st2.close(); }
    catch(Exception e) { e.printStackTrace(); } 

//---------------------------------------------------------------

    header("trying recursion, thanks, Steve Baker!");
    try {
        Statement nb = cx.createStatement();
        String ct = "create table nodes (keyx int, namex char(10), loc int)";
        nb.execute(ct);
        nb.execute("InserT into nodes values(1, 'Root Item', 0)");
        nb.execute("InserT into nodes values(2, 'Item 1   ', 1)");
        nb.execute("InserT into nodes values(3, 'Item 2   ', 1)");
        nb.execute("InserT into nodes values(4, 'Item 3   ', 1)");
        nb.execute("InserT into nodes values(5, 'Item 4   ', 3)");
        nb.execute("InserT into nodes values(6, 'Item 5   ', 4)");
        nb.execute("InserT into nodes values(7, 'Item 6   ', 5)");
        System.out.println("Calling disptree with key 1");
        disptree(cx, 1);
        System.out.println("Calling disptree with key 5");
        disptree(cx, 5);
        }
    catch(Exception e) { e.printStackTrace(); }
    try {
        Statement nb = cx.createStatement();
        nb.execute("DROP table nodes");
        nb.close();
        }
    catch(Exception e) { e.printStackTrace(); }

//---------------------------------------------------------------

    header("trying Big bags");
    try {
        Statement nb = cx.createStatement();
        String ct = "create table bigone (keyx int not null auto_increment," 
                   + " namex text,  stuff blob,"
                   + " primary key(keyx))";
        nb.execute(ct);
        StringBuffer sb = new StringBuffer(50000);
        FileInputStream fs = new FileInputStream("jdbctest1.java");
        int c, ic, sc;
        ic = sc = 0; 
        while((c = fs.read()) > -1)
            {
            if(c == '\\' || c == '\'' || c == '\"')
                {
                sc++;    
                sb.append('\\');
                }
            sb.append((char) c);
            ic++;
            sc++;
            }
        System.out.println(ic + " characters from \"jdbctest1.java\"" 
                          + " inserted as " + sc + " characters.");  
        String lcmd = new String("insert into bigone values(0,"
                                + "'jdbctest1.java', '" +
                                new String(sb) + "')");
        nb.execute(lcmd);
        System.out.println("Stored ...");

        nb.execute("select * from bigone");
        ResultSet rs = nb.getResultSet();
        rs.next();
        ct = rs.getString(3);
        System.out.println("Retrieved ...");
        FileOutputStream fo = new FileOutputStream("copy.jdbctest1.java");
        PrintWriter fp = new PrintWriter(fo);
        fp.print(ct);
        fp.close(); 
        rs.close();
        System.out.println("Written as \"copy.jdbctest1.java\".");
        System.out.println("Run a \"diff\" on the original and copy to "
                          +"verify operation integity.");
        }
    catch(Exception e) { e.printStackTrace(); }
        
    try {
        String s = "insert into bigone values(0, ?, ?)";
        PreparedStatement ps = cx.prepareStatement(s);
        ps.setString(1, "jdbctestbinary");
        FileInputStream fi = new FileInputStream("./jdbctestbinary");
        ps.setBinaryStream(2, fi, ps.getMaxFieldSize());
        ps.execute();
        }
    catch(Exception e) { e.printStackTrace(); }

    try {
        Statement nb = cx.createStatement();
        nb.execute("select stuff from bigone where namex='jdbctestbinary'");
        ResultSet rs = nb.getResultSet();
        rs.next();
        InputStream is = rs.getBinaryStream(1);
        FileOutputStream fos = new FileOutputStream("copy.jdbctestbinary");
        int c;
        while((c = is.read()) > -1) fos.write(c);
        fos.close();
        rs.close();
        }
    catch(Exception e) { e.printStackTrace(); }

    try {
        Statement nb = cx.createStatement();
        nb.execute("DROP table bigone");
        nb.close();
        }
    catch(Exception e) { e.printStackTrace(); }


//---------------------------------------------------------------

    header("closing connection");

    try { cx.close(); }
    catch(SQLException se){System.out.println(se);}
      
    }

//---------------------------------------------------------------
//---------------------------------------------------------------
//---------------------------------------------------------------
//---------------------------------------------------------------
//---------------------------------------------------------------
//---------------------------------------------------------------

synchronized void waitFor(int cmd, int howmany)
    {
    if(cmd == 0)
        {
        mutwait += howmany;
        while(mutwait > 0) 
            {
            System.out.println("waitloop " + mutwait);
            try {
                wait();
                } 
            catch(InterruptedException e ) {}
            }
        }
    else{
        mutwait--;
        notify();
        System.out.println("wait notify : " + mutwait);
        }
    }

void header(String h)
    {
    String bl = "-----------------------------------";
    String sl = "                                   ";
    bl = new String("+" + bl + bl + "+");
    System.out.println("\n");
    System.out.println(bl);
    String rl = h;
    String tl;
    int i, j, k;
    while(rl != null)
        {
        if(rl.length() > 60)
            {
            tl = rl.substring(0, 60);
            rl = rl.substring(60);
            }
        else { tl = rl; rl = null; }
        k = ( 71 - tl.length() ) / 2;
        tl = new String(sl.substring(0, k) + tl + sl.substring(0, k));
        while(tl.length() > 70) tl = tl.substring(1);
        tl = new String("|" + tl + "|");
        System.out.println(tl);
        }
    System.out.println(bl);
    System.out.println("");
    }
    
/** Thanks to Steve Baker, ssbaker@primenet.com for the following
*** code to test a recursive call.
**/
void disptree(Connection con, int Key)
    {

    String query = "SELECT keyx, namex FROM nodes " +
			   "WHERE loc = " + Key;
    try {

        Statement stmt = con.createStatement();      
        ResultSet rs = stmt.executeQuery(query);
        while(rs.next()) 
            {
            System.out.println("<"+rs.getString("namex")+">");
	    disptree(con, rs.getInt("keyx"));
            }
        rs.close(); 
        stmt.close();      
        }
    catch( Exception e ) 
        {
        System.out.println(e.getMessage());
        e.printStackTrace();
        }
    }
}
   
class jdbctest1muts implements Runnable
{
jdbctest1 jt;
ResultSet rs1, rs2;
int num;
Thread myThread;
static long rseed;
static Random mRand;
jdbctest1muts(jdbctest1 j, int n, ResultSet r1, ResultSet r2)
    {
    this.jt = j;
    this.num = n;
    this.rs1 = r1;
    this.rs2 = r2;
    if(num ==  1)
        {
        rseed = 123456789L;
        mRand = new Random(rseed);
        }
    Thread myThread = new Thread(this);
    myThread.start();
    System.out.println("Thread " + num + " started.");
    }

public void run()
    {
    System.out.println("Thread " + num + " running.");
    String s = "crap";
    int t;
    for(int i = 0; i < 100; i++)
        {
        try { s = rs1.getString("bname"); }
        catch(Exception e) { s = e.getMessage(); }
        System.out.println(num + " " + i + " rs1 " + s); 
        t = mRand.nextInt() % 300; if(t<0)t*= -1; t++;
        try{myThread.sleep(t);} catch(InterruptedException ie){}
        try { s = rs2.getString("bname"); }
        catch(Exception e) { s = e.getMessage(); }
        System.out.println(num + " " + i + " rs2 " + s); 
        t = mRand.nextInt() % 300; if(t<0)t*= -1; t++;
        try{myThread.sleep(t);} catch(InterruptedException ie){}
        }
    jt.waitFor(1, 0);
    }


}
