
import twz1.jdbc.mysql.*;
import java.sql.*;
import java.lang.String;
import java.util.Random;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
public class jdbctest2
{

public static void main(String[] arg)
    {
    new jdbctest2();
    }

jdbctest2()
    {
    int xrc;
    String ws1, ws2, ws3, ws4, ws5;
    boolean brc;
    ResultSetMetaData rsmd;

//-------------------------------------------------------------

    header("Loading Driver");

    try {
        Class.forName("twz1.jdbc.mysql.jdbcMysqlDriver");
        }
    catch(Exception e){System.out.println(e);}


//-------------------------------------------------------------
//------------------------------------------------------------
//------------------------------------------------------------ 

    header("The following connex will succeed");

    Connection cx = null;
    String url = "jdbc:z1MySQL:";
    try {
        cx = DriverManager.getConnection(url);
        System.out.println("catalog :" + cx.getCatalog());
        }
    catch(SQLException se){System.out.println(se);} 
  
//------------------------------------------------------------
  
    header("Setting catalog to jdbctest");

    try {
        cx.setCatalog("jdbctest");
        String s = cx.getCatalog();
        System.out.println("Catalog is now " + s);
        }
    catch(Exception e) { System.out.println(e); }
 
//------------------------------------------------------------ 
     header("test multiple query");
     try{ 
        boolean mc = jdbcMysqlBase.isMultipleQuery((jdbcMysqlConnex) cx);
        System.out.println("Is connection multiple query: " + mc);
        }
    catch(Exception e) { System.out.println(e); }
    
//------------------------------------------------------------ 
//------------------------------------------------------------

    header("Creating table");

    try {
        Statement st = cx.createStatement();
        xrc = st.executeUpdate( "create table hotdates(oid bigint(20) not null"
                              + " auto_increment, xdate date, xtime time, "  
                              + "ts timestamp, "
                              + "descx text, index(oid) )");
	st.executeUpdate("insert into hotdates values(17000000, 19981004, 2007, 0, 'A test')");
        st.close();
        System.out.println("Returns " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

//------------------------------------------------------------

    header("Loading table via inserts");

    try {
        String ss = "insert into hotdates values(0,?, ?, ?, ?)";
        PreparedStatement ps = cx.prepareStatement(ss);
        ps.setString(1, "1957-02-20");
        ps.setString(2, "05:57");
        ps.setString(3, "1971-01-01 00:00:00");
        ps.setString(4, "birth of very important person");
        ps.execute();
	ps.clearParameters();
        ps.setObject(1, "1969-07-20");
        ps.setObject(2, "15:20");
        ps.setObject(3, "1971-01-01 00:00:00");
        ps.setObject(4, "Lets go for a walk");
        ps.execute();
	ps.clearParameters();
        ps.setString(1, "1945-12-07");
        ps.setString(2, "07:10");
        ps.setNull(3, 0);
        ps.setString(4, "A day which will live in infamy ....");
        ps.execute();
	ps.clearParameters();
        ps.setString(1, "1998-08-12");
        ps.setString(2, "07:10");
        ps.setNull(3, 0);
        ps.setString(4, "");
        ps.execute();
        ps.setString(1, "1998-08-12");
        ps.setString(2, "07:11");
        ps.setNull(3, 0);
        ps.setNull(4, 0);
        ps.execute();
	ps.clearParameters();
        ps.close();
        }
    catch(Exception e) { e.printStackTrace(); }

//-----------------------------------------------------------------
//-----------------------------------------------------------------

    header("Executing Query of hotdates");
  
    try {
        String x; byte[] y;
        Statement st = cx.createStatement();
        ResultSet rs = st.executeQuery("select descx from hotdates");
        while(rs.next())
            {
            x = rs.getString("descx");
            System.out.println("desc String " + x);
            y = rs.getBytes(1);
            if(y!=null)
                 System.out.println("desc bytes  " + y.toString() + "\n");
            else System.out.println("desc bytes is null");
            }
        rs.close();
        st.close();
        }           
    catch(Exception e) { e.printStackTrace(); }
    System.out.println("\n\n");

    try {
        Statement st = cx.createStatement();
        st.setMaxRows(0);
        ResultSet rs = st.executeQuery("select * from hotdates");
        while(rs.next())
            {
            Long ii;
            String x;
            ii = (Long) rs.getObject("oid");
            System.out.println("Object number " + ii.toString());
            x =  rs.getString("xdate"); 
            System.out.println("xdate : " + x);
            x =  rs.getString("xtime"); 
            System.out.println("xtime : " + x);
            x = rs.getString("ts"); 
            System.out.println("ts : " + x);
            Date da = (Date) rs.getObject("xdate");
            Time ti = (Time) rs.getObject("xtime");
            Timestamp ts = (Timestamp) rs.getObject("ts");
            String o = (String) rs.getObject("descx");
            System.out.println(da.toString()  + " | " 
                               + ti.toString() + " | " 
                               + ts.toString() + " | " 
                               + o);
            }
        
        header("Some oddball RSMD stuff");
        ResultSetMetaData md = rs.getMetaData();
        System.out.println("\n\ngetPrecision() of descx");
        try { System.out.println("     getPrecision(5) = "
                                + md.getPrecision(5));
            }
        catch(Exception e) { e.printStackTrace(); }
        System.out.println("\n\ngetScale() of descx");
        try { System.out.println("     getScale(5) = "
                                + md.getScale(5));
            }           
        catch(Exception e) { e.printStackTrace(); }

        rs.close();
        st.close();
        }
    catch(Exception e) { e.printStackTrace(); }

    try {
        Statement st = cx.createStatement();
        xrc = st.executeUpdate( "drop table hotdates");
        st.close();
        System.out.println("Returns " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }
//-----------------------------------------------------------------

    header("trying comments");

    try {
        Statement st = cx.createStatement();
        System.out.println("# this is a comment");
        brc = st.execute( "# this is a comment");
        xrc = st.getUpdateCount();
        st.close();
        System.out.println("Returns " + brc + " " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

    try {
        Statement st = cx.createStatement();
        System.out.println("/* so is this */ (its gonna crash!)");
        brc = st.execute( "/* So is this */");
        xrc = st.getUpdateCount();
        st.close();
        System.out.println("Returns " + brc + " " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

//------------------------------------------------------------ 
//------------------------------------------------------------

    header("Creating table for cereal");

    try {
        Statement st = cx.createStatement();
        xrc = st.executeUpdate( "create table cereal("
                              + "xname text, xobject blob)");
        st.close();
        System.out.println("Returns " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

//------------------------------------------------------------

    header("Loading object table via inserts");

    Vector iv1 = new Vector();
    Vector iv2 = new Vector();
    Vector ov1, ov2;

    iv1.addElement(new Integer(0));
    iv2.addElement(new Integer(2));
    iv2.addElement(new Integer(3));
    iv2.addElement(new Integer(5));
    iv2.addElement(new Integer(7));
    iv2.addElement(new Integer(11));
    iv1.addElement(iv2);
    iv1.addElement(new String("Primes above"));

    try {
        String ss = "insert into cereal values(?, ?)";
        PreparedStatement ps = cx.prepareStatement(ss);
        ps.setString(1, "odd Object");
        ps.setObject(2, iv1, Types.OTHER);
        ps.execute();
        ps.close();
        Statement st = cx.createStatement();
        st.execute("select xobject from cereal");
        ResultSet  rs = st.getResultSet();
        rs.next();
        ObjectInputStream ois = 
               new ObjectInputStream(rs.getBinaryStream("xobject"));
        ov1 = (Vector) ois.readObject();
        rs.close();
        st.close();
        Integer I;
        String  S;
        I = (Integer) ov1.elementAt(0);
        System.out.println("Item 1.0 " + I.intValue() );
        ov2 = (Vector) ov1.elementAt(1);
        for(int i = 0; i < ov2.size(); i++)
            {
            I = (Integer) ov2.elementAt(i);
            System.out.println("    Item 2." + i + "  " + I.intValue());
            }
        S = (String) ov1.elementAt(2);
        System.out.println("Item 1.2 " + S);
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DatabaseMetaData");
    DatabaseMetaData dbmd = null;
    ResultSet rs = null;
    int rows = 0;

    try {
        dbmd = cx.getMetaData();

        System.out.println(" dbmd allProceduresAreCallable() "
                 + dbmd.allProceduresAreCallable());
        System.out.println(" dbmd allTablesAreSelectable() "
                 + dbmd.allTablesAreSelectable());
        System.out.println(" dbmd getURL() "
                 + dbmd.getURL());
        System.out.println(" dbmd getUserName() "
                 + dbmd.getUserName());
        System.out.println(" dbmd isReadOnly() "
                 + dbmd.isReadOnly());
        System.out.println(" dbmd nullsAreSortedHigh() "
                 + dbmd.nullsAreSortedHigh());
        System.out.println(" dbmd nullsAreSortedLow() "
                 + dbmd.nullsAreSortedLow());
        System.out.println(" dbmd nullsAreSortedAtStart() "
                 + dbmd.nullsAreSortedAtStart());
        System.out.println(" dbmd nullsAreSortedAtEnd() "
                 + dbmd.nullsAreSortedAtEnd());
        System.out.println(" dbmd getDatabaseProductName() "
                 + dbmd.getDatabaseProductName());
        System.out.println(" dbmd getDatabaseProductVersion() "
                 + dbmd.getDatabaseProductVersion());
        System.out.println(" dbmd getDriverName() "
                 + dbmd.getDriverName());
        System.out.println(" dbmd getDriverVersion() "
                 + dbmd.getDriverVersion());
        System.out.println(" dbmd getDriverMajorVersion() "
                 + dbmd.getDriverMajorVersion());
        System.out.println(" dbmd getDriverMinorVersion() "
                 + dbmd.getDriverMinorVersion());
        System.out.println(" dbmd usesLocalFiles() "
                 + dbmd.usesLocalFiles());
        System.out.println(" dbmd usesLocalFilePerTable() "
                 + dbmd.usesLocalFilePerTable());
        System.out.println(" dbmd supportsMixedCaseIdentifiers() "
                 + dbmd.supportsMixedCaseIdentifiers());
        System.out.println(" dbmd storesUpperCaseIdentifiers() "
                 + dbmd.storesUpperCaseIdentifiers());
        System.out.println(" dbmd storesLowerCaseIdentifiers() "
                 + dbmd.storesLowerCaseIdentifiers());
        System.out.println(" dbmd storesMixedCaseIdentifiers() "
                 + dbmd.storesMixedCaseIdentifiers());
        System.out.println(" dbmd supportsMixedCaseQuotedIdentifiers() "
                 + dbmd.supportsMixedCaseQuotedIdentifiers());
        System.out.println(" dbmd storesUpperCaseQuotedIdentifiers() "
                 + dbmd.storesUpperCaseQuotedIdentifiers());
        System.out.println(" dbmd storesLowerCaseQuotedIdentifiers() "
                 + dbmd.storesLowerCaseQuotedIdentifiers());
        System.out.println(" dbmd storesMixedCaseQuotedIdentifiers() "
                 + dbmd.storesMixedCaseQuotedIdentifiers());
        System.out.println(" dbmd getIdentifierQuoteString() "
                 + dbmd.getIdentifierQuoteString());
        System.out.println(" dbmd getSQLKeywords() "
                 + dbmd.getSQLKeywords());
        System.out.println(" dbmd getNumericFunctions() "
                 + dbmd.getNumericFunctions());
        System.out.println(" dbmd getStringFunctions() "
                 + dbmd.getStringFunctions());
        System.out.println(" dbmd getSystemFunctions() "
                 + dbmd.getSystemFunctions());
        System.out.println(" dbmd getTimeDateFunctions() "
                 + dbmd.getTimeDateFunctions());
        System.out.println(" dbmd getSearchStringEscape() "
                 + dbmd.getSearchStringEscape());
        System.out.println(" dbmd getExtraNameCharacters() "
                 + dbmd.getExtraNameCharacters());
        System.out.println(" dbmd supportsAlterTableWithAddColumn() "
                 + dbmd.supportsAlterTableWithAddColumn());
        System.out.println(" dbmd supportsAlterTableWithDropColumn() "
                 + dbmd.supportsAlterTableWithDropColumn());
        System.out.println(" dbmd supportsColumnAliasing() "
                 + dbmd.supportsColumnAliasing());
        System.out.println(" dbmd nullPlusNonNullIsNull() "
                 + dbmd.nullPlusNonNullIsNull());
        System.out.println(" dbmd supportsConvert() "
                 + dbmd.supportsConvert());
        System.out.println(" dbmd supportsConvert(int "
                 + dbmd.supportsConvert(0, 0));
        System.out.println(" dbmd supportsTableCorrelationNames() "
                 + dbmd.supportsTableCorrelationNames());
        System.out.println(" dbmd supportsDifferentTableCorrelationNames() "
                 + dbmd.supportsDifferentTableCorrelationNames());
        System.out.println(" dbmd supportsExpressionsInOrderBy() "
                 + dbmd.supportsExpressionsInOrderBy());
        System.out.println(" dbmd supportsOrderByUnrelated() "
                 + dbmd.supportsOrderByUnrelated());
        System.out.println(" dbmd supportsGroupBy() "
                 + dbmd.supportsGroupBy());
        System.out.println(" dbmd supportsGroupByUnrelated() "
                 + dbmd.supportsGroupByUnrelated());
        System.out.println(" dbmd supportsGroupByBeyondSelect() "
                 + dbmd.supportsGroupByBeyondSelect());
        System.out.println(" dbmd supportsLikeEscapeClause() "
                 + dbmd.supportsLikeEscapeClause());
        System.out.println(" dbmd supportsMultipleResultSets() "
                 + dbmd.supportsMultipleResultSets());
        System.out.println(" dbmd supportsMultipleTransactions() "
                 + dbmd.supportsMultipleTransactions());
        System.out.println(" dbmd supportsNonNullableColumns() "
                 + dbmd.supportsNonNullableColumns());
        System.out.println(" dbmd supportsMinimumSQLGrammar() "
                 + dbmd.supportsMinimumSQLGrammar());
        System.out.println(" dbmd supportsCoreSQLGrammar() "
                 + dbmd.supportsCoreSQLGrammar());
        System.out.println(" dbmd supportsExtendedSQLGrammar() "
                 + dbmd.supportsExtendedSQLGrammar());
        System.out.println(" dbmd supportsANSI92EntryLevelSQL() "
                 + dbmd.supportsANSI92EntryLevelSQL());
        System.out.println(" dbmd supportsANSI92IntermediateSQL() "
                 + dbmd.supportsANSI92IntermediateSQL());
        System.out.println(" dbmd supportsANSI92FullSQL() "
                 + dbmd.supportsANSI92FullSQL());
        System.out.println(" dbmd supportsIntegrityEnhancementFacility() "
                 + dbmd.supportsIntegrityEnhancementFacility());
        System.out.println(" dbmd supportsOuterJoins() "
                 + dbmd.supportsOuterJoins());
        System.out.println(" dbmd supportsFullOuterJoins() "
                 + dbmd.supportsFullOuterJoins());
        System.out.println(" dbmd supportsLimitedOuterJoins() "
                 + dbmd.supportsLimitedOuterJoins());
        System.out.println(" dbmd getSchemaTerm() "
                 + dbmd.getSchemaTerm());
        System.out.println(" dbmd getProcedureTerm() "
                 + dbmd.getProcedureTerm());
        System.out.println(" dbmd getCatalogTerm() "
                 + dbmd.getCatalogTerm());
        System.out.println(" dbmd isCatalogAtStart() "
                 + dbmd.isCatalogAtStart());
        System.out.println(" dbmd getCatalogSeparator() "
                 + dbmd.getCatalogSeparator());
        System.out.println(" dbmd supportsSchemasInDataManipulation() "
                 + dbmd.supportsSchemasInDataManipulation());
        System.out.println(" dbmd supportsSchemasInProcedureCalls() "
                 + dbmd.supportsSchemasInProcedureCalls());
        System.out.println(" dbmd supportsSchemasInTableDefinitions() "
                 + dbmd.supportsSchemasInTableDefinitions());
        System.out.println(" dbmd supportsSchemasInIndexDefinitions() "
                 + dbmd.supportsSchemasInIndexDefinitions());
        System.out.println(" dbmd supportsSchemasInPrivilegeDefinitions() "
                 + dbmd.supportsSchemasInPrivilegeDefinitions());
        System.out.println(" dbmd supportsCatalogsInDataManipulation() "
                 + dbmd.supportsCatalogsInDataManipulation());
        System.out.println(" dbmd supportsCatalogsInProcedureCalls() "
                 + dbmd.supportsCatalogsInProcedureCalls());
        System.out.println(" dbmd supportsCatalogsInTableDefinitions() "
                 + dbmd.supportsCatalogsInTableDefinitions());
        System.out.println(" dbmd supportsCatalogsInIndexDefinitions() "
                 + dbmd.supportsCatalogsInIndexDefinitions());
        System.out.println(" dbmd supportsCatalogsInPrivilegeDefinitions() "
                 + dbmd.supportsCatalogsInPrivilegeDefinitions());
        System.out.println(" dbmd supportsPositionedDelete() "
                 + dbmd.supportsPositionedDelete());
        System.out.println(" dbmd supportsPositionedUpdate() "
                 + dbmd.supportsPositionedUpdate());
        System.out.println(" dbmd supportsSelectForUpdate() "
                 + dbmd.supportsSelectForUpdate());
        System.out.println(" dbmd supportsStoredProcedures() "
                 + dbmd.supportsStoredProcedures());
        System.out.println(" dbmd supportsSubqueriesInComparisons() "
                 + dbmd.supportsSubqueriesInComparisons());
        System.out.println(" dbmd supportsSubqueriesInExists() "
                 + dbmd.supportsSubqueriesInExists());
        System.out.println(" dbmd supportsSubqueriesInIns() "
                 + dbmd.supportsSubqueriesInIns());
        System.out.println(" dbmd supportsSubqueriesInQuantifieds() "
                 + dbmd.supportsSubqueriesInQuantifieds());
        System.out.println(" dbmd supportsCorrelatedSubqueries() "
                 + dbmd.supportsCorrelatedSubqueries());
        System.out.println(" dbmd supportsUnion() "
                 + dbmd.supportsUnion());
        System.out.println(" dbmd supportsUnionAll() "
                 + dbmd.supportsUnionAll());
        System.out.println(" dbmd supportsOpenCursorsAcrossCommit() "
                 + dbmd.supportsOpenCursorsAcrossCommit());
        System.out.println(" dbmd supportsOpenCursorsAcrossRollback() "
                 + dbmd.supportsOpenCursorsAcrossRollback());
        System.out.println(" dbmd supportsOpenStatementsAcrossCommit() "
                 + dbmd.supportsOpenStatementsAcrossCommit());
        System.out.println(" dbmd supportsOpenStatementsAcrossRollback() "
                 + dbmd.supportsOpenStatementsAcrossRollback());
        System.out.println(" dbmd getMaxBinaryLiteralLength() "
                 + dbmd.getMaxBinaryLiteralLength());
        System.out.println(" dbmd getMaxCharLiteralLength() "
                 + dbmd.getMaxCharLiteralLength());
        System.out.println(" dbmd getMaxColumnNameLength() "
                 + dbmd.getMaxColumnNameLength());
        System.out.println(" dbmd getMaxColumnsInGroupBy() "
                 + dbmd.getMaxColumnsInGroupBy());
        System.out.println(" dbmd getMaxColumnsInIndex() "
                 + dbmd.getMaxColumnsInIndex());
        System.out.println(" dbmd getMaxColumnsInOrderBy() "
                 + dbmd.getMaxColumnsInOrderBy());
        System.out.println(" dbmd getMaxColumnsInSelect() "
                 + dbmd.getMaxColumnsInSelect());
        System.out.println(" dbmd getMaxColumnsInTable() "
                 + dbmd.getMaxColumnsInTable());
        System.out.println(" dbmd getMaxConnections() "
                 + dbmd.getMaxConnections());
        System.out.println(" dbmd getMaxCursorNameLength() "
                 + dbmd.getMaxCursorNameLength());
        System.out.println(" dbmd getMaxIndexLength() "
                 + dbmd.getMaxIndexLength());
        System.out.println(" dbmd getMaxSchemaNameLength() "
                 + dbmd.getMaxSchemaNameLength());
        System.out.println(" dbmd getMaxProcedureNameLength() "
                 + dbmd.getMaxProcedureNameLength());
        System.out.println(" dbmd getMaxCatalogNameLength() "
                 + dbmd.getMaxCatalogNameLength());
        System.out.println(" dbmd getMaxRowSize() "
                 + dbmd.getMaxRowSize());
        System.out.println(" dbmd doesMaxRowSizeIncludeBlobs() "
                 + dbmd.doesMaxRowSizeIncludeBlobs());
        System.out.println(" dbmd getMaxStatementLength() "
                 + dbmd.getMaxStatementLength());
        System.out.println(" dbmd getMaxStatements() "
                 + dbmd.getMaxStatements());
        System.out.println(" dbmd getMaxTableNameLength() "
                 + dbmd.getMaxTableNameLength());
        System.out.println(" dbmd getMaxTablesInSelect() "
                 + dbmd.getMaxTablesInSelect());
        System.out.println(" dbmd getMaxUserNameLength() "
                 + dbmd.getMaxUserNameLength());
        System.out.println(" dbmd getDefaultTransactionIsolation() "
                 + dbmd.getDefaultTransactionIsolation());
        System.out.println(" dbmd supportsTransactions() "
                 + dbmd.supportsTransactions());
        System.out.println(" dbmd supportsTransactionIsolationLevel(int "
                 + dbmd.supportsTransactionIsolationLevel(0));
        System.out.println(" dbmd supportsDataDefinitionAndDataManipulationTransactions() "
                 + dbmd.supportsDataDefinitionAndDataManipulationTransactions());
        System.out.println(" dbmd supportsDataManipulationTransactionsOnly() "
                 + dbmd.supportsDataManipulationTransactionsOnly());
        System.out.println(" dbmd dataDefinitionCausesTransactionCommit() "
                 + dbmd.dataDefinitionCausesTransactionCommit());
        System.out.println(" dbmd dataDefinitionIgnoredInTransactions() "
                 + dbmd.dataDefinitionIgnoredInTransactions());
      

 
        header("Showing catalogs");

        rs = dbmd.getCatalogs();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(1));
            }
        System.out.println(rows +  " rows.");
        }
    catch(Exception e) { e.printStackTrace(); }

    header("Showing tables in non existing catalog");
    try {
        rs = dbmd.getTables("crap", null, null, null);
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(1));
            }
        System.out.println(rows +  " rows.");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getProcedures ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getProcedures("mysql", null, null);
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getProcedureColumns");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getProcedureColumns("mysql", null, null, null);
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getTables : Showing tables in mysql ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getTables("mysql", null, null, null);
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getSchemas ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getSchemas();
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getCatalogs");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getCatalogs();
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(1));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getTableTypes");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getTableTypes();
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(1));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getColumns ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getColumns("mysql", null, "user", null);
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3) + " " +rs.getString(4));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getColumnPrivileges ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getColumnPrivileges("mysql", null, "user", "%");
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getTablePrivileges : Showing tables in mysql ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getTablePrivileges("mysql", null, "user");
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getBestRowIdentifier ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getBestRowIdentifier("mysql", null, "user", 0, true);
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getVersionColumns ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getVersionColumns("mysql", null, null);
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getPrimaryKeys ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getPrimaryKeys("mysql", null, "user");
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getImportedKeys");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getImportedKeys("mysql", null, "user");
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getExportedKeys ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getExportedKeys("mysql", null, "user");
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getCrossReference ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getCrossReference("mysql", null, "user",null, null, null);
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }

    header("DBMD getTypeInfo");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getTypeInfo();
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("DBMD getIndexInfo ");
    ws3 = "                        ";
    try {
        int i;
        rs = dbmd.getIndexInfo("mysql", null, "user", false, false);
        rsmd = rs.getMetaData();
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(3));
            }
        System.out.println(rows +  " rows.\n");
        for(i = 0; i < rsmd.getColumnCount(); i++)
	    {
            ws1 = rsmd.getColumnName(i+1) + ws3;
            ws2 = rsmd.getColumnTypeName(i+1);
            System.out.println(ws1.substring(0, 20) + ws2);
            }
        System.out.println("-------------------------------------------");
        }
    catch(Exception e) { e.printStackTrace(); }



    header("Re creating books table");   
    try {
        Statement st = cx.createStatement();
        st.executeUpdate( "create table books (rownum int not null"
                              +   " auto_increment, bname text not null,"
                              +   " author text not null, pubdate int,"
                              +   " isbn char(20) not null, price decimal(6,2),"
                              +   " primary key(isbn), index(rownum))" ); 

        }
    catch(Exception e) { e.printStackTrace(); }


    header("Showing columns in books table");   
    try {
        rs = dbmd.getColumns("jdbctest", null, "books", null);
        rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println("\n  column " + rs.getString(17) 
                   + "   name " + rs.getString(4) + "   type " 
                   + rs.getString(6) + "   java type " + rs.getString(5));
            System.out.println("    size " + rs.getString(7) 
                   + "   decimal digits " + rs.getString(9)
                   + "   nullable: " + rs.getString(18));
            System.out.println("  remarks: " + rs.getString(12));      
            }
        System.out.println(rows +  " rows.");

        }
    catch(Exception e) { e.printStackTrace(); }


    header("Showing columns with \"a\"in all tables ending in \"s\"");   
    try {
        rs = dbmd.getColumns(null, null,  "%s",  "%a%");
        rows = 0;
        String pad = "                ";
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(1).concat(pad).substring(0,12)
                   + "  " + rs.getString(3).concat(pad).substring(0,12) 
                   + "  " + rs.getString(17).concat(pad).substring(0,4)
                   + "  " + rs.getString(4).concat(pad).substring(0,12)
                   + "   type " + rs.getString(6) );
            }
        System.out.println(rows +  " rows.");
        }
    catch(Exception e) { e.printStackTrace(); }




    header("Showing columns in mysql");   
    try {
        rs = dbmd.getColumns("mysql", null,  null, null );
        rows = 0;
        String pad = "                ";
        while(rs.next())
            {
            rows++;
            System.out.println(rs.getString(1).concat(pad).substring(0, 12)
                   + "  " + rs.getString(3).concat(pad).substring(0, 12) 
                   + "  " + rs.getString(17).concat(pad).substring(0,4)
                   + "  " + rs.getString(4).concat(pad).substring(0,12)
                   + "   type " + rs.getString(6) );
            }
        System.out.println(rows +  " rows.");
        }
    catch(Exception e) { e.printStackTrace(); }


    header("Dropping cereal and books");
    try {
        Statement st = cx.createStatement();
        xrc = st.executeUpdate( "drop table cereal");
        xrc = st.executeUpdate( "drop table books");
        st.close();
        System.out.println("drop cereal Returns " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }

 
//---------------------------------------------------------------

//---------------------------------------------------------------

    header("closing connection");

    try { cx.close(); }
    catch(SQLException se){System.out.println(se);}
      
    }

//---------------------------------------------------------------
//---------------------------------------------------------------

void header(String h)
    {
    String bl = "-----------------------------------";
    String sl = "                                   ";
    bl = new String("+" + bl + bl + "+");
    System.out.println("\n");
    System.out.println(bl);
    String rl = h;
    String tl;
    int i, j, k;
    while(rl != null)
        {
        if(rl.length() > 60)
            {
            tl = rl.substring(0, 60);
            rl = rl.substring(60);
            }
        else { tl = rl; rl = null; }
        k = ( 71 - tl.length() ) / 2;
        tl = new String(sl.substring(0, k) + tl + sl.substring(0, k));
        while(tl.length() > 70) tl = tl.substring(1);
        tl = new String("|" + tl + "|");
        System.out.println(tl);
        }
    System.out.println(bl);
    System.out.println("");
    }

}

