#ifndef _UDM_UTILS_H
#define _UDM_UTILS_H

/* for time_t */
#include <time.h>

/* for va_list */
#include <stdarg.h>

/* Some constants */
#define UDMSTRSIZ	1024*5

/* This is used in UdmTime_t2Str and in its callers */
#define UDM_MAXTIMESTRLEN	35


/* Some useful MACROs */
#define UDM_STRNCMP(x,y)	(strncmp(x,y,strlen(y)))
#define UDM_STRNCASECMP(x,y)	(strncasecmp(x,y,strlen(y)))
#define UDM_STREND(s)		(s+strlen(s))
#define UDM_FREE(x)		{if(x){free(x);x=NULL;}}
#define UDM_STRNCPY(x,y)	{strncpy(x,y,sizeof(x));x[sizeof(x)-1]=0;}
#define UDM_SKIP(s,set)		while((*s)&&(strchr(set,*s)))s++;
#define UDM_SKIPN(s,set)	while((*s)&&(!strchr(set,*s)))s++;


/* Misc functions */
extern char * UdmGetToken(char *s, const char *delim, char **last);
extern char * UdmTrim(char * p, char * delim);
extern char * UdmRTrim(char* p, char * delim);
extern char * UdmHtmlSpecialChars(char *str);
extern char * UdmUnescapeCGIQuery(char *d,char *s);
extern char * UdmEscapeURL(char *d,char *s);
extern char * UdmRemove2Dot(char *path);

/* This should convert Last-Modified time returned by webserver
 * to time_t (seconds since the Epoch). -kir
 */
extern time_t UdmHttpDate2Time_t(const char * date);

extern time_t UdmFTPDate2Time_t(char *date);

/* This one for printing HTTP Last-Modified: header */
extern void UdmTime_t2HttpStr(time_t t, char * time_str);
/* This one deals with timezone offset */
extern int UdmInitTZ(void);

/* String functions */
int udm_strnlen(const char *s, int max);
/* returns length of string needed for vsnprintf */
int udm_vsnprintf_len(const char *fmt, va_list args);
int udm_vsnprintf(char *str, size_t size, const char  *fmt,  va_list ap);
int udm_snprintf(char *str, int size, const char *fmt, ...);
#endif /* _UDM_UTILS_H */
