#include "udm_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "udm_common.h"
#include "udm_log.h"
#include "udm_utils.h"

#ifdef HAVE_SYSLOG_H
#ifndef LOG_FACILITY
#define LOG_FACILITY LOG_LOCAL7
#endif /* LOG_FACILITY */
#else
#define LOG_FACILITY 0
#endif

void (*RefInfo)(int code,char *url, char *ref);
__INDLIB__ int UdmSetRefProc(void (*_RefProc)(int code,char *url, char *ref)){
	RefInfo=_RefProc;
	return(0);
}

void (*ThreadInfo)(int handle,char *state, char* str) = NULL;
__INDLIB__ int UdmSetThreadProc(void (*_ThreadInfo)(int handle,char *state, char* str)){
	ThreadInfo=_ThreadInfo;
	return(0);
}

void (*StatInfo)(int handle, int code, int expired, int total, char* str);
__INDLIB__ int UdmSetStatProc(void (*_StatInfo)(int handle,int code, int expired, int total, char* str)){
	StatInfo=_StatInfo;
	return(0);
}


static int LogFacility=LOG_FACILITY;
static int LogLevel=UDM_LOG_INFO;
static int is_log_open=0;
static FILE *error=NULL;

typedef struct _code {
        char    *c_name;
        int     c_val;
} CODE;

#ifdef HAVE_SYSLOG_H
static const CODE facilitynames[] ={
#ifdef LOG_AUTH
    {"auth",	LOG_AUTH},
#endif
#ifdef LOG_AUTHPRIV
    {"authpriv",LOG_AUTHPRIV},
#endif
#ifdef LOG_CRON
    {"cron", 	LOG_CRON},
#endif
#ifdef LOG_DAEMON
    {"daemon",	LOG_DAEMON},
#endif
#ifdef LOG_FTP
    {"ftp",	LOG_FTP},
#endif
#ifdef LOG_KERN
    {"kern",	LOG_KERN},
#endif
#ifdef LOG_LPR
    {"lpr",	LOG_LPR},
#endif
#ifdef LOG_MAIL
    {"mail",	LOG_MAIL},
#endif
#ifdef LOG_NEWS
    {"news",	LOG_NEWS},
#endif
#ifdef LOG_SYSLOG
    {"syslog",	LOG_SYSLOG},
#endif
#ifdef LOG_USER
    {"user",	LOG_USER},
#endif
#ifdef LOG_UUCP
    {"uucp",	LOG_UUCP},
#endif
#ifdef LOG_LOCAL0
    {"local0",	LOG_LOCAL0},
#endif
#ifdef LOG_LOCAL1
    {"local1",	LOG_LOCAL1},
#endif
#ifdef LOG_LOCAL2
    {"local2",	LOG_LOCAL2},
#endif
#ifdef LOG_LOCAL3
    {"local3",	LOG_LOCAL3},
#endif
#ifdef LOG_LOCAL4
    {"local4",	LOG_LOCAL4},
#endif
#ifdef LOG_LOCAL5
    {"local5",	LOG_LOCAL5},
#endif
#ifdef LOG_LOCAL6
    {"local6",	LOG_LOCAL6},
#endif
#ifdef LOG_LOCAL7
    {"local7",	LOG_LOCAL7},
#endif
    {NULL,		-1},
};
static int syslog_facility(char *f){
	const CODE *fn;
	fn=facilitynames;
	while (fn->c_name!=NULL){
		if (strcasecmp(f, fn->c_name)==0)
			return fn->c_val;
		fn++;
	}
	fprintf(stderr, "Config file error: unknown facility given: %s\n\r", f);
	fprintf(stderr, "Will continue with default facility\n\r");
	return LOG_FACILITY;
}

#endif /* HAVE_SYSLOG_H */


__INDLIB__ void UdmSetLogLevel(int level){
	LogLevel=level;
}

__INDLIB__ void UdmSetLogFacility(char * facility){
	if(!strcmp(facility,"")){
		LogFacility=LOG_FACILITY;
		return;
	}
#ifdef HAVE_SYSLOG_H
	LogFacility=syslog_facility(facility);
#endif
}



int UdmOpenLog(int log2stderr){
#if defined HAVE_SYSLOG_H && defined USE_SYSLOG
/* LOG_PERROR supported by 4.3BSD Reno releases and later */
#ifdef LOG_PERROR
    openlog("Indexer",(log2stderr)?LOG_PERROR|LOG_PID:LOG_PID,LogFacility);
#else
    openlog("Indexer",LOG_PID,LogFacility);
    if(log2stderr) error=stderr;
#endif /* LOG_PERROR */
#else
    /* If syslog not found or not used, use stderr. */
    if(log2stderr) error=stderr;
#endif /* HAVE_SYSLOG_H */
    is_log_open=1;return(0);
}



static int udm_logger(int handle,int level, const char *fmt, va_list ap){
char buf[UDM_LOG_BUF_LEN+1];

	if(LogLevel<level) return 0;

#if (WIN32|WINNT)
	_vsnprintf(buf,UDM_LOG_BUF_LEN,fmt,ap);
#ifdef _CONSOLE
	printf("%s\n",buf);
#else
	if(ThreadInfo)ThreadInfo(0,"",buf);
#endif
#else
	udm_vsnprintf(buf,UDM_LOG_BUF_LEN,fmt,ap);
#endif

#if defined HAVE_SYSLOG_H && defined USE_SYSLOG
	if(handle)
		syslog((level!=UDM_LOG_ERROR)?LOG_INFO:LOG_ERR,"[%d] %s",handle,buf);
	else
		syslog((level!=UDM_LOG_ERROR)?LOG_INFO:LOG_ERR,"%s",buf);
#endif
	if(error!=NULL) fprintf(error,"%s\n",buf); 
	return 1;
}



void UdmLog(int handle,int level, const char *fmt, ...){
	va_list ap;
#if (WIN32|WINNT)
#else
	if(is_log_open){
#endif
		va_start(ap,fmt);
		udm_logger(handle,level,fmt,ap);
		va_end(ap);
#if (WIN32|WINNT)
#else
	}else
		fprintf(stderr,"Log has not been opened\n");
#endif
	return;
}
