#include "die.h"
#include  <stdarg.h>
#include  <stdio.h>
#include <string.h>
#include  <errno.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>

int kill_sem_id = -1;
const char* progname = "super-smack";

void die(int do_errno, char* fmt, ...)
{
  va_list ap;
  va_start(ap, fmt);
  fprintf(stderr, "%s: ", progname);
  vfprintf(stderr, fmt, ap);
  if(do_errno)
    fprintf(stderr, " errno = %d, error is %s", errno, strerror(errno));

  fprintf(stderr, "\n");
  if(kill_sem_id != -1)
    semctl(kill_sem_id, 0, IPC_RMID, 0);
  exit(1);
}

