#include "smack.h"
#include <config.h>
#include "die.h"
#include <string>

const char* datadir = SMACK_DATADIR;

char* mk_data_path(char* buf, const char* file)
{
  if(datadir && *file != '/')
    {
      int datadir_len = strlen(datadir);
      if(datadir_len > MAX_PATH - 3)
	{
	  die(0, "datadir is too long ");
	}
      memcpy(buf, datadir, datadir_len);
      char* p = buf + datadir_len - 1;
      if(*p != '/')
	*++p = '/';
      strncpy(p + 1, file, MAX_PATH - datadir_len - 1);
      file = buf;
    }
  
  return (char*)file;
}

int populate_data_file(const char* file, const char* cmd)
{
  string shell_cmd = cmd;
  cout << "Populating data file '" << file << "' with shell command '" <<
    cmd << "'" <<    endl;
  shell_cmd += " > ";
  shell_cmd += file;
  return system(shell_cmd.c_str());
}

