#ifndef VAL_H
#define VAL_H
#include <stdio.h>


struct Val
{
  string strval;
  double dval;
  bool delete_me_not;
  Val() : strval(""), dval(0.0),delete_me_not(0) {}
  Val(string& s) { set(s);}
  Val(const char* s) { set(s);}
  Val(double d) { set(d);}
  Val(int n) { set(n);}

  void set(string& s) { strval = s; dval=atof(s.c_str());}
  void set(const char* s) { strval = s; dval=atof(s);}
  void set(double d)
  {
    dval = d;
    char buf[32];
    snprintf(buf, sizeof(buf), "%f", d );
    strval = buf;
  }
  void set(int n) { set((double)n);}
  void set(Val& other)
  {
    if(this != &other)
      {
	strval = other.strval;
	dval = other.dval;
      }
  }
  void concat(Val& other)
  {
    string tmp = strval + other.strval; 
    set(tmp);
  }
};

extern map<string, Val*, less<string> > var_hash;

#endif
