#!/usr/local/bin/perl
#
# cafdmySql 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdmySql;
 
use strict;
use connectors::refDBI;

@cafdmySql::ISA = ("refDBI");

use DBI;

sub NewConnection {
	my $class = shift;
	$class = ref($class) || $class;
	my $db = shift;

	my $dbh;

	my $dbdsn = $db->{dbidsn};

	unless ($dbdsn) {
		$dbdsn = "dbi:mysql:database=" . $db->{connector}{externalname};
		if ($db->{server}) {
			$dbdsn .= ";host=" . $db->{server}{host_name} if ($db->{server}{host_name});
			$dbdsn .= ";host=" . $db->{server}{host_address} unless ($db->{server}{host_name});
		}
		$dbdsn .= ";port=" . $db->{connector}{port} if ($db->{connector}{port});
	}

#	print "cafdmySql $dbdsn using $db->{user}{username}, $db->{user}{password} \n";
	my %drvAttrs = ( AutoCommit => $db->{_ATTRS}{AutoCommit}, RaiseError => $db->{_ATTRS}{RaiseError}, PrintError => $db->{_ATTRS}{PrintError} );
	eval {
		$dbh = DBI->connect($dbdsn, $db->{user}{username}, $db->{user}{password}, \%drvAttrs);
	};

	die "cafmySql->connect : $@" if ($@ || (! $dbh));

	$db->{dbidsn} = $dbdsn;
	my $self = { dbh => $dbh, db => $db, };

	bless $self, $class;
}

sub describe {
	my $self = shift;
	my $tablename = shift;
	my $owner = shift;
	my $type = shift;

	my $query = cafQry->new();
	$query->query("SHOW FIELDS FROM $tablename");

	my $rows = $self->hexecfetchall($query);

	$query = cafQry->new();
	$query->query("SHOW KEYS FROM $tablename");

	my $pkrows = $self->hexecfetchall($query);

	my $i = -1;
	my @ret;
#Field,Type,Null,Key,Default,Extra
	my $index = "";
	foreach my $row (@$rows) {
		my $type = $row->{Type};
		$type =~ s/\((.*)\)//;
		my $len = $1;
#		$len =~ s/,(.*)//;
		my $scale = undef;
		if ($len =~ /,.*/) { $len =~ s/,(.*)//; $scale = $1; } # = $row->{column_size};
		
		$len = 100 unless ($len =~ /\d+/);
		$scale = undef unless ($scale =~ /\d+/);
		$i++;
		my $ord = $i * 10;
		$ret[$i] = {
			externalname => $row->{Field},
			name         => $row->{Field},
			datatypeid   => uc $type,
			datalength   => $len, #$row->{column_size},
			datascale    => $scale, #$row->{decimal_digits},
			fieldorder   => $ord,
			nullable     => $row->{Null} eq "YES" ? "yes" : "no",
			defaultvalue => $row->{Default} ? $row->{Default} : undef,
			Remarks      => $row->{Extra},
		};
#Table,Non_unique,Key_name,Seq_in_index,Column_name,Collation,Cardinality,Sub_part,Packed,Comment,
		foreach my $pk (@$pkrows) {
			$index = $pk->{Key_name} if (! $index);
			last if ($pk->{Key_name} ne $index);
			if ($pk->{Column_name} eq $ret[$i]->{externalname}) {
				$ret[$i]->{keyposition} = $pk->{Seq_in_index}; last;
			}
		}
	}
	return \@ret;
}

sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}";
	return ":c_$col->{name}" unless ($col->{datatypeid}  =~ /TIME|DATE/);
	$col->{dataformat} = "%Y/%m/%d %H:%i:%S" if ($col->{datatypeid} =~ /SQL_TIMESTAMP/);
	$col->{dataformat} = "%Y/%m/%d" if ($col->{datatypeid} =~ /SQL_DATE/);
	$col->{dataformat} = "%H:%i:%S" if ($col->{datatypeid} eq "SQL_TIME");

	return ("to_date(:c_$col->{name}, '$col->{dataformat}')");
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{externalname} unless ($col->{datatypeid}  =~ /TIME|DATE/);
	$col->{dataformat} = "%Y/%m/%d %H:%i:%S" if ($col->{datatypeid} =~ /SQL_TIMESTAMP/);
	$col->{dataformat} = "%Y/%m/%d" if ($col->{datatypeid} =~ /SQL_DATE/);
	$col->{dataformat} = "%H:%i:%S" if ($col->{datatypeid} eq "SQL_TIME");

	return ("date_format($col->{externalname}, '$col->{dataformat}')");
}

sub __generateselect {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#select statement generated by $class\n\nSELECT ";
	my $sep = "";
	my $where = "";
	my $chunk;
	my $wsep = "WHERE ";
	my $qlen = 0;
	my $wlen = 0;

#	print "<BR> select from ", ref($self) || $self;
	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		$chunk = "$sep" . $self->generatedatetochar($col) . " AS \@$col->{name}";
		$query .= $chunk;
		$sep = ", ";

		$qlen += length($chunk);
		if ($qlen > 50) { $query .= "\n\t\t"; $qlen = 10; }

		if ($col->{keyposition}) {
			$chunk = "$wsep$col->{externalname} = " . $self->generatechartodate($col);
			$where .= $chunk;
			$wlen += length($chunk);
			if ($wlen > 50) { $where .= "\n\t\t"; $wlen = 10; }
			$wsep = " and ";
		}
	}

	return "$query\n\tfrom $container->{externalname}\n\t$where";
}
1;
