#!/usr/local/bin/perl
#
# FlowRt.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

package FlowRt;

@ISA=(SchedRt);
use strict;




{
#Instance variables
#Running subflows
#Running 
my $a;
}

sub CanIRun {
	my $self = shift;

	my $qDbh = $self->QueueDbhAutocommit();

	my $runId = $self->NextExecutionSeq($qDbh);

	my $query = $qDbh->newquery({ run_id => $runId, object_id => $self->MyId(), syspid => $self->MyPid() });
	$query->iwrunhisto();
	my $ret = $qDbh->executefinish($query);
	#return 1;

	$query = $qDbh->newquery({ object_id => $self->MyId(), FORUDPATE => 1 });
	$query->swflowsstatuslistrt();
	my $status = $qDbh->hexecfetchrownop($query, "finish");

	$status = { rt_status => "online" } unless ($status);

	unless ($status->{rt_status} eq "online") {
		$self->LogSysTrace("CANIRUN : " . $self->MyId() . " MY STATUS IS / $status->{rt_status}");
		return undef unless ($status->{rt_status} eq "online");
	}

	my $query = $qDbh->newquery({ object_id => -1 });
	$query->swflowsstatuslistrt();
	$status = $qDbh->hexecfetchrownop($query, "finish");

	$status = { rt_status => "online" } unless ($status);
	unless ($status->{rt_status} eq "online") {
		$self->LogSysTrace("CANIRUN : " . $self->MyId() . " MONITOR STATUS IS / $status->{rt_status}");

		return undef unless(($status->{rt_status} eq "online") || ($status->{rt_status} eq "running"));
	}

	my $qAttr = {
		object_id       => $self->MyId(),
		rt_status       => "running",
		system_pid      => $self->MyPid(),
		sched_id        => $self->MySchedulerId(),
	};
#	$query = $qDbh->newquery({ object_id=>$self->MyId(), rt_status=>"running", system_pid=>$self->MyPid(), sched_id=>$self->MySchedulerId() });
	$query = $qDbh->newquery($qAttr);
	$query->uwflowsstatus();
	my $ret = $qDbh->executefinish($query);

	if ($ret == 0) {
		$query = $qDbh->newquery({ object_id => $self->MyId(), rt_status => "running" });
		$query->iwflowsstatus();
		$ret = $qDbh->executefinish($query);
	}

	if ($ret < 0) { die "CANNOT UPDATE MY STATUS"; return undef; }

	return 1;
}

sub RaisedErrors {
	my $self = shift;

	if ($self->StoppedFlow() or $self->Halted()) { "yes"; }
	else { "no" }
}

sub IFinished {
	my $self = shift;

	my $qDbh = $self->QueueDbhAutocommit();

	my $status = "online";
	if ($self->StoppedFlow()) {
		$status = "stopped";
	}

	my $qAttr = {
		object_id       => $self->MyId(),
		rt_status       => $status,
		rt_status_cond  => "running",
		system_pid      => $self->MyPid(),
		sched_id        => $self->MySchedulerId(),
	};
	my $query = $qDbh->newquery($qAttr);
	$query->uwflowsstatus();
	my $ret;
	eval { $ret = $qDbh->executefinish($query); };
#	print STDERR "IFinished $ret - $@ 
#";

#	if ($ret == 0) {
#		$query = $qDbh->newquery({ object_id => $self->MyId(), rt_status => "running" });
#		$query->iwflowsstatus();
#		$ret = $qDbh->executefinish($query);
#	}

	if ($ret < 0) { die "CANNOT UPDATE MY STATUS"; return undef; }

	my $qAttr = {
		run_id     => $self->NextExecutionSeq($qDbh),
		object_id  => $self->MyId(),
		duration   => $self->RunDuration(),
		syspid     => $self->MyPid(),
		onerror    => $self->RaisedErrors(),
		incoms     => $SchedRt::classVars->{_Statistics}{incomMessageCount},
		transforms => $self->{_Statistics}{transformMessageCount},
		outgos     => $self->{_Statistics}{outgoMessageCount},
		rollbacks  => $self->{_Statistics}{rollbackMessageCount},
	};
	$query = $qDbh->newquery($qAttr);
	$query->uwrunhisto();
	$ret = $qDbh->executefinish($query);
	
}

sub IFinishedWS {
	my $self = shift;

	my $qDbh = $self->QueueDbhAutocommit();

	my $qAttr = {
		run_id     => $self->NextExecutionSeq($qDbh),
		object_id  => $self->MyId(),
		duration   => $self->RunDuration(),
		syspid     => $self->MyPid(),
		onerror    => $self->RaisedErrors(),
		incoms     => $SchedRt::classVars->{_Statistics}{incomMessageCount},
		transforms => $self->{_Statistics}{transformMessageCount},
		outgos     => $self->{_Statistics}{outgoMessageCount},
		rollbacks  => $self->{_Statistics}{rollbackMessageCount},
	};
	my $query = $qDbh->newquery($qAttr);
	$query->iwrunhisto();
	my $ret = $qDbh->executefinish($query);
	$ret;
	
}

sub UndefNextExecutionSeq {
	my $self = shift;

	$SchedRt::classVars->{_System}{runId} = undef;
}

sub NextExecutionSeq {
	my $self = shift;
	my $qDbh = shift;

	unless ($SchedRt::classVars->{_System}{runId}) {
		$SchedRt::classVars->{_System}{runId} = $qDbh->nextseq("wrunhisto");
		$SchedRt::classVars->{_System}{startedTime} = time();
	}
	$SchedRt::classVars->{_System}{runId};
}

sub RunDuration {
	my $self = shift;

	my $t = time();
#	sleep(2);
	time() - $SchedRt::classVars->{_System}{startedTime};
}

sub MyPid {
	$$;
}

sub LoadHierarchy {
	my $self = shift;

	require connectors::ObjHier;

	my $contextId = $self->MyContextId();
	my $context = $self->MyContext();
	unless ($context) {
		$context = $self->GetContext("force");
	}
	my $notUpToDate = $self->ObjectsNotUpToDate();

	if ($notUpToDate or (! ref($self->ObjectHierarchy()))) {
		my @Updatable = map { $_->{owned_id} } @$notUpToDate;
#		$self->LogSysTrace("LoadHierarchy : Updating New Objects : " . join (", ", @Updatable));
		my $context = $self->GetContext("force");
		my $dbh = $self->QueueDbhAutocommit();

		my @objectIds;
		foreach my $con (qw( connector_id ftpconnector_id mailconnector_id pop3connector_id archconnector_id)) {
			if ($context->{$con}) { push @objectIds, $context->{$con}; }
		}

		push @objectIds, $self->MyFlowId();

		my $objHier = ObjHier->new($dbh, "QUEUE", $contextId, $context);
		$objHier->gethierarchy(\@objectIds);

#        require Data::Dumper;
#        my $dump = Data::Dumper->new([$objHier], ["objHier"]);
#        my $ptext = $dump->Dump;

		$self->ObjectHierarchy($objHier);

		$self->TimeLastLoad($dbh->now('DD/MM/YYYY HH24:MI:SS'));

		$self->InitSystemVars();

		return "updated";
	}
	unless (ref($self->ObjectHierarchy())) { die "Unable to load Objects Hierarchy for flow " . $self->MyFlowId(); }

	return "uptodate";
}

sub GetHierarchy {
	my $self = shift;
	my $force = shift;

	if ($force || (!$self->LoadedHierarchy())) {
		$self->LoadHierarchy();
	}
	return 1;
}

sub Halted {
	my $self = shift;

	if (@_) { $SchedRt::classVars->{status}{Halted} = shift; }
	$SchedRt::classVars->{status}{Halted};
}

sub RetryLater {
	my $self = shift;

	if (@_) { $self->{status}{RetryLater} = shift; }
	$self->{status}{RetryLater};
}

sub StoppedFlow {
	my $self = shift;

	if (@_) { $self->{status}{Stopped} = shift; }
#	if ($self->{Stopped}) { cafDbg->printstack("StoppedFlow => ", 0); }
	return (($self->{status}{Stopped}) || ($self->Halted()));
}

sub SkipMessage {
	my $self = shift;

	if (@_) { $self->{status}{skipMessage} = shift; }
	$self->{status}{skipMessage};
}

sub UserDefinedAction {
	my $self = shift;
	my $type = shift;

	if (@_) { $self->{useraction}{$type} = shift; }
	$self->{useraction}{$type};
}

sub UserAlternateAction {
	my $self = shift;
	my $type = shift;

	if (@_) { $self->{useralternate}{$type} = shift; }
	$self->{useralternate}{$type};
}

sub ClearUserDefinedAction {
	my $self = shift;

	$self->{useralternate} = {};
	$self->{useraction} = {};
}
	
sub ClearMessageCount {
	my $self = shift;

	if ($self->MyId() == $self->MyFlowId()) { $SchedRt::classVars->{_Statistics}{incomMessageCount} = 0; }
	else {
		$self->{_Statistics}{transformMessageCount} = 0;
		$self->{_Statistics}{outgoMessageCount} = 0;
		$self->{_Statistics}{rollbackMessageCount} = 0;
	}
}

sub IncIncomsCount {
	my $self = shift;

	$SchedRt::classVars->{_Statistics}{incomMessageCount} += 1;
}

sub IncOutgosCount {
	my $self = shift;
	$self->{_Statistics}{outgoMessageCount} += 1;
	$SchedRt::classVars->{_Statistics}{outgoMessageCount} += 1;
}

sub IncTransformsCount {
	my $self = shift;
	$self->{_Statistics}{transformMessageCount} += 1;
	$SchedRt::classVars->{_Statistics}{transformMessageCount} += 1;
}

sub IncRollbacksCount {
	my $self = shift;
	$self->{_Statistics}{rollbackMessageCount} += 1;
	$SchedRt::classVars->{_Statistics}{rollbackMessageCount} += 1;
}

sub LoadVars {
	my $self = shift;

	my $qDbh = $self->QueueDbhAutocommit();

	my $objHier = $self->ObjectHierarchy();
	my $objvras = $objHier->varslist();
	foreach my $objid (keys %$objvras) {
		my $varlist = $objHier->varslist($objid);
		foreach my $var (@$varlist) {
			if ($var->{vartype} eq "env") { $ENV{$var->{varname}} = $var->{varvalue}; }
			elsif ($var->{vartype} eq "user") { $self->ObjectVar($objid, $var->{varname}, $var->{varvalue}); }
		}
	}


	my $query = $qDbh->newquery({ object_id => [ -1, $self->MyId(), @{$self->OutgoSubFlowIds()} , @{$self->IncomSubFlowIds()} ] });
	$query->swvarslist();
	my $vars = $qDbh->hexecfetchall($query);

	foreach my $var (@$vars) {
		if ($var->{specialvar} eq "yes") { $self->SpecialVar($var->{object_id}, $var->{varname}, $var->{varvalue}); }
		elsif ($var->{specialvar} eq "no") { $self->ObjectVar($var->{object_id}, $var->{varname}, $var->{varvalue}); }
	}
}

sub WaitingEvents {
	my $self = shift;

	my $events;
	my @theEvents;
	my $objid = $self->MyId();
	my $objHier = $self->ObjectHierarchy();
	return 1 unless ($events = $objHier->eventslist($objid));

	my $qDbh = $self->QueueDbhAutocommit();
	my $query;

	$query = $qDbh->newquery({ obejct_id => $objid });
	$query->swwaiteventslist();
	my $recivedEvents = $qDbh->hexecfetchall($query, 1);

	foreach my $event (@$events) {
		next unless ($event->{genorwait} eq 'wait');
		my $found = undef;
		my $received;
		foreach $received (@$recivedEvents) {
			if (($event->{eventid} eq $received->{eventid}) and ($event->{object_id} == $received->{object_id})) {
				$found = 1; last;
			}
		}
		if ($found) { push @theEvents, $received; }
		else {
			push @theEvents, { object_id => $event->{object_id},
									object_id_source => $event->{object_id_source},
									eventid => $event->{eventid},
									received => cafUtils->datetime1(1),
									};
		}
	}

	my $ok = 1;
	my $now = $qDbh->now();

	foreach my $event (@theEvents) {
		$query = $qDbh->newquery({object_id => $event->{object_id_source}, afterdate => $event->{received}});
		$query->sweventslist();
		my $received = $qDbh->hexecfetchrownop($query, 1);

		if ($received and ($received->{object_id} == $event->{object_id_source})) {
			$event->{received} = $received->{eventdate};
			$self->LogSysTrace("Received $event->{eventid} From $event->{object_id_source} - Raised on $event->{received}");
		}
		else {
			$ok = undef; # last;
			$self->LogSysTrace("Still waiting event $event->{eventid} From $event->{object_id_source}");
		}
	}

	if ($ok) {
		$query = $qDbh->newquery({object_id => $objid });
		$query->dwwaitevents();
		$qDbh->executefinish($query);
		
		foreach my $event (@theEvents) {
			$query = $qDbh->newquery($event);
			$query->iwwaitevents();
			$qDbh->executefinish($query);
		}
	}
	return $ok;
}

sub SetEvent {
	my $self = shift;

	return 1 unless (@_);
	$SchedRt::classVars->{_System}{myEvents}{shift} = 1;
}

sub ClearEvents {
	my $self = shift;

	$SchedRt::classVars->{_System}{myEvents} = undef;
}

sub GenerateEvents {
	my $self = shift;

	my $events;
	my @theEvents;
	my $objid = $self->MyId();
	my $objHier = $self->ObjectHierarchy();
	return 1 unless ($events = $objHier->eventslist($objid));

	my $qDbh = $self->QueueDbhAutocommit();
	my $query;

	if ($self->StoppedFlow() or $self->Halted()) {
		$self->ClearEvents();
		$self->{_System}{myEvents}{FAIL} = 1;
	}
	else { $self->{_System}{myEvents}{SUCCESS} = 1 }
	my $generatedEvents = $self->{_System}{myEvents};
	foreach my $event (@$events) {
		if ($generatedEvents->{$event->{event_id}} and ($event->{genorwait} eq 'generate')) {
			$query->$qDbh->newquery({object_id => $self->MyId(), event_id => $event->{event_id}, _expires => $event->{event_id} });
			$query->iwevents();
			$qDbh->executefinish($query);
		}
	}
}

sub GenerateAllEvents {
	my $self = shift;

	#die  "Invalde GenerateAllEvents Call" unless ($self->MyId() == $self->MyFlowId());
	return  unless ($self->MyId() == $self->MyFlowId());
	$self->GenerateEvents($self->MyFlowId());
=over
	my $incomFlows = $self->IncomSubFlows();
	my $outgoFlows = $self->OutgoSubFlows();

	foreach my $flowArr ($incomFlows, $outgoFlows) {
		foreach my $subFlow (@$flowArr) {
			$subFlow->GenerateEvents();
			$subFlow->ClearEvents();
		}
	}
=cut
}

sub RunOutgoingTransformation {
	my $self = shift;


	my $flowArr = $self->OutgoSubFlows();

	my $oldestIncomMsgId = $self->OldestIncomMsgId();
	my $oldestIncomMsgDate;
	my $rowCount = 0;

	my $qDbh = $self->QueueDbh();

	my $tablePrefix = $self->GenIncomTableName();
	my $masterTable = $tablePrefix . "_i";
	my $dataTable = $tablePrefix . "_id";
	my $msgCritretia = { mastertable => $masterTable, datatable => $dataTable, msgseq => $oldestIncomMsgId };

	my $query = $qDbh->newquery($msgCritretia);
	$query->snextincommsg();
	my $ret = $qDbh->execute($query);

	$self->InitProcessedRows();

	while (1) {
		my $row = $qDbh->hfetchrownop($query);
# We heve a new message if there's no more row or a new messeq was read 
		if ((!$row) or ($oldestIncomMsgId != $row->{msgseq})) {
			if ($rowCount > 0) {
				foreach my $subFlow (@$flowArr) {
					$subFlow->SkipMessage(undef);
					if ($oldestIncomMsgId > $subFlow->MyCurrIncomMsgId($oldestIncomMsgId)) {

						$subFlow->CopyIncomFields();
						$subFlow->OurCurrIncomMsgId($oldestIncomMsgId);
						$subFlow->OurCurrIncomMsgDate($oldestIncomMsgDate);

						$subFlow->BeforeTransformation(); # GAFFE il y a du grabbuge ... tester que before n'a pas t excut
						$subFlow->TransformMsg();
						if (! $subFlow->SkipMessage()) {
							$subFlow->LogTransformedMsg();
							$self->CommitIfNeeded();
						}
					}
				}
			}
			$self->ClearIncomFields();
			last unless ($row);

			$rowCount++;
			$oldestIncomMsgId = $row->{msgseq};
			$oldestIncomMsgDate = $row->{msgdate};
		}

		$self->IncomFieldValue($row->{fieldid}, $row->{field_value});
		$self->OutgoFieldValue($row->{fieldid}, $row->{field_value});
	}

	foreach my $subFlow (@$flowArr) { $subFlow->AfterTransformation(); } # GAFFE il y a du grabbuge ... tester que before a dj t excut

	$qDbh->finish($query);

	$self->FinalCommit();

}

sub RunOutgoingSend {
	my $self = shift;

	my $flowArr = $self->OutgoSubFlows();

	my $rowCount = 0;

	my $qDbh = $self->QueueDbh();

	$self->InitProcessedRows();
	foreach my $subFlow (@$flowArr) {
		$subFlow->SkipMessage(undef);
		my $oldestSentMsgId = $subFlow->OldestSentMsgId();
		$rowCount = 0;

		my $tablePrefix = $subFlow->GenOutgoTableName();
		my $masterTable = $tablePrefix . "_o";
		my $dataTable = $tablePrefix . "_od";
		my $msgCritretia = { mastertable => $masterTable, datatable => $dataTable, msgseq => $oldestSentMsgId, msgstatus => "transformed" };
		my $query = $qDbh->newquery($msgCritretia);
		$query->snextoutgomsg();
		my $ret = $qDbh->execute($query);

#		$self->LogSysTrace("RunOutgoingSend : Executed ($ret) : " . $query->query());
		while (1) {
			my $row = $qDbh->hfetchrownop($query);
			if ((!$row) or ($oldestSentMsgId != $row->{msgseq})) {
				if ($rowCount > 0) {
					$subFlow->MyCurrSentMsgId($oldestSentMsgId);

					$subFlow->BeforeWrite();
					if ($subFlow->SkipMessage()) {
						$subFlow->GetRollBackData();
						$subFlow->SendMsg();
					
						$subFlow->LogSentMsg();
						$subFlow->AfterWrite();
					}
					$self->CommitIfNeeded();
				}
				$subFlow->ClearOutgoFields();
				last unless ($row);
				if ($row) {
					$rowCount++;
					$oldestSentMsgId = $row->{msgseq};
				}
			}
			$subFlow->OutgoFieldValue($row->{fieldid}, $row->{field_value});
		}
		$qDbh->finish($query);

	}

	$self->FinalCommit();
}

sub LogIncomMessage {
	my $self = shift;

	my $fNames;
	#$fNames = $self->IncomFieldNames();
        return 1 if ($self->DirectFlow());

	$self->IncIncomsCount();
	return 1 unless ($fNames = $self->IncomFieldNames());

	my $qDbhA = $self->QueueDbhAutocommit();
	my $qDbh = $self->QueueDbh();
	my $tablePrefix = $self->GenIncomTableName();
	my $masterTable = $tablePrefix . "_i";
	my $dataTable = $tablePrefix . "_id";
	my $msgseq = $qDbhA->nextseq($tablePrefix);

	my $query = $qDbh->newquery({ msgseq => $msgseq, mastertable => $masterTable });
	
	$query->iincommsg();
	$qDbh->executefinish($query);

	foreach my $fldname (@$fNames) {
		my $fldvalue = $self->IncomFieldValue($fldname);
		if (defined($fldvalue)) {
			my $query2 = $qDbh->newquery({ msgseq => $msgseq, datatable => $dataTable, field_id => $fldname, field_value => $fldvalue });
			$query2->iincommsgdata();
			$qDbh->executefinish($query2);
		}
		$self->OurCurrIncomMsgId($msgseq);
	}
}

sub DirectTransfert {
	my $self = shift;

	my $incomFlows = $self->IncomSubFlows();
	my $outgoFlows = $self->OutgoSubFlows();
	$self->SkipMessage(undef);

	my $readFunc = ($self->IncomRelType() eq 'dependant') ? "ReadDependantMsg" : "ReadIndependantMsg";

	my %readStack = (iFlow => -1, Ack => undef, nFlows => -1, msgList => []);

#		$self->LogSysTrace("INCOMFLOWS ", $incomFlows);
	foreach my $incomFlow (@$incomFlows) {
#		$self->LogSysTrace($incomFlow);
		push @{$readStack{msgList}}, $incomFlow;
		$readStack{nFlows} += 1;
	}

	$self->PushContext("DirectTransfert");
	$self->InitProcessedRows();
	while ($self->$readFunc(\%readStack)) {
		last if ($self->Halted());
		if (! $self->SkipMessage()) {
			$self->LogIncomMessage(); # Write down in the queue database the content of the message
			foreach my $subFlow (@$outgoFlows) {
				next if ($subFlow->StoppedFlow());
				$subFlow->SkipMessage(undef);
				$subFlow->CopyIncomFields();
				# $outgoFlow->TransformAndSend ();
				$subFlow->BeforeTransformation(); # GAFFE il y a du grabbuge ... tester que before n'a pas t excut
				$subFlow->TransformMsg();
				if (! $subFlow->SkipMessage()) {
					$subFlow->LogTransformedMsg();

					# $subFlow->BeforeOpen();
					$subFlow->BeforeWrite();
					$subFlow->GetRollBackData();
					$subFlow->SendMsg();
					
					$subFlow->LogSentMsg();
					$subFlow->AfterWrite();
				}
				$self->CommitIfNeeded();
			}
		}
		$self->SkipMessage(undef);
	}
	foreach my $subFlow (@$incomFlows) {
		$subFlow->GlobalAck();
#		$subFlow->CloseSubFlow();
	}

	$self->FinalCommit();
	foreach my $subFlow (@$outgoFlows) {
		$subFlow->AfterTransformation();
#		$subFlow->CloseSubFlow();
	}

	$self->LogSysTrace("DirectTransfert Finished");
}

sub ReadIndependantMsg {
	my $self = shift;
	my $incomQ = shift;

	if ($incomQ->{iFlow} == -1) { $incomQ->{iFlow} = 0; }
#	$self->LogSysTrace("ReadIndependantMsg $incomQ->{nFlow}");
	while (1) {
		my $subFlow = $incomQ->{msgList}->[$incomQ->{iFlow}];
#		$self->LogSysTrace("		ReadIndependantMsg $incomQ->{iFlow}");
		return undef unless ($subFlow);
		if ($subFlow->StoppedFlow()) {
			$incomQ->{iFlow} += 1;
			next;
		}
		my $ret = $subFlow->GetNextMessage();
		if ($ret) {
			$subFlow->AcknowledgeMsg();
			return 1;
		}
		$incomQ->{iFlow} += 1;
	}
	return undef;
}

# L'idee est la suivante :
# Supposons que nous ayons une liste de demi flux entrant dependants A, B et C
# Nous allons commencer par lire les message du demi flux A
# Pour le premier message provenant de A 
# On va lire les messages correspondant provenant de B
# Pour le premier message provenant de B 
# On va lire les messages correspondant provenant de C
# pour chaque message provenant de C, on compose le message definitif
# Quand il n' ya plus de messages provenant de C
# On reprend le message suivant de B, et on reboucle sur C
# Quand il n'y a plus de message provenant de B
# On reprend le message suivant de A, et on reboucle sur B et C
# Quand il n'y a plus de messages de A : Alors on a termine


sub ReadDependantMsg {
	my $self = shift;
	my $incomQ = shift;

	if ($incomQ->{iFlow} == -1) { $incomQ->{iFlow} = 0; }
	my @msgList = @{$incomQ->{msgList}};
	my $ret = 0;
	my $i = $incomQ->{iFlow};
	my $subFlow = $msgList[$i];
	while (1) {
		if ($subFlow && (! $subFlow->StoppedFlow())) {
			$ret = $subFlow->GetNextMessage();
			if ($ret) {
				$subFlow->AcknowledgeMsg();
				if ($incomQ->{msgList}->[$i + 1]) { $i++; $subFlow = $incomQ->{msgList}->[$i]; } # There is more dependant subflows
				else { return ($ret); } # We were reading the last dependant subflow
			}
			else {
				# Backtrack : there is no more message in this subflow try with the next message from the prvious subflow
				$i--;
				$subFlow = $incomQ->{msgList}->[$i];
			}
			$incomQ->{iFlow} = $i;
		}
		else { return undef; }  # there is nothing to read
	}
}




sub CleanEnv {
	my $self = shift;

	$self->SaveVars();
#	$self->SaveStatus();
	$self->GenerateAllEvents();
	$self->CloseAllSubFlows();
	$SchedRt::classVars->{_System}{runId} = undef;
	$SchedRt::classVars->{_System}{startedTime} = undef;
}

sub CleanEnv2 {
	my $self = shift;

	$self->CloseAllSubFlows("force") if (ref($self->ObjectHierarchy()));
	$SchedRt::classVars->{_System}{runId} = undef;
	$SchedRt::classVars->{_System}{startedTime} = undef;
}











sub ProcessTerminate {

	my $self = $SchedRt::classVars;

	eval { $self->LogSysTrace("CAUGHT SIGNAL ", shift, "\n"); };
	eval {
		$self->BeforeStop();

#		$self->LogSysTrace("IFinished");
		$self->IFinished();
#		$self->LogSysTrace("CleanEnv");

		$self->AfterStop();

		$self->LogSysTrace("ClearEnv");
		$self->CleanEnv();
	};
	if ($@) {
		die $@ unless ($self->QueueDbhAutocommit() and $self->QueueDbh());
		eval {
		print STDERR "ERROR $@\n";
		$self->LogSysTrace("Fatal Error : $@");
		local $SIG{__DIE__} = 'IGNORE';
#		$self->LogSysTrace("ProcessMe OnError");
		$self->OnError($@) if (ref($self->ObjectHierarchy()));
		$self->LogSysTrace("IFinished2");
		$self->IFinished();

		$self->AfterStop() if (ref($self->ObjectHierarchy()));

		$self->LogSysTrace("CleanEnv2");
		$self->CleanEnv2();
		};
	}
	exit;
}

sub WSDaemon {
	my $self = shift;
	if (@_) { $SchedRT::classVars->{WSDAEMON}{Handle} = shift; }
	$SchedRT::classVars->{WSDAEMON}{Handle};
}

sub WebServiceHTTP {
	my $self = shift;
	my $attrs = shift;

	use mains::SOAPHTTPWS;

	my $daemon = SOAPHTTPWS->new (LocalAddr => $attrs->{WS_INTERFACE},
							LocalPort => $attrs->{WS_PORT},
							Reuse => $attrs->{WS_REUSEPORT});
}

sub WebServiceTCP {
	my $self = shift;
	my $attrs = shift;

	use mains::SOAPTCPWS;

	my $daemon = SOAPTCPWS->new (LocalAddr => $attrs->{WS_INTERFACE},
							LocalPort => $attrs->{WS_PORT},
							Reuse => $attrs->{WS_REUSEPORT});
}

sub WebService {
	my $self = shift;
	my $daemon;

	require SOAP::Lite;

# WS_PORT            | --nodefault--
# WS_TYPE            | WS_SOAP;WS_SOAP;WS_XMLRPC
# WS_COMPRESSION     | --nodefault--
# WS_HTTPS_CERT_FILE | --nodefault--
# WS_HTTPS_KEY_FILE  | --nodefault--
# WS_AUTHTYPE        | WS_AUTH_NONE;WS_AUTH_NONE;WS_AUTH_TICKET
# WS_PROTOCOL        | WS_PROTO_HTTP;WS_PROTO_HTTP;WS_PROTO_TCP;WS_PROTO_POP3
# WS_AUTH_TTL        | 60

	my $objHier = $self->ObjectHierarchy();

	my $attrlist = $objHier->attributelist($self->MyFlowId());
	my $attrs = {};

	foreach my $attr (@$attrlist) {
		$attrs->{$attr->{attrdefid}} = $attr->{attrvalue} if ($attr->{attrdefid});
	}

	if ($attrs->{WS_HTTPS_CERT_FILE} and (-f $attrs->{WS_HTTPS_CERT_FILE})) {
			$ENV{"HTTPS_CERT_FILE"} = $attrs->{WS_HTTPS_CERT_FILE};
		if ($attrs->{WS_HTTPS_KEY_FILE} and (-f $attrs->{WS_HTTPS_KEY_FILE})) {
			$ENV{"HTTPS_KEY_FILE"} = $attrs->{WS_HTTPS_KEY_FILE};
		}
		else { $ENV{"HTTPS_KEY_FILE"} = $attrs->{WS_HTTPS_CERT_FILE}; }
	}
	if ($attrs->{WS_PROTOCOL} eq 'WS_PROTO_HTTP') {
		$daemon = $self->WebServiceHTTP($attrs);
	}
	elsif ($attrs->{WS_PROTOCOL} eq 'WS_PROTO_TCP') {
		$daemon = $self->WebServiceHTTP($attrs);
	}
	else { die "Unkown Protocol $attrs->{WS_PROTOCOL}"; }

	$daemon->dispatch_to('CafeterraWS', 'CafeterraWSI', 'CafeterraWSO');

	if ($attrs->{WS_COMPRESSION} > 0) { $daemon->options({compress_threshold => $attrs->{WS_COMPRESSION}}); }

	$self->FinalCommit();
	$SchedRt::classVars->QueueInactiveDestroy(1);
	$SIG{"TERM"} = \&ProcessTerminate;
	$SIG{"INT"} = \&ProcessTerminate;
	$self->QueueDisconnect()  unless ($SchedRt::classVars->QueueInactiveDestroy());
	$self->WSDaemon ($daemon);
	$daemon->handle();
	$self->WSDaemon (undef);
	$self->QueueConnect() unless ($SchedRt::classVars->QueueInactiveDestroy());
	$objHier->dbh($self->QueueDbhAutocommit());
}

sub ProcessMe {
	my $self = shift;

	$self->WaitingEvents () || return;

	$self->LogSysTrace("LoadVars");
	$self->LoadVars();
	$self->LogSysTrace("StartAllSubFlows");
	$self->StartAllSubFlows();
	$self->LogSysTrace("RunOutgoingTransformation");
	$self->RunOutgoingTransformation();
	$self->LogSysTrace("RunOutgoingSend");
	$self->RunOutgoingSend();
	$self->LogSysTrace("DirectTransfert");
	$self->DirectTransfert();
}

sub PrintStackCallBack {

	cafDbg->printstack(@_);
}

sub BeforeStart {
	my $self = shift;

	$self->RunScriptByStep('bstart');
}

sub AfterStart {
	my $self = shift;

	$self->RunScriptByStep('astart');
}

sub BeforeStop {
	my $self = shift;

	$self->RunScriptByStep('bstop');
}

sub AfterStop {
	my $self = shift;

	$self->RunScriptByStep('astop');
}

sub ProcessFlow {
	my $self = shift;

	require tools::cafDbg;
	eval {
		$self->QueueConnect() || return;

		if ($self->LoadHierarchy() eq "updated") { $self->CloseAllSubFlows("force"); }
		
		$self->BeforeStart();

		$self->CanIRun () || return;
		
		$self->AfterStart();

		if ($self->Mode() eq "webservice") { $self->WebService(); }
		elsif ($self->Mode() eq "xmlsocket") { require mains::XmlSocket; $self->XmlSocket(); }
		else { $self->ProcessMe(); }
#		$self->LogSysTrace("HIERRAR = ". join (" - ", %{$self->ObjectHierarchy()->{____DURATION____}}));

		$self->BeforeStop();

#		$self->LogSysTrace("IFinished");
		$self->IFinished();
#		$self->LogSysTrace("CleanEnv");

		$self->AfterStop();

		$self->LogSysTrace("ClearEnv");
		$self->CleanEnv();
	};

	if ($@) {
#		print "ERROR $@\n";
		die $@ unless ($self->QueueDbhAutocommit() and $self->QueueDbh());
		$self->LogSysTrace("Fatal Error : $@");
		local $SIG{__DIE__} = 'IGNORE';
#		$self->LogSysTrace("ProcessMe OnError");
		$self->OnError($@) if (ref($self->ObjectHierarchy()));
		$self->LogSysTrace("IFinished2");
		$self->IFinished();

		$self->AfterStop() if (ref($self->ObjectHierarchy()));

		$self->LogSysTrace("CleanEnv2");
		$self->CleanEnv2();
	}
=over
	if ($@) {
		my $e = $@;
		if (my $query = refDBI->lastquery()) {
			$self->LogSysTrace("LAST QUERY : " . $query->query());
#			print join(" - ", %{$query->{_attr}}), "\n";
			my $bv = $query->bindvars();
			my $bvl = $query->bindvarlabels() || [];

			foreach (my $i = 0; $i <= $#$bv; $i++) {
				my $v = $bv->[$i] || "(NULL)";
				my $vl = $bvl->[$i] || "?";
				$self->LogSysTrace("	bind var $i - :$bvl->[$i] - $v");
			}
		}
		cafDbg->pusherror("9999999;$e");
		cafDbg->stringtoerror();
		$self->LogSysTrace("CleanEnv2");
		$self->CleanEnv2();
	}
=cut
}


package CafeterraWS;

@CafeterraWS::ISA=("SchedRt");

sub WSInit {
	return [1];
}

sub WSLogin {
	my $class = shift;
	my $authInfo = shift;

	my $classVars = $SchedRt::classVars;
	my $dbh = $SchedRt::classVars->QueueDbhAutocommit();
	my $daemon = $classVars->WSDaemon();
	
	$dbh->startsession( { userid=>$authInfo->{userid}, userpass=>$authInfo->{userpass}}, ipaddress=>$daemon->PeerAddress());
	return [ { sessionid => $dbh->sessionid(), } ];
}

sub WSAuthenticate {
	my $class = shift;
	my $authInfo = shift;

#	return undef unless ($authInfo->{sessionid});
	my $classVars = $SchedRt::classVars;
	my $dbh = $SchedRt::classVars->QueueDbhAutocommit();
	my $daemon = $classVars->WSDaemon();
	$dbh->startsession( { sessionid=>$authInfo->{sessionid}, userid=>$authInfo->{userid}, userpass=>$authInfo->{userpass}, ipaddress=>$daemon->PeerAddress() });
	return [ { sessionid => $dbh->sessionid(), } ];
}

sub WSLoadService {
	my $class = shift;
	my $service = shift;
	my $inparams = shift || {};
	my $outparams = shift || [];

	my $classVars = $SchedRt::classVars;

	$classVars->LoadVars();

	my $script = $classVars->LoadScript($service, 'webservice');
	die unless ($script);

	my $ret = $script->RunScript($inparams, $outparams);
#	$classVars->LogSysTrace("returning $ret");
	$classVars->SaveVars();
	return $ret;
}

sub WSProcess {
	my $class     = shift;
	my $authinfo  = shift;
	my $service   = shift;
	my $inparams  = shift || {};
	my $outparams = shift || [];

	my $ret;

	$SIG{"TERM"} = 'DEFAULT';
	$SIG{"INT"} = 'DEFAULT';
	$SchedRt::classVars->LogSysTrace("STARTING WEB SERVICE $service");
	$SchedRt::classVars->{_System}{startedTime} = time();
	$SchedRt::classVars->UndefNextExecutionSeq();
	$SchedRt::classVars->QueueConnect() unless ($SchedRt::classVars->QueueInactiveDestroy());
	my $objHier = $SchedRt::classVars->ObjectHierarchy();
	$objHier->dbh($SchedRt::classVars->QueueDbhAutocommit());
	if ($class->WSAuthenticate($authinfo)) {
		$ret = $class->WSLoadService($service, $inparams, $outparams);
	}
	else {
		$SchedRt::classVars->QueueDisconnect() unless ($SchedRt::classVars->QueueInactiveDestroy());
		$SchedRt::classVars->LogSysTrace("FINISHED WEB SERVICE $service : Authentification failed");
		die SOAP::Fault->faultcode(90001)->faultstring('Authentication failed');
	}
	$SchedRt::classVars->IFinishedWS();
	$SchedRt::classVars->QueueDisconnect() unless ($SchedRt::classVars->QueueInactiveDestroy());
	$SchedRt::classVars->LogSysTrace("FINISHED WEB SERVICE $service");
	return $ret;
}

sub WSIOLoadService {

	my $class = shift;
	my $subFlow = shift;
	my $service = shift;
	my $inparams = shift || {};
	my $outparams = shift || [];


	my $classVars = $SchedRt::classVars;


	foreach my $varname (@$inparams) {
		$subFlow->ParseVarName($varname, $inparams->{$varname});
	}

	my $script = $subFlow->LoadScript($service, 'webservice');
	my ($ret, $scriptret);
	eval {
		$ret = $scriptret = $script->RunScript($inparams, $outparams);
	};

	if ($@ || ! $scriptret) {
		die "Service Failed";
	}

	unless (ref($scriptret) eq "HASH") { $ret = {}; }

	foreach my $varname (@$outparams) {
		$ret->{$varname} = $subFlow->ParseVarName($varname);
	}

	return $ret;
}


package CafeterraWSI;

@CafeterraWSI::ISA=("CafeterraWS");

sub WSLoadService {

	my $class = shift;
	my $service = shift;
	my $inparams = shift || {};
	my $outparams = shift || [];

	my $classVars = $SchedRt::classVars;
	$classVars->LoadVars();

	my $incoms = $classVars->IncomSubFlows() || die "No Incoming Flows defined";
	my $incom = $incoms->[0] || die "No Incoming Flows defined";

	my $ret = $class->WSIOLoadService($incom, $service, $inparams, $outparams);

	$incom->LogIncomMessage();
	$classVars->SaveVars();
	$classVars->FinalCommit();

	return $ret;
}

package CafeterraWSO;

@CafeterraWSI::ISA=("CafeterraWS");

sub WSLoadService {
	my $class = shift;
	my $service = shift;
	my $inparams = shift || {};
	my $outparams = shift || [];

	my $classVars = $SchedRt::classVars;

	$classVars->LoadVars();
	my $outgos = $classVars->OutgoSubFlows() || die "No Outgoing Flows defined";
	my $outgo = $outgos->[0] || die "No Outgoing Flows defined";

	my $ret = $class->WSIOLoadService($outgo, $service, $inparams, $outparams);

	$outgo->OurCurrIncomMsgId(-1);
	$outgo->LogTransformedMsg();
	$outgo->LogSentMsg();
	$classVars->SaveVars();
	$classVars->FinalCommit();

	return $ret;

}

1;
