#!/usr/local/bin/perl
#
# cafdCSV 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
#History
#Aziz - 03 Jul 2003 - Correct the QUOTE_CHAR value assignation from STRING_CHAR
use 5.005;

package cafdCSV;
 
use strict;
use connectors::cafQry;


=cut
	_tempdir => Flowdir/temp
	_mailqueue => FLOWDIR/_mailq
	_smtpqueue => FLOWDIR/_smtpq
	_imapqueue => FLOWDIR/_imapq/folder
	_ftpqueue  => FLOWDIR/_ftpq
=cut


sub NewConnection {
	my $class = shift;
	my $db = shift;

	$class = ref($class) || $class;

	my $proto = "cafp" . $db->{connector}{protocolid};

#	eval { require $proto };

        eval "require connectors::$proto";
        my $e = $@;
        if ($@) { cafDbg->pushstackdump(1); }
 
        die "$e" if ($e);
	
#	print join (" - ", %{$db->{_ATTRS}}), "\n";
 
        @cafdCSV::ISA = ($proto);

	my $self = $class->NewProtocol($db);

	my $attrs = $db->{_ATTRS};
	my %csv_attrs = (
		eol              => exists($attrs->{RECORD_SEP}) ? $attrs->{RECORD_SEP} :  "\n",
		sep_char         => exists($attrs->{FIELD_SEP}) ? $attrs->{FIELD_SEP} :  ";",
		escape_char       => exists($attrs->{ESCAPE_CHAR}) ? $attrs->{ESCAPE_CHAR} :  "\\",
		quote_char       => exists($attrs->{QUOTE_CHAR}) ? $attrs->{QUOTE_CHAR} : "", #"\"",
		skip_first_row   => $attrs->{COLUMN_NAMES} eq "yes" ? 1 : undef,
		skip_rows        => $attrs->{COLUMN_NAMES} eq "yes" ? 1 : undef,
	);
	foreach my $a (keys %csv_attrs) {
		if (($csv_attrs{$a} !~ /^\\$/) and defined($csv_attrs{$a})) {
#			print STDERR "			$class EVALUATING $csv_attrs{$a}\n";
			eval "\$csv_attrs{$a} = \"$csv_attrs{$a}\"" unless (($csv_attrs{$a} eq "\\") or ($csv_attrs{$a} eq "\""));
		}
	}
	$self->{_CSV_ATTRS} = \%csv_attrs;
	$self->{dbh}       = DBI->connect("dbi:CSV:f_dir=", { RaiseError => 1 });
	$self;
}


sub csvattrib {
	my $self = shift;
	my $attrib = shift;

	if (@_) { $self->{_CSV_ATTRS}{$attrib} = shift; }
	$self->{_CSV_ATTRS}{$attrib};
}
		
sub csvinfo {
	my $self = shift;
	my $infolabel = shift;

	if (@_) { $self->{_CSVINFO}{$infolabel} = shift; }
	$self->{_CSVINFO}{$infolabel};
}

sub clearcsvinfo {
	my $self = shift;

	$self->{_CSVINFO} = undef;
	delete $self->{_CSVINFO};
}

sub preprepare {
	my $self = shift;
	my $q = shift;

	my ($cmd, $mode, $ad_mode);
	my $qText = $q->query();
	if ($qText =~ /\s*select/i) { $cmd = "select"; $mode = "r" }
	elsif ($qText =~ /\s*insert/i) { $cmd = "insert"; $mode = "w" }
	elsif ($qText =~ /\s*update/i) { $cmd = "update"; $mode = "w" }
	elsif ($qText =~ /\s*delete/i) { $cmd = "delete"; $mode = "w" }
	else { die "Unsuported sql command"; }

	$q->_attribute("command", $cmd);
	my $container = $self->{db}{container};

	my @acol_names = map { $_->{name} }  @{$container->{_FIELDS}};
	if ($#acol_names < 0) { @acol_names = ("dummy"); }
	my $scol_names = join(',', @acol_names);

	my $name = $container->{name};
	my $externalname = $container->{externalname};

	$self->csvinfo("_NAME", $name);
	$self->csvinfo("_MODE", $mode);
	$self->csvinfo("_CMD", $cmd);
	$self->csvinfo("_EXTERNALNAME", $externalname);
	$self->csvinfo("_SCOLNAMES", $scol_names);
	$self->csvinfo("_ACOLNAMES", \@acol_names);
}

sub prepare {
	my $self = shift;
	my $q = shift;

#	return $self->SUPER::prepare($q) if ($self->{_NAME});

	unless ($self->csvinfo("_NAME")) {
		$self->preprepare($q);
		my ($cmd, $mode) = ($self->csvinfo($q, "_CMD"),$self->csvinfo("_MODE"));

		my $dbh = $self->{dbh};

		my %attrs = %{$self->{_CSV_ATTRS}};
		my $tempfile;
		if ($q->mylabel() eq "_describetable") {
			$tempfile = $dbh->{csv_tables}->{describetable}{file};
		}
		else {
			my $fname = $self->csvinfo("_EXTERNALNAME");
			$tempfile = $self->getfile({ fname => $fname, mode => $mode });
		}
		$self->csvinfo("_TEMPFILE", $tempfile);

		if ($q->mylabel() ne "_describetable") {
			$attrs{skip_first_row} = undef unless ($cmd eq "select");
			$attrs{skip_rows} = undef unless ($cmd eq "select");
			$attrs{file} = $tempfile;
			$attrs{col_names} = $self->csvinfo("_ACOLNAMES");

			$dbh->{csv_tables}->{$self->csvinfo("_NAME")} = \%attrs;
		}
#		$self->trace();
#		print "CSVATTRS = ", join (" - ", %attrs), "\n";
	}
	return $self->SUPER::prepare($q);
}

sub setexternalname {
	my $self = shift;
	my $filename = shift;
   my $container = $self->{db}{container};
   $container->{externalname} = $filename;

	$self->csvinfo("_EXTERNALNAME", $filename) if ($self->csvinfo("_EXTERNALNAME"));
}

sub getexternalname {
	my $self = shift;
	my $filename = shift;
   my $container = $self->{db}{container};
	$self->csvinfo("_EXTERNALNAME") || $container->{externalname};
}

sub finalcommit {
	my $self = shift;

	return 1 unless $self->csvinfo("_NAME");
	if ($self->csvinfo("_CMD") ne "select") {
		my $tempfile = $self->csvinfo("_TEMPFILE");
		$self->protocommit($tempfile, $self->csvinfo("_EXTERNALNAME"));
	}
	$self->clearcsvinfo();
#	unlink $tempfile;
}

sub finalrollback {
	my $self = shift;

	return 1 unless $self->csvinfo("_NAME");
	my $tempfile = $self->csvinfo("_TEMPFILE");
	$self->protorollback($tempfile);
	$self->clearcsvinfo();
#	unlink $tempfile;
}

sub describe {
	my $self = shift;
	my $table_name = shift;

	return undef unless $self->connected();
	my $tempfile;
	return undef unless ($tempfile = $self->getfile({ fname => $table_name, mode => "r" }));

	my $dbh = $self->{dbh};
	my %attrs = %{$self->{_CSV_ATTRS}};
	$attrs{file} = $tempfile;
	# $attrs{skip_rows} = 0;
	
	$dbh->{csv_tables}->{describetable} = \%attrs;

	my $query = cafQry->new();
	$query->mylabel("_describetable");
	$query->query("select * from describetable");

	$self->execute($query);

	my $cols;
	#if ($db->{_ATTRS}{COLUMN_NAMES}) {
	$cols = $self->getcolnames($query);
		
	$cols = $self->fetchrownop($query) unless ($cols);

	$self->finish($query);
	my @ret;
	my $i = 0;
	foreach my $col (@$cols) {
		$i++;
		push @ret, {
				name         => $col,
				externalname => $col,
				datatypeid   => 'VARCHAR',
				datalength   => 100,
				fieldorder   => $i*10,
				keyposition  => ($i > 3) ? undef : $i,
		};
	}
#	unlink $tempfile;

	\@ret;
}

sub generatequery {
	my $self = shift;

	@cafdCSV::ISA = ('refDBI') unless ($self->isa('refDBI'));
	return $self->SUPER::generatequery(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;

	my $sub = "generate$command";
	return $self->$sub($command, $connector, $container, $fields, $datatypes);
}


sub columnnameformat {
	my $self = shift;
	my $col = shift;
	return $col->{name};
}

sub tablenameformat {
	my $self = shift;
	my $container = shift;
return $container->{name};
}


sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}";
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{name};
}

1;
