#!/usr/bin/perl

use Getopt::Std;

my $Usage =<<'End_of_Usage;';
help :
-f filename.op
-s separator
-o output separator
-h : this help
End_of_Usage;

# lecture des arguments

getopts('f:s:h',\%opts);
die "filename.op not specified\n$Usage" unless defined($opts{f});
if ($opts{h}) {
	print "$Usage";
	exit 1; # erreur ???
}
if ($opts{s}) {
	$sep = $opts{s};
	$outSep = $sep;
} else {
	$sep = '\|';
	$outSep = '|';
}
if ($opts{o}) {
	$outSep = $opts{o};
}
my $opfile=$opts{f};

# lecture de opfile

open (OPFILE,"<$opfile") || die "can't open $opfile : &!\n";
while (<OPFILE>) {
	chop;
	if (!($_ eq "")) {
		if (!($_ =~ /^([^:]*) *: *(.*) *$/)) {
			die "what's that, '$_' ?\n";
		}
		push (@champ, $1);
		@o = split(/,/,$2);
		@{$op[$#op+1]} = @o;
	}
}

#for ($c=0; $c<=$#op; $c++) {
#	print "size = ".$#{@op[$c]}."\n";
#}
# substr



sub null {
	my $str = $_[0];
	if ($str eq "") {
		return "null";
	} else {
		return $str;
	}
}

sub cho {
	my $str = $_[0];
	$str =~ s/^\s+//g;
	$str =~ s/\s+$//g;
	return $str;
}

sub d2u {
	my $str = $_[0];
	$str =~ s/^c:\///g;
	$str =~ s/\\/\//g;
	return $str;
}

sub bool2int {
	my $str = lc($_[0]);
  if ($str eq "null") {
    return "null";
  }
	if ($str eq "t" || $str eq "true") {
		return "1";
	} else {
		return "0";
	}
}

sub int2bool {
	my $str = lc($_[0]);
  if ($str eq "null") {
    return "null";
  }
	if ($str eq "1") {
		return "'t'";
	} else {
		return "'f'";
	}
}

sub quote {
	my $str = $_[0];
	$str =~ s/'/''/g;
	return "'".$str."'";
}

sub notNull {
	my $str = $_[0];
	if ($str eq "") { 
		print STDERR "champ nul!\n";
    $str = "null";
	};
	return $str;
}

sub tel {
	my $str = $_[0];
	$str =~ s/ //g;
  $str =~ s/\.//g;
  $str =~ s/-//g;
  my $ret = "";
	for ($l=0; $l<length($str); $l+=2) {
		$ret .= substr($str,$l,2)." ";
	}
	return $ret;
}

sub chkDate {
  my $date = $_[0];
  if ($date=~/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\/\-\.]([0-9]{2,4})$/) {
    return "'".$date."'";
  } 
  if ($date=~/^([0-9]{4})[\-\/\.]([0-9]{1,2})[\/\-\.]([0-9]{1,2})$/) {
    return "'".$3."/".$2."/".$1."'";
  } 
	return "null";
}

sub nomPrenom {
  my $str = $_[0];
  if (!($str=~/^([^ ]*) +(.*)$/)) {
    print STDERR "nom invalide! : $str\n";
    $nom = quote(cho($str));
    $prenom = quote(cho(""));
  }
	else {
		$nom = quote(cho($1));
		$prenom = quote(cho($2));
	}
  return $nom.$outSep.$prenom;
}

sub dep {
  my $str = $_[0];
  $dep = substr($str,0,2);
	if (($dep eq "97") || ($dep eq "98")) {
		$dep = substr($str,0,3);
	}
	return quote(cho($dep)).$outSep.quote(cho($str));
}

sub NIL {
  my $str = $_[0];
  if ($str eq "NIL") {
    return "";
  } else {
    return $str;
  }
}

sub sexe2bool {
  my $str = $_[0];
  if (($str eq "") || ($str eq "null")) {
    return "null";
  } elsif (($str eq "M") || ($str eq "m")) {
    return "'t'";
  } elsif (($str eq "F") || ($str eq "f")) {
    return "'f'";
  } else {
    print STDERR "sexe inconnu : $str\n";
    return "'t'";
  }
}


sub filtre {
	my $func = $_[0];
	my $arg = $_[1];
#  print "[apply $func to $arg ]";
	eval  "\$ret=".$func."(\$arg);";

	return $ret;
}

while (<STDIN>) {

	chop;

	@col = split(/$sep/,$_);
  $delta = $#champ - $#col; # au cas o il manque des pipes  la fin
  while ($delta>0) {
    $_ .= $sep;
    $delta--;
    push (@col,"");
  }

	for ($c=0; $c<=$#col; $c++) {

		for $thisOp (@{$op[$c]}) {
			$col[$c] = filtre($thisOp,$col[$c]);
		}
		
		print $col[$c];

		if ($c<$#col) {
			print $outSep;
		} 
		else {
			print "\n";
		}
	}
}
