#!/usr/bin/env python

""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from common import *
from pgmlgraph import *
import getopt
import sys

def main():
	"""
	pgml2ssql output ssql schema

	usage: pgml2ssql -f <pgml schema file> [-h] 
	-h : this help
	-f : pgml file
	-o : ssql output
	-u : use postgreSql isa keyword when table inherits

	"""
	
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'o:f:hud')
	except getopt.error, msg:
		usage(msg)

	pgmlFilename=''
	ssqlFilename=''
	idSequence = None
	debug = PYTHONDEBUG
	usePostgreSqlIsa = None
	usePostgreSqlConstraints = None
	refDefault = None
	useIndices = None
	
	for o, a in opts:
		if o == '-f': pgmlFilename = a
		if o == '-h': usage(main.__doc__)
		if o == '-o': ssqlFilename = a
		if o == '-d': debug = 1
		if o == '-u': usePostgreSqlIsa = 1

	if not pgmlFilename: usage(main.__doc__,'error : missing database pgml file')

	g = PgmlGraph('PgmlGraph',debug,idSequence,usePostgreSqlIsa,usePostgreSqlConstraints,refDefault,useIndices);
	g.read(pgmlFilename);
	g.simplify()
	
	output = stdout
	if ssqlFilename:
		output = open(ssqlFilename,'w')

	output.write(
		"""
	CREATE TABLE structtable (
		champ text,
		denom text,
		editable int4,
		rang int4,
		isoid bool,
		type text,
		defaut text,
		disp text,
		uid SERIAL PRIMARY KEY
	);
	
	CREATE TABLE constantes (
		tva float8 DEFAULT 0.206,
		salairenet float8 DEFAULT 10000,
		defaultjh float8,
		uid SERIAL PRIMARY KEY
	);
	
	insert into constantes (uid) values (1);
	
	
	create function tva(date) returns float8 as 'select 0.206+0.01*((float8(age(\\'April 4,2000\\'::datetime,$1::datetime)::reltime)/(@(float8(age(\\'April 4,2000\\'::datetime,$1::datetime)::reltime)))-1)/2)' language 'sql';
	
	CREATE FUNCTION nextid ( ) RETURNS int4 AS 'update constantes set uid=uid+1;select uid from constantes;' LANGUAGE 'SQL';
	
	create table structstructtable () inherits (structtable) ;
	
	INSERT INTO structstructtable (champ,denom,editable,rang,isoid,type,defaut) VALUES ('champ','Champ',1,0,'t','text',NULL);
	INSERT INTO structstructtable (champ,denom,editable,rang,isoid,type,defaut) VALUES ('denom','',1,0,'t','text',NULL);
	INSERT INTO structstructtable (champ,denom,editable,rang,isoid,type,defaut) VALUES ('editable','',1,0,'t','text',NULL);
	INSERT INTO structstructtable (champ,denom,editable,rang,isoid,type,defaut) VALUES ('rang','',1,0,'t','text',NULL);
	INSERT INTO structstructtable (champ,denom,editable,rang,isoid,type,defaut) VALUES ('isoid','',1,0,'t','text',NULL);
	INSERT INTO structstructtable (champ,denom,editable,rang,isoid,type,defaut) VALUES ('type','',1,0,'t','text',NULL);
	INSERT INTO structstructtable (champ,denom,editable,rang,isoid,type,defaut) VALUES ('defaut','',1,0,'t','text',NULL);
	INSERT INTO structstructtable (champ,denom,editable,rang,isoid,type,defaut) VALUES ('uid','pg_id',0,0,'t','int4',NULL);
	INSERT INTO structstructtable (champ,denom,editable,rang,isoid,type,defaut) VALUES ('disp','',1,0,'t','text',NULL);
	
	CREATE TABLE structconstantes (
	)
	inherits (structtable);
	INSERT INTO structconstantes (champ,denom,editable,rang,isoid,type,defaut) VALUES ('tva','TVA',1,1,'t',NULL,NULL);
	INSERT INTO structconstantes (champ,denom,editable,rang,isoid,type,defaut) VALUES ('salairenet','Salaire net',1,1,'t',NULL,NULL);
	INSERT INTO structconstantes (champ,denom,editable,rang,isoid,type,defaut) VALUES ('defaultjh','Prix jh (defaut)',1,1,'t',NULL,NULL);
	INSERT INTO structconstantes (champ,denom,editable,rang,isoid,type,defaut) VALUES ('uid','pg_id',0,9,'t','int4',NULL);
	
	""")
	
	g.write_ssql(output)

if __name__ == '__main__':
	main()
