""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from string import *
import os
import sys
import htmlentitydefs
import time

from smtplib import *

import MimeWriter
import mimetools
import cStringIO

#
# Classic style : sendmail system call
#
SENDMAIL='/usr/sbin/sendmail'
class Mail:
     def send_mail(self, sender, recipient, subject='', message='', header=''):
	     mail = os.popen("%s -t" % SENDMAIL, "w")
	     mail.write('From: %s\nTo: %s\nSubject: %s\n%s\n\n%s\n' % (sender, recipient, subject, header, message))
	     mail.close()
		
     def send_html_mail(self, sender, recipient, subject='', message=''):
	     self.send_mail(sender, recipient, subject, message, 'Content-Type: text/html; charset="iso-8859-1"\n')


class SmtpClient(SMTP):
	auto_reconnect_tries = range(10)
	seconds_sleep = 10
	MESSAGE = 0
	WARNING = 1
	ERROR = 2

	def __init__(self, host='localhost', port = 25, log = None):
		SMTP.__init__(self, host, port)
		self.host = host
		self.port = port
		if log:
			self.loginstance = log

	def log(self, type, message):
		if self.log:
			if type == self.MESSAGE:
				log.message(message)
			elif type == self.WARNING:
				log.warning(message)
			else: # ERROR
				log.error(message)
				sys.exit(2)
		else:
			if type == self.MESSAGE:
				print "SmtpClient : MESSAGE : " + message
			elif type == self.WARNING:
				print "SmtpClient : MESSAGE : " + message
			else: # ERROR
				print "SmtpClient : MESSAGE : " + message

	def _send(self, sender, recipients, message, mail_options='',
			 rcpt_options=''):
		self.sendmail(sender, recipients, message, mail_options, rcpt_options)
	
	def send_message(self, sender, recipients, message, mail_options='', rcpt_options=''):
		"""
		Send function. if SMTPServerDisconnected exception is raised,
		the instance tries to reconnect.
		"""
		while 1:
			try:
				self.sendmail(sender, recipients, message, mail_options, rcpt_options)
			except SMTPServerDisconnected:
				for i in self.auto_reconnect_tries:
					self.log(WARNING, "SMTPServerDisconnected : waiting %s seconds ..." \
							 % self.seconds_sleep)
					time.sleep(self.seconds_sleep)
					try:
						self.connect(host, port)
					finally:
						self.log(MESSAGE, "Reconnect : ok")
						break
					self.log(ERROR, "Reconnect : ok")
			else:
				return 1
		

class MailMessage:
	headers = []
	parts = []
	recipients = []
	_subject = ''
	multipartbody = 'mixed' # or 'alternative'
	mime_version = '1.0'
	
	def add_header(self, type, value):
		self.headers.append((type, value))
		
	def to(self, recipients):
		self.recipients.append('To', recipients)
		
	def cc(self, recipients):
		self.recipients.append('Cc', recipients)

	def bbc(self, recipients):
		self.recipients.append('Bcc', recipients)
		
	def subject(self, subject):
		self._subject = subject
		
	def add_part(self,
				 content,
				 encoding = 'quoted-printable',
				 charset = 'us-ascii',
				 content_type = 'text/plain',
				 content_disposition = 'inline',
				 type = 'string'):
		"""
		encoding : 'quoted-printable', 'base64', 'uuencode'
		"""
		self.parts.append((encoding, content_disposition, content_type, charset, content, type))
	
	def reset(self):
		self.headers = []
		self.parts = []
		self.recipients = []
		self._subject = ''

	def add_plain(self, content, encoding = 'quoted-printable',  charset = 'us-ascii'):
		self.add_part(content, encoding, charset, 'text/plain')
		
	def add_html(self, content, encoding = 'base64',  charset = 'us-ascii'):
		self.add_part(content, encoding, charset, 'text/html')
		
	def add_file(self, filename, content_type, encoding = 'base64',  charset = 'us-ascii'):
		self.add_part(filename, encoding, charset, content_type, 'inline', 'file')
		
	def _add_message(self, part, encoding, content_disposition, content_type, charset, content):
		part.addheader("Content-Transfer-Encoding", encoding)
		part.addheader("Content-Disposition", content_disposition)
		#
		# returns us a file-ish object we can write to
		#
		pout = part.startbody(content_type, [('charset', charset)])
		contentin = cStringIO.StringIO(content)
		mimetools.encode(contentin, pout, encoding)
		contentin.close()
		
	def _add_file(self, part, encoding, content_disposition, content_type, charset, filename):
		part.addheader("Content-Transfer-Encoding", encoding)
		part.addheader("Content-Disposition", content_disposition)
		#
		# returns us a file-ish object we can write to
		#
		pout = part.startbody(content_type, [('filename', filename)])
		#contentin = cStringIO.StringIO(content)
		file = open(filename)
		mimetools.encode(file, pout, encoding)
		#contentin.close()

	def message(self):
		"""
		Build Message
		"""
		out = cStringIO.StringIO() # output buffer for our message 
		writer = MimeWriter.MimeWriter(out)

		for type, value in self.recipients:
			writer.addheader(type, value)
		writer.addheader('Subject', self._subject)
		for type, value in self.headers:
			writer.addheader(type, value)
		writer.addheader('MIME-Version', self.mime_version)
		
		if len(self.parts) > 1:
			writer.startmultipartbody(self.multipartbody)
			writer.flushheaders()
			multipart = 1
			for encoding, content_disposition, content_type, charset, content, type in self.parts:
				subpart = writer.nextpart()
				if type == 'string':
					self._add_message(subpart, encoding, content_disposition, content_type, charset, content)
				else: #file
					self._add_file(subpart, encoding, content_disposition, content_type, charset, content)
			writer.lastpart()
		else:
			# only one item in parts expected
			for encoding, content_disposition, content_type, charset, content, type in self.parts:
				self._add_message(writer, encoding, content_disposition, content_type, charset, content)
		#
		# Now that we're done, close our writer and
		# return the message body
		#
		msg = out.getvalue()
		out.close()
		return msg
					   

htmlentity = {}

for key,value in htmlentitydefs.entitydefs.items():
	htmlentity[value] = key

def htmlentityEncode(s):
	if not s:
		return ''
	l=[]
	
	for c in s:
		if ord(c)>=127:
			if htmlentity.has_key(c):
				c = '&%s;' % htmlentity[c]
			else:
				c = ''
		l.append(c)
	return join(l,'')


