#include <iostream>

#include <pqxx/connection.h>
#include <pqxx/transaction.h>
#include <pqxx/cachedresult.h>

using namespace std;
using namespace pqxx;


int main()
{
  try
  {
    Connection C("");

    Transaction T(C, "sample4");

    CachedResult R(T, "SELECT * FROM events ORDER BY year", "result4", 2);

    // Read query results, fetching them on demand
    for (Result::size_type i = 0; i < R.size(); ++i)
      cout << '\t' << R[i][0].c_str() << '\t' << R[i][1].c_str() << endl;
  }
  catch (const exception &e)
  {
    cerr << "Exception: " << e.what() << endl;
    return 1;
  }

  return 0;
}


