/***************************************************************************
                          database.cpp  -  description
                             -------------------
    begin                : Fri Sep 20 2002
    copyright            : (C) 2002 by Shridhar Daithankar
    email                : shridhar_daithankar@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "database.h"

list* databaseList;
database *currentObject,*global,*tmpdb;

database::database()
{
 con=NULL;
 status=false;
 count=0;
}

database::~database()
{
 if(con)
  PQfinish(con);
}

void database::autoVacuum(void)
{
 //Get the statistics from the database.
 if(!this->collectStatistics()) return;

 //OK Now. Vacuum all those who are above threshold
 vacuum();
}

bool database::collectStatistics(void)
{
 char buf[256];

 sprintf(buf,"dbname=%s user=%s password=%s",this->dbname,this->username,this->password);
 this->con=PQconnectdb(buf);

 //ConnStatusType status=PQstatus(this->con);

 if(PQstatus(this->con)!=CONNECTION_OK)
 {
  fprintf(stderr,"Can not connect to database %s for user %s.\n",this->dbname,this->username);
  fprintf(stderr,"You might want to check username/password settings and if database is actually up.\n");
  PQfinish(this->con);this->con=NULL;
  return false;
 }

 sprintf(buf,"select markforautovacuum(%d,%d,%d);",this->insertThreshold,this->updateThreshold,this->deleteThreshold);
 this->res=PQexec(this->con,buf);

 if(!this->res)
 {
  fprintf(stderr,"Fatal error occured while refreshing statistics for database %s\n",this->dbname);
  fprintf(stderr,"It will be checked again in next iteration\n");
  PQfinish(this->con);this->con=NULL;
  return false;
 }

 if(PQresultStatus(this->res)!=PGRES_TUPLES_OK)
 {
  fprintf(stderr,"Can not refresh statistics information from the database %s.\n",this->dbname);
  fprintf(stderr,"The error is \n%s\n",PQresultErrorMessage(res));
  fprintf(stderr,"It will be checked again in next iteration\n");
  PQclear(this->res);
  PQfinish(this->con);this->con=NULL;
  return false;
 }
  return true;
}

void database::vacuum(void)
{
  PGresult *vres;
  int i;
  char buf[256],query[1024];
  char *relname;
  unsigned short rt;

  sprintf(buf,"select relname from auto_vacuum_stats where vacuum=true;");
  this->res=PQexec(this->con,buf);

  if(!this->res)
  {
   fprintf(stderr,"Fatal error occured while obtaining list of tables to vacuum for database %s\n",this->dbname);
   fprintf(stderr,"It will be checked again in next iteration\n");
   PQfinish(this->con);this->con=NULL;
   return;
  }

  if(PQresultStatus(this->res)!=PGRES_TUPLES_OK)
  {
   fprintf(stderr,"Can not get list of tables to vacuum from the database %s.\n",this->dbname);
   fprintf(stderr,"The error is \n%s\n",PQresultErrorMessage(res));
   fprintf(stderr,"It will be checked again in next iteration\n");
   PQclear(this->res);
   PQfinish(this->con);this->con=NULL;
   return;
  }

  rt=PQfnumber(this->res,"relname");

  for(i=0;i<PQntuples(this->res);i++)
  {
   //Obtain the result information
   relname=PQgetvalue(this->res,i,rt);


   sprintf(query,"vacuum analyze %s;",relname);
   vres=PQexec(this->con,query);

   if(!vres)
   {
    fprintf(stderr,"Fatal error occured while vacuuming table %s in database %s\n",relname, this->dbname);
    fprintf(stderr,"Remaining tables will be checked in next iteration\n");
    PQclear(this->res);
    continue;
   }

   if(PQresultStatus(vres)!=PGRES_COMMAND_OK)
   {
    fprintf(stderr,"Vacuuming table %s from the database %s did not succeed.\n",relname,this->dbname);
    fprintf(stderr,"The error is \n%s\n",PQresultErrorMessage(res));
   }

   PQclear(vres);

   //Update the vacuum table
   sprintf(query,"begin;update auto_vacuum_stats set vacuum='t' where relname='%s';commit;",relname);
   vres=PQexec(this->con,query);

   if(!vres)
   {
    fprintf(stderr,"Fatal error occured updating table %s in database %s\n",relname, this->dbname);
    fprintf(stderr,"The table will be vacuumed again in next iteration\n");
    PQclear(this->res);
    continue;
   }

   if(PQresultStatus(vres)!=PGRES_COMMAND_OK)
   {
    fprintf(stderr,"Updating table auto_vacuum_stats for relation %s from the database %s did not succeed.\n",relname,this->dbname);
    fprintf(stderr,"The error is \n%s\n",PQresultErrorMessage(res));
   }

   PQclear(vres);
  }

 //Clear the resources
 PQclear(this->res);
 PQfinish(this->con);
 this->con=NULL;

}