/***************************************************************************
                          init.cpp  -  description
                             -------------------
    begin                : Sun Sep 22 2002
    copyright            : (C) 2002 by Shridhar Daithankar
    email                : shridhar_daithankar@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "init.h"

FILE* fp;
bool reInit=false,quit=false;

void init(void)
{
 char *home,*rcfile;
 int len,retval;
 struct stat s;

 home=getenv("HOME");
 len=strlen(home);

 if(len>512)
 {
  fprintf(stderr,"The home dir. is insanely long. I can not read it.\n");
  fprintf(stderr,"Please make it shorter than 512 bytes and come back\n");
  exit(-1);
 }

 rcfile=(char *)malloc(sizeof(char)*(len+10));

 if(!rcfile)
 {
  fprintf(stderr,"Can not get memory to store resource file name. Quitting..\n");
  exit(-1);
 }

 strcpy(rcfile,home);
 strcat(rcfile,"/.pgavdrc");

 //Check permission of file. It has to be 400. Otherwise don't read it as it will contain database
 //passwords.
 retval=stat(rcfile,&s);

 if(retval<0)
 {
  fprintf(stderr,"Can not stat the rc file %s. Quitting..\n",rcfile);
  exit(-1);
 }

 if(s.st_mode&S_IRGRP || s.st_mode&S_IWGRP || s.st_mode&S_IROTH || s.st_mode&S_IWOTH)
 {
  fprintf(stderr,"The resource file permissions has to 400. I will not read it unless it is so.\n");
  fprintf(stderr,"Please correct it and come back\n");
  exit(-1);
 }

 fp=fopen(rcfile,"r");
 if(!fp)
 {
  fprintf(stderr,"Can not open the resource file %s for reading. Quitting..\n",rcfile);
  exit(-1);
 }

 yyin=fp;

 //Initialise database structures
 databaseList=new list;
 currentObject=new database("Global");

 if(!databaseList || !currentObject)
 {
  fprintf(stderr,"Can not get memory for initial data structures. Quitting..\n");
  exit(-1);
 }

 global=currentObject;

 //Now assign the default values
 global->interval=1;							
 unit=1;													

 global->insertThreshold=1000;
 global->updateThreshold=1000;
 global->deleteThreshold=1000;

 //Parse the config files. So that main program can resume the working straight away,
 yyparse();

 //So far so good. Clean up the things
 fclose(fp);
 free(rcfile);

 //some sanity checks
 if(!databaseList->count)
 {
  fprintf(stderr,"You need to define at least one database\n");
  exit(-1);
 }
}

void sig_handler(int signum)
{
 if(signum==SIGHUP)reInit=true;
 if(signum==SIGTERM)quit=true;
}