/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import pgclibrary.dataaccess.dataSource;
import pgclibrary.dataaccess.dataSourceVector;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.User;
import pgclibrary.utilities.Utilities;

public class Group
extends DBObject {
    int[] user_list = null;
    Vector users = null;

    public Group(DBObject owner, String _name) {
        super(owner);
        this.search(_name);
    }

    public Group(DBObject owner) {
        super(owner);
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append("DROP GROUP ");
        retorno.append(this.getName());
        retorno.append(";\n");
        return retorno.toString();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append("CREATE GROUP ");
        retorno.append(this.getName());
        retorno.append(";\n");
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(String _name) {
        boolean retorno = false;
        try {
            this.initialize();
            PreparedStatement prep = this.getConnection().prepareStatement("SELECT * FROM PG_GROUP WHERE GRONAME=?");
            prep.setString(1, _name);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                this.setName(rs.getString("GRONAME"));
                this.setUsers(rs.getArray("GROLIST"));
                retorno = true;
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.user_list = null;
        this.users = null;
    }

    private int getUserIndex(User _user) {
        int retorno = -1;
        int i = 0;
        while (i < this.users.size() && retorno == -1) {
            if (_user.getName().equals(((User)this.users.get(i)).getName())) {
                retorno = i;
            }
            ++i;
        }
        return retorno;
    }

    private void verifyUsers() {
        if (this.users == null && this.user_list != null) {
            this.users = new Vector();
            int i = 0;
            while (i < this.user_list.length) {
                long uoid = this.user_list[i];
                this.users.add(new User(this, uoid));
                ++i;
            }
        } else if (this.users == null) {
            this.users = new Vector();
        }
    }

    public Vector getUsers() {
        this.verifyUsers();
        return this.users;
    }

    public dataSource getUsersTable() {
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Name");
        dsve.addColumnName("Valid Until");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        Vector temp = this.getUsers();
        int i = 0;
        while (i < temp.size()) {
            User usr = (User)temp.get(i);
            Vector<String> elem = new Vector<String>();
            elem.add(usr.getName());
            if (usr.getValidLimit() != null) {
                elem.add(Utilities.formatDate(usr.getValidLimit()));
            } else {
                elem.add("");
            }
            dsve.addElement(elem);
            ++i;
        }
        return dsve;
    }

    public void addUser(User _user) {
        this.verifyUsers();
        if (_user != null && this.getUserIndex(_user) < 0) {
            this.users.add(_user);
        }
    }

    public void removeUser(User _user) {
        int ind;
        this.verifyUsers();
        if (_user != null && (ind = this.getUserIndex(_user)) >= 0) {
            this.users.remove(ind);
        }
    }

    private void setUsers(Array _users) {
        try {
            this.user_list = (int[])_users.getArray();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.user_list = null;
        }
    }

    public void refresh() {
        this.search(this.getName());
    }
}

