/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBINDEX_H
#define DBINDEX_H

#include <string>
#include <vector>
#include "../../../exceptions/indexoutofrangeexception.h"

/**
 * This class is used to represent a database table index.
 */
class DBIndex
{

protected:
	string m_strIndexName;
	string m_strTableName;
	string m_strIndexComment;
	bool m_bUnique;
	bool m_bPrimary;
	vector<string> m_vstrIndexedColumns;
				
public:
	
	/**
 	 * Constructor
   */		
	DBIndex();
	
	/**
 	 * Destructor
   */		
	~DBIndex();

	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void clear();
	
	/**
 	 * Used to add an indexed column to the list.
   */			    			
	void addIndexedColumn(const string & rstrIndexedColumn);
	
	/**
 	 * Used to retrieve an indexed column.
   */			    			
	const string & getIndexedColumn(int nColumnIndex) const throw (IndexOutOfRangeException);
	
	/**
	 * Used to get the number columns for this index.
	 */
	int getNumberOfColumns() const; 			
	
	/**
 	 * Used to set the table name.
   */			    	
	void setTableName(const string &rstrTableName);

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & getTableName() const;

	/**
 	 * Used to set the index name.
   */			    						
	void setIndexName(const string &rstrIndexName);

	/**
 	 * Used to retrieve the index name.
   */			    			
	const string & getIndexName() const;			

	/**
 	 * Used to set the index comment.
   */			    						
	void setIndexComment(const string &rstrIndexComment);

	/**
 	 * Used to retrieve the index comment.
   */			    			
	const string & getIndexComment() const;			
	
	/**
 	 * Used to set the unique property.
   */			    						
	void setUnique(bool bUnique);

	/**
 	 * Used to get the unique property.
   */			    						
	bool isUnique();
	
	/**
 	 * Used to set the primary key property.
   */			    						
	void setPrimary(bool bPrimary);

	/**
 	 * Used to get the primary key property.
   */			    						
	bool isPrimary();
	
};

#endif

