<?
/* index.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");

setdefault($id, 1);
/* get the name and description of all the sub-categories under this one */
$qid_c = db_query("
	SELECT id, name, special_level, description
	FROM categories
	WHERE parent_id = '$id' AND id > 1
	ORDER BY special_level, name
	");
/* get all the products under this category */
$qid_p = db_query("
	SELECT
		 p.id
		,p.name AS name
		,p.price
		,p.discount
		,p.discqty
		,p.weight
		,p.special_flag
		,p.special_level
		,p.description
		,p.thumbwidth
		,p.thumbheight
		,pc.category_id
		,b.name AS bname
		,i.iva
	FROM products p, products_categories pc, brands b, iva i
	WHERE p.id = pc.product_id AND p.brand_id = b.id AND p.iva_id = i.id AND pc.category_id = '$id'
	ORDER BY p.special_level ASC
	");

$DOC_TITLE = "Shopping_Catalog";
$SESSION["goback"]["request_uri"] = $REQUEST_URI;
$SESSION["goback"]["query_string"] = $QUERY_STRING;
include("$CFG->dirroot"."/header.php");

$t = new Template();
$t->set_file(array("page" => "templates/index.ihtml"));
require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
require($CFG->localedir . $SESSION["lang"] . "/global-shopping.inc.php");
require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
$t->set_var("wwwroot", $CFG->wwwroot);
$t->set_var("productswww", $CFG->productswww);
$t->set_var("ME", $ME);
$t->set_var("id", $id);

build_category_path($id, $category_path);
$t->set_var("category_path", $category_path);

$t->set_block("page", "noframes", "noframes_blck");
$t->set_var("noframes_blck", "");
$t->set_block("page", "noframes2", "noframes2_blck");
$t->set_var("noframes2_blck", "");
if (!$SESSION["frames_used"] || has_priv("admin")){
	$t->parse("noframes_blck", "noframes", true);
	$t->set_block("noframes2", "no_sub_categories", "no_sub_categories_blck");
	$t->set_block("noframes2", "category_row", "category_rows");
	$t->set_block("noframes2", "adminnoframes2", "adminnoframes2_blck");
	$t->set_var("no_sub_categories_blck", "");
	$t->set_var("category_rows", "");
	if (($numr = db_num_rows($qid_c)) == 0)
		$t->parse("no_sub_categories_blck", "no_sub_categories", true);
	else {
		for ($i=0; $i<$numr; $i++) {
			$cat = db_fetch_object($qid_c, $i);
			if (has_priv("admin")) {
				$t->set_var(array(
					"c_special_level"	=> $cat->special_level . " - ",
					"category_id"		=> $cat->id,
					"cname"			=> ov($cat->name)
				));
			} else {
				$t->set_var(array(
					"c_special_level"	=> "",
					"category_id"		=> $cat->id,
					"cname"			=> ov($cat->name)
				));
			}
			$t->parse("category_rows", "category_row", true);
		}
	}
	$t->set_var("adminnoframes2_blck", "");
	if (has_priv("admin"))
		$t->parse("adminnoframes2_blck", "adminnoframes2", true);
	$t->parse("noframes2_blck", "noframes2", true);
}

$t->set_block("page", "products", "products_blck");
$t->set_var("products_blck", "");
$t->set_block("page", "no_products", "no_products_blck");
$t->set_var("no_products_blck", "");
if (($numr = db_num_rows($qid_p)) == 0)
	$t->parse("no_products_blck", "no_products", true);
else {
// Let us define blocks nested inside a product_row...
// We indent the code to highlight the blocks' hierarchical nesting...
	$t->set_block("products", "product_row", "product_rows");
		$t->set_block("product_row", "adminprod", "adminprod_blck");
			$t->set_block("adminprod", "adminprodimage", "adminprodimage_blck");
			$t->set_block("adminprod", "special_flag", "special_flag_blck");
		$t->set_block("product_row", "notadminprod", "notadminprod_blck");
			$t->set_block("notadminprod", "notadminprodimage", "notadminprodimage_blck");
		$t->set_block("product_row", "brand_used", "brand_used_blck");
		$t->set_block("product_row", "iva_used", "iva_used_blck");
		$t->set_block("product_row", "discount_block", "discount_block_blck");
			$t->set_block("discount_block", "discqty_block", "discqty_block_blck");
		$t->set_block("product_row", "weight_used", "weight_used_blck");
// ... end of the blocks :)
	$t->set_var("product_rows", "");	// Now let us reset the product rows container...
	for ($i=0; $i<$numr; $i++) {
// Now let us reset the blocks contents...
// We indent the code to highlight the blocks' hierarchical nesting...
		$t->set_var("adminprod_blck", "");
			$t->set_var("adminprodimage_blck", "");
			$t->set_var("special_flag_blck", "");
		$t->set_var("notadminprod_blck", "");
			$t->set_var("notadminprodimage_blck", "");
		$t->set_var("brand_used_blck", "");
		$t->set_var("iva_used_blck", "");
		$t->set_var("discount_block_blck", "");
			$t->set_var("discqty_block_blck", "");
		$t->set_var("weight_used_blck", "");
// ... now we have reset all nested blocks :)
		$prod = db_fetch_object($qid_p, $i);
		$t->set_var(array(
			"id"		=> $id,
			"product_id"	=> $prod->id,
			"pname"		=> ov($prod->name),
			"price"		=> price,
			"fprice"	=> formatted_price($prod->price),
			"description"	=> ovwbr($prod->description)
		));
		if (has_priv("admin")) {
			if (file_exists($CFG->productsdir.string_cleanup($prod->id).".thumb.jpg")) {
				$t->set_var(array(
					"imagefilename"	=> string_cleanup($prod->id),
					"thumbwidth"	=> $prod->thumbwidth,
					"thumbheight"	=> $prod->thumbheight
				));
				$t->parse("adminprodimage_blck", "adminprodimage", true);
			}
			$t->set_var("p_special_level", $prod->special_level);
			if ($prod->special_flag)
				$t->parse("special_flag_blck", "special_flag", true);
			$t->parse("adminprod_blck", "adminprod", true);
		} else {
			if (file_exists($CFG->productsdir.string_cleanup($prod->id).".thumb.jpg")) {
				$t->set_var(array(
					"imagefilename"	=> string_cleanup($prod->id),
					"thumbwidth"	=> $prod->thumbwidth,
					"thumbheight"	=> $prod->thumbheight
				));
				$t->parse("notadminprodimage_blck", "notadminprodimage", true);
			}
			$t->parse("notadminprod_blck", "notadminprod", true);
		}
		if ($SESSION["brand_used"] && $prod->bname != "") {
			$t->set_var("bname", ov($prod->bname));
			$t->parse("brand_used_blck", "brand_used", true);
		}
		if ($SESSION["iva_used"]) {
			$t->set_var("iva", $prod->iva);
			$t->parse("iva_used_blck", "iva_used", true);
		}
		if ($prod->discount > 0) {
			$t->set_var("discount", $prod->discount);
			if ($prod->discqty > 1) {
				$t->set_var("discqty", $prod->discqty);
				$t->parse("discqty_block_blck", "discqty_block", true);
			}
			$t->parse("discount_block_blck", "discount_block", true);
		}
		if ($SESSION["weight_used"]) {
			$t->set_var(array(
				"weight"	=> $prod->weight,
				"fweight"	=> formatted_weight($prod->weight)
			));
			$t->parse("weight_used_blck", "weight_used", true);
		}
		$t->parse("product_rows", "product_row", true);
	}
	$t->parse("products_blck", "products", true);
}

$t->pparse("out", "page");
//include("templates/index.ihtml");

include("$CFG->dirroot"."/footer.php");

?>
