<?php
/* purchase_now.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();

$DOC_TITLE = "Checkout";

include ("$CFG->dirroot" . "/header.php");

$t = new Template();
include ("$CFG->localelangdir" . "/global-common.inc.php");
include ("$CFG->localelangdir" . "/global-shopping.inc.php");
include ("$CFG->localelangdir" . "/global-admin.inc.php");

if ($CART->itemcount() == 0) {	// the shopping cart is empty
	$t->set_file(array("page" => "templates/empty_shopping_cart.ihtml"));
} else {
	$t->set_var("ME", $ME);
	if (match_referer() && isset($HTTP_POST_VARS) && !isset($from_menu)) {	// form has been submitted
		$frm = $HTTP_POST_VARS;
		$errors = new Object;
		$errormsg = "";
		validate_customer($frm["customer"], &$errors, &$errormsg);
		validate_contact($frm["contact"], &$errors, &$errormsg);
		validate_address($frm["address"], &$errors, &$errormsg);
		validate_number($frm["number"], &$errors, &$errormsg);
		validate_city($frm["city"], &$errors, &$errormsg);
		validate_country($frm["country"], &$errors, &$errormsg);
		validate_zip_code($frm["zip_code"], &$errors, &$errormsg);
		validate_comments($frm["comments"], &$errors, &$errormsg);
		$t->set_var(array(
			"customer"	=> ov($frm["customer"]),
			"contact"	=> ov($frm["contact"]),
			"address"	=> ov($frm["address"]),
			"number"	=> ov($frm["number"]),
			"city"		=> ov($frm["city"]),
			"country"	=> ov($frm["country"]),
			"zip_code"	=> ov($frm["zip_code"]),
			"comments"	=> ov($frm["comments"])
		));

		if (empty($errormsg)) {
			save_orderinfo($HTTP_POST_VARS);
			$qid = new PGM_Sql;
			get_cart_items(&$qid);

			$t->set_file(array("page" => "templates/purchase_confirmation.ihtml"));
			$t->set_var("wwwroot", $CFG->wwwroot);
			$t->set_block("page", "weight_used", "weight_used_blck");
			$t->set_var("weight_used_blck", "");
			$t->set_block("page", "weight_notused", "weight_notused_blck");
			$t->set_block("page", "delivery_used", "delivery_used_blck");
			$t->set_var("delivery_used_blck", "");
			$t->set_var("weight_notused_blck", "");
			if ($SESSION["weight_used"]) {
				$t->parse("weight_used_blck", "weight_used", true);
				$t->set_var("cart_weight", formatted_weight($CART->weight));
			} else
				$t->parse("weight_notused_blck", "weight_notused", true);
			$t->set_block("page", "product_row", "product_rows");
				$t->set_block("product_row", "iva_used", "iva_used_blck");
			$t->set_var("product_rows", "");
			while ($qid->next_record()) {
				$t->set_var("iva_used_blck", "");
				$t->set_var(array(
					"prod_name"	=> ($qid->f("lname") != "") ? ov($qid->f("lname")) : ov($qid->f("name")),
					"prod_price"	=> formatted_price($qid->f("price")),
					"prod_items"	=> $CART->items[$qid->f("id")],
					"prod_subtotals" => formatted_price ($CART->subtotals[$qid->f("id")]), 
				));
				if ($SESSION["iva_used"]) {
					$t->set_var("prod_iva", $qid->f("iva"));
					$t->parse("iva_used_blck", "iva_used", true);
				}
				$t->parse("product_rows", "product_row", true);
			}
			if ($SESSION["delivery_used"]) {
				$t->set_var(array(
					"cart_total"	=> formatted_price($CART->total),
					"cart_delivery"	=> formatted_price($CART->delivery)
				));
				$t->parse("delivery_used_blck", "delivery_used", true);
			}
			$t->set_var(array(
				"cart_grandtotal"	=> formatted_price($CART->grandtotal),
				"address"		=> ovwbr($frm["address"]),
				"comments"		=> owbr(trim($comments) == "" ? $None_Female_Singular : $comments)
			));
		} else {
			$t->set_file(array("page" => "templates/purchase_now.ihtml"));
			$t->set_var(array(
				"err_customer"	=> errmsg2($errors->customer),
				"err_contact"	=> errmsg2($errors->contact),
				"err_address"	=> errmsg2($errors->address),
				"err_number"	=> errmsg2($errors->number),
				"err_city"	=> errmsg2($errors->city),
				"err_country"	=> errmsg2($errors->country),
				"err_zip_code"	=> errmsg2($errors->zip_code),
				"err_comments"	=> errmsg2($errors->comments),
			));
		}
	} else {
		$t->set_file(array("page" => "templates/purchase_now.ihtml"));
		$qid = new PGM_Sql;
		$qid->Query("
			SELECT firstname, lastname, phone,
				address, number, city, country, zip_code
			FROM users
			WHERE username = '{$SESSION["user"]["username"]}'
		");
		$qid->next_record();
		$appoggio = $qid->f("firstname") . " " . $qid->f("lastname");
		$t->set_var(array(
			"customer"	=> ov($appoggio),
			"contact"	=> ov($qid->f("phone")),
			"address"	=> ov($qid->f("address")),
			"number"	=> ov($qid->f("number")),
			"city"		=> ov($qid->f("city")),
			"country"	=> ov($qid->f("country")),
			"zip_code"	=> ov($qid->f("zip_code")),
			"comments"	=> ""
		));
		$t->set_var(array(
			"err_customer"	=> "",
			"err_contact"	=> "",
			"err_address"	=> "",
			"err_number"	=> "",
			"err_city"	=> "",
			"err_country"	=> "",
			"err_zip_code"	=> "",
			"err_comments"	=> "",
		));

		if ($info = load_orderinfo()) {
			$t->set_var(array(
				"customer"	=> ov($info->customer),
				"contact"	=> ov($info->contact),
				"address"	=> ov($info->address),
				"number"	=> ov($info->number),
				"city"		=> ov($info->city),
				"country"	=> ov($info->country),
				"zip_code"	=> ov($info->zip_code),
				"comments"	=> ov($info->comments)
			));
		}
	}

	include ("$CFG->dirroot" . "/form_header.php");
}

$t->pparse("out", "page");

include ("$CFG->dirroot" . "/footer.php");

?>
