<?
/* dblib.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi (pratesi@telug.it) */
/* (c) 2000 Oleg V. Kalashnikov <oleg@ok.gnu.zp.ua> */

if (!isset($DB_DIE_ON_FAIL)) { $DB_DIE_ON_FAIL = true; }
if (!isset($DB_DEBUG)) { $DB_DEBUG = false; }

function db_connect($dbhost, $port, $dbname, $dbuser, $dbpass) {
/* connect to the database $dbname on $dbhost with the user/password pair
 * $dbuser and $dbpass. */

	global $DB_DIE_ON_FAIL, $DB_DEBUG;

	if (! $dbh = pg_pconnect("host=$dbhost port=$port user=$dbuser password=$dbpass dbname=$dbname")) {
		if ($DB_DEBUG) {
			echo "<h2>Can't connect to $dbhost as $dbuser</h2>";
//			echo "<p><b>MySQL Error</b>: ", db_error();
// Con PostgreSQL le cose sono un pochino diverse.
		} else {
			echo "<h2>Database error encountered</h2>";
		}

		if ($DB_DIE_ON_FAIL) {
			echo "<p>This script cannot continue, terminating.";
			die();
		}
	}

/*
	if (! mysql_select_db($dbname)) {
		if ($DB_DEBUG) {
			echo "<h2>Can't select database $dbname</h2>";
			echo "<p><b>MySQL Error</b>: ", db_error();
		} else {
			echo "<h2>Database error encountered</h2>";
		}

		if ($DB_DIE_ON_FAIL) {
			echo "<p>This script cannot continue, terminating.";
			die();
		}
	}
*/

	return $dbh;
}

function db_disconnect() {
/* disconnect from the database, we normally don't have to call this function
 * because PHP will handle it */

	pg_close();
}

function db_query($query, $debug=false, $die_on_debug=true, $silent=false) {
/* run the query $query against the current database.  if $debug is true, then
 * we will just display the query on screen.  if $die_on_debug is true, and
 * $debug is true, then we will stop the script after printing he debug message,
 * otherwise we will run the query.  if $silent is true then we will surpress
 * all error messages, otherwise we will print out that a database error has
 * occurred */

	global $DB_DIE_ON_FAIL, $DB_DEBUG;

	if ($debug) {
		echo "<pre>" . htmlspecialchars($query) . "</pre>";

		if ($die_on_debug) die;
	}

	$qid = pg_exec($query);

	if (! $qid && ! $silent) {
		if ($DB_DEBUG) {
			echo "<h2>Can't execute query</h2>";
			echo "<pre>" . htmlspecialchars($query) . "</pre>";
//			echo "<p><b>MySQL Error</b>: ", db_error();
// Con PostgreSQL le cose funzionano un po' diversamente.
		} else {
			echo "<h2>Database error encountered</h2>";
		}

		if ($DB_DIE_ON_FAIL) {
			echo "<p>This script cannot continue, terminating.";
			die();
		}
	}

	return $qid;
}

function db_fetch_array($qid, $row) {
// /* grab the next row from the query result identifier $qid, and return it
//  * as an associative array.  if there are no more results, return FALSE */

	return pg_fetch_array($qid, $row);
}

function db_fetch_row($qid, $row) {
// /* grab the next row from the query result identifier $qid, and return it
//  * as an array.  if there are no more results, return FALSE */

	return pg_fetch_row($qid, $row);
}

function db_fetch_object($qid, $row) {
// /* grab the next row from the query result identifier $qid, and return it
//  * as an object.  if there are no more results, return FALSE */

	return pg_fetch_object($qid, $row);
}

function db_num_rows($qid) {
/* return the number of records (rows) returned from the SELECT query with
 * the query result identifier $qid. */

	return pg_numrows($qid);
}

//function db_affected_rows() {
///* return the number of rows affected by the last INSERT, UPDATE, or DELETE
// * query */
//
//	return mysql_affected_rows();
//}
// In PostgreSQL it doesn't exist

//function db_insert_id() {
///* if you just INSERTed a new row into a table with an autonumber, call this
// * function to give you the ID of the new autonumber value */
//
//	return mysql_insert_id();
//}
// In PostgreSQL it doesn't exist

//function db_free_result($qid) {
///* free up the resources used by the query result identifier $qid */
//
//	mysql_free_result($qid);
//}
// In PostgreSQL it doesn't exist

//function db_num_fields($qid) {
///* return the number of fields returned from the SELECT query with the
// * identifier $qid */
//
//	return mysql_num_fields($qid);
//}
// In PostgreSQL it doesn't exist

//function db_field_name($qid, $fieldno) {
///* return the name of the field number $fieldno returned from the SELECT query
// * with the identifier $qid */
//
//	return mysql_field_name($qid, $fieldno);
//}
// In PostgreSQL it doesn't exist

//function db_data_seek($qid, $row) {
///* move the database cursor to row $row on the SELECT query with the identifier
// * $qid */
//
//	if (db_num_rows($qid)) { return mysql_data_seek($qid, $row); }
//}
// In PostgreSQL it doesn't exist

function db_begin() {
	ignore_user_abort(1);
	$qid = db_query("BEGIN");
	return $qid;
}
function db_commit() {
	$qid = db_query("COMMIT");
	ignore_user_abort(0);
	return $qid;
}

function find_products($stringtsf_stripped, $case_sensitive=0, $concatenation) {

	if ($case_sensitive) {
		$l_matches_regex = "~";
	} else {
		$l_matches_regex = "~*";
	}

	$l_array_of_elements = explode(" ",$stringtsf_stripped);
	foreach($l_array_of_elements as $l_search_element){
		if ($l_search_element != "") 
			$l_search_condition.="(name $l_matches_regex '$l_search_element' OR description $l_matches_regex '$l_search_element') $concatenation ";
	}

	if ($concatenation == "OR") {
		$l_search_condition.="FALSE";
	} else {
		$l_search_condition.="TRUE";
	}

	$qid = db_query("SELECT * FROM products WHERE $l_search_condition ORDER BY name");

	return $qid;
}

function advanced_find_products($frm) {

	$l_search_condition = "";

	// Prepare for searching products with name within a limited range
	if (!empty($frm["product_name_min"]))
		$l_search_condition = "(name >= '$frm[product_name_min]')";
	if (!empty($frm[product_name_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(name <= '$frm[product_name_max]')";
	}
	
	// Prepare for searching words in the product name
	$prod_stripped = ereg_replace ("\+", "", $frm[product_name_in]);
	if (!empty($prod_stripped)) {
		$prod_concatenation = $frm[prod_concatenation];
		$prod_case_sensitive = $frm[prod_case_sensitive];
		if ($prod_case_sensitive) {
			$prod_l_matches_regex = "~";
		} else {
			$prod_l_matches_regex = "~*";
		}

		$l_array_of_elements = explode(" ",$prod_stripped);
		$prod_l_search_condition = "(";
		foreach($l_array_of_elements as $l_search_element) {
			if ($l_search_element != "") 
				$prod_l_search_condition.="(name $prod_l_matches_regex '$l_search_element') $prod_concatenation ";
		}

		if ($prod_concatenation == "OR") {
			$prod_l_search_condition.="FALSE)";
		} else {
			$prod_l_search_condition.="TRUE)";
		}
	}
	if (isset($prod_l_search_condition)) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= $prod_l_search_condition;
	}

	if (!empty($frm["brand_id"])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= " brand_id = '$frm[brand_id]' ";
	}

	// Prepare for searching products with description within a limited range
	if (!empty($frm[description_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(description >= '$frm[description_min]')";
	}
	if (!empty($frm[description_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(description <= '$frm[description_max]')";
	}

	// Prepare for searching words in the product description
	$desc_stripped = ereg_replace ("\+", "", $frm[name_in]);
	if (!empty($desc_stripped)) {
		$desc_concatenation = $frm[desc_concatenation];
		$desc_case_sensitive = $frm[desc_case_sensitive];
		if ($desc_case_sensitive) {
			$desc_l_matches_regex = "~";
		} else {
			$desc_l_matches_regex = "~*";
		}

		$l_array_of_elements = explode(" ",$desc_stripped);
		$desc_l_search_condition = "(";
		foreach($l_array_of_elements as $l_search_element) {
			if ($l_search_element != "") 
				$desc_l_search_condition.="(description $desc_l_matches_regex '$l_search_element') $desc_concatenation ";
		}

		if ($desc_concatenation == "OR") {
			$desc_l_search_condition.="FALSE)";
		} else {
			$desc_l_search_condition.="TRUE)";
		}
	}
	if (isset($desc_l_search_condition)) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= $desc_l_search_condition;
	}

	// Prepare for searching products with prices within a limited range
	if (!empty($frm[price_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(price >= '$frm[price_min]')";
	}
	if (!empty($frm[price_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(price <= '$frm[price_max]')";
	}

	// Prepare for searching products with discount within a limited range
	if (!empty($frm[discount_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(discount >= '$frm[discount_min]')";
	}
	if (!empty($frm[discount_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(discount <= '$frm[discount_max]')";
	}

	// Prepare for searching products with discount qty within a limited range
	if (!empty($frm[discqty_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(discqty >= '$frm[discqty_min]')";
	}
	if (!empty($frm[discqty_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(discqty <= '$frm[discqty_max]')";
	}

	// Prepare for searching products with weight within a limited range
	if (!empty($frm[weight_min])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(weight >= '$frm[weight_min]')";
	}
	if (!empty($frm[weight_max])) {
		if (!empty($l_search_condition))
			$l_search_condition .= " AND ";
		$l_search_condition .= "(weight <= '$frm[weight_max]')";
	}

	$qid = db_query("SELECT * FROM products WHERE $l_search_condition ORDER BY name");

	return $qid;
}

?>
