<?
/* (c) 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */
/* with contribution for the script structure 
   from categories.php (c) 2000 Ying Zhang (ying@zippydesign.com) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

$DOC_TITLE = $IVA_Management;
include("templates/header.ihtml");

switch (nvl($mode)) {
	case "add" :
		print_add_iva_form();
		break;

	case "edit" :
		if (!($id == 0))
			print_edit_iva_form($id);
		break;

	case "del" :
		if (!($id == 0))
			delete_iva($id);
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_iva($HTTP_POST_VARS["iva"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_iva($HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["newmode"] = "insert";
			$frm["iva"] = $HTTP_POST_VARS["iva"];
			$frm["submit_caption"] = $Add_IVA;
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/iva_form.ihtml");
		}
		break;

	case "update" :
		if ($id == 0)
			break;
		$errors = new Object;
		$errormsg = "";
		validate_iva($HTTP_POST_VARS["iva"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_iva($id, $HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["newmode"] = "update";
			$frm["iva"] = $HTTP_POST_VARS["iva"];
			$frm["submit_caption"] = $Save_Changes;
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/iva_form.ihtml");
		}
		break;

	case "import" :
		print_import_iva_form();
		break;

	case "update_imp" :
		if ($userfile == 'none')
			print_import_iva_form();
		else
			import_iva($userfile);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_iva_list();
		break;
}

include("templates/footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function print_add_iva_form() {
/* print a blank iva form so we can add a new iva percentage */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	/* set default values for the reset of the fields */
	$frm["newmode"] = "insert";
	$frm["iva"] = "";
	$frm["submit_caption"] = $Add_IVA;

	include("templates/iva_form.ihtml");
}

function print_edit_iva_form($id) {
/* print an iva form so we can edit the selected iva percentage */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	/* load up the information for the iva percentage */
	$qid = db_query("SELECT iva FROM iva WHERE id = '$id'");
	$frm = db_fetch_array($qid, 0);

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = $Save_Changes;

	include("templates/iva_form.ihtml");
}

function delete_iva($id) {
// delete the iva percentage specified by $id, and reset to 0
// the iva_id for all products with this iva percentage

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$qid = db_begin();

	/* select the iva percentage to be deleted */
	$qid = db_query("SELECT iva from iva WHERE id = '$id'");
	$frm = db_fetch_array ($qid, 0);

	/* delete this iva percentage */
	$qid = db_query("DELETE FROM iva WHERE id = '$id'");

	// reset to 1 the iva_id for all products with this iva_id
	$qid = db_query("
	UPDATE products SET iva_id = 1 WHERE iva_id = '$id'
	");

	$qid = db_commit();

	include("templates/iva_deleted.ihtml");
}

function insert_iva($frm) {
/* add a new iva percentage.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$qid = db_query("INSERT INTO iva (iva) VALUES ('$frm[iva]')");

	include("templates/iva_added.ihtml");
}

function update_iva($id, $frm) {
/* update the iva $id with new values.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$qid = db_query("UPDATE iva SET iva = '$frm[iva]' WHERE id = '$id'");
	include("templates/iva_updated.ihtml");
}

function print_iva_list() {
/* read all the iva percentages from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
	include ($CFG->global);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT id, iva FROM iva WHERE id > 0 ORDER BY iva");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["iva"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["iva_per_page"]) {
		$first = ($page_number-1)*$SESSION["iva_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["iva_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["iva_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["iva_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	include("templates/iva_list.ihtml");
}

function print_import_iva_form() {
/* print the import iva form so we can add/update iva percentages from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);

	/* set values for the form */
	$frm["submit_caption"] = $Import_Button_Label;
	$frm["newmode"] = "update_imp";

	include("templates/data_import.ihtml");
}

function import_iva($userfile) {
/* Import iva percentages from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);
	$errors = new Object;

	$qid = db_begin();

	$fcontents = file ($userfile);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
		/* dangerous characters quoting */
		$fldarr[0] = addslashes($fldarr[0]);

		/* ... and let's see if the iva percentage already exists ... */
		$qid = db_query("
		SELECT id FROM iva WHERE iva = '$fldarr[0]'
		");
		if (db_num_rows($qid) == 0) {
			/* ... if it doesn't exist let's create it */
			$qid = db_query("
			INSERT INTO iva (iva) VALUES ('$fldarr[0]')
			");
		}
	}

	/* Let's close the transaction */
	$qid = db_commit();
	
	/* The End */
	include("templates/data_import_end.ihtml");

}

?>
