#include "util.h"

#include <uuid.h>

#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>

static int get_random_fd()
{
	struct timeval	tv;
	static int	fd = -2;
	int		i;

	if (fd == -2) {
		gettimeofday(&tv, 0);
		fd = open("/dev/urandom", O_RDONLY);
		if (fd == -1)
			fd = open("/dev/random", O_RDONLY | O_NONBLOCK);
		srand((getpid() << 16) ^ getuid() ^ tv.tv_sec ^ tv.tv_usec);
	}
	
	gettimeofday(&tv, 0);
	for (i = (tv.tv_sec ^ tv.tv_usec) & 0x1F; i > 0; i--)
		rand();

	return fd;
}

int get_random_buffer(void *buf, size_t nbytes)
{
	int i;
	int lose_counter = 0;
	int fd = get_random_fd();

	unsigned char *cp = buf;

	if (fd >= 0) {
		while (nbytes > 0) {
			i = read(fd, cp, nbytes);
			if (i <= 0) {
				if (lose_counter++ > 16)
					break;
				continue;
			}
			nbytes -= i;
			cp += i;
			lose_counter = 0;
		}
	}

	for (i = 0; i < nbytes; i++)
	{
		*cp++ = rand() & 0xFF;
	}

	return (0);
}
