/*-------------------------------------------------------------------------
 *
 * FILE
 *    uuid_generate_random.c
 *
 * DESCRIPTION
 *    generate a random-base uuid
 *
 * Copyright (c) 2002-2003, Mike Wang <xylophone2001@hotmail.com>
 *
 *-------------------------------------------------------------------------
 */
#include "util.h"

#include <uuid.h>

int uuid_generate_random(uuid_p p)
{
	get_random_buffer(p, sizeof(uuid_t));

	p->clock_seq = (p->clock_seq & 0x3FFF) | 0x8000;
	p->time_hi_and_version = (p->time_hi_and_version & 0x0FFF) | 0x4000;
	
	return (0);
}

