<?php // $Id: stats-convert.php,v 1.11 2001/07/28 14:12:32 ciaccia Exp $ - #phpAdsNew Revision: 1.11 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/



// Include required files
require ("config.php");


// Security check
phpAds_checkAccess(phpAds_Admin);



/*********************************************************/
/* Build frameset                                        */
/*********************************************************/

if ($command == 'frame')
{
	echo "<html>";
	echo "<frameset rows='50,*' frameborder='no' border='0' framespacing='0'>";
	echo "<frame name='top' src='stats-convert.php?command=top' scrolling='no' marginwidth='0' marginheight='0' frameborder='no' noresize>";
	echo "<frame name='bottom' src='stats-convert.php?command=start' scrolling='yes' marginwidth='0' marginheight='0' frameboder='no'>";
	echo "</frameset>";
	echo "</html>";
}



/*********************************************************/
/* Build header                                          */
/*********************************************************/

if ($command == 'top')
{
	echo "<html><head>";
	echo "<link rel='stylesheet' href='interface.css'>";
	echo "</head>";
	
	echo "<body bgcolor='#000063'>";
	echo "<table width='100%' height='100%' cellpadding='0' cellspacing='0' border='0'>";
	
	if ($phpAds_name != "")
		echo "<tr><td valign='middle'><span class='phpAdsNew'>&nbsp;$phpAds_name</span></td></tr>";
	else
		echo "<tr><td valign='bottom'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src='images/logo.gif' width='163' height='34' vspace='2'></td></tr>";
	
	echo "</table>";
	echo "</body></html>";
}



/*********************************************************/
/* Build information and start button                    */
/*********************************************************/

if ($command == 'start')
{
	echo "<html><head>";
	echo "<link rel='stylesheet' href='interface.css'>";
	echo "</head><body>";
	echo "<table width='100%' cellpadding='0' cellspacing='0' border='0'>";
	echo "<tr><td height='25' colspan='3'>&nbsp;</td></tr>";
	
	echo "<tr><td><img src='images/spacer.gif' width='30'></td><td>";
	
	if ($phpAds_compact_stats)
	{
		$viewresult = db_query("SELECT COUNT(*) AS cnt FROM $phpAds_tbl_adviews");
		$viewrow = @pg_fetch_array($viewresult, 0);
		$verboseviews = $viewrow["cnt"];
		
		$clickresult = db_query("SELECT COUNT(*) AS cnt FROM $phpAds_tbl_adclicks");
		$clickrow = @pg_fetch_array($clickresult, 0);
		$verboseclicks = $clickrow["cnt"];
		
		if ($verboseviews > 0 || $verboseclicks > 0)
		{
			echo "You have enabled the compact statistics, but your old statistics are still 
				  in verbose format. As long as the verbose statistics aren't converted to compact format 
				  they will not be used while viewing these pages.<br>
				  <b>Before converting your statistics, make a backup of the database!</b><br><br>
  				  Do you want to convert your verbose statistics to the 
				  new compact format?
				 ";
			echo "<br><br>";
			echo "<a href='stats-convert.php?command=overview'><img src='images/icon-update.gif' border='0' align='absmiddle'>&nbsp;Start</a>";
		}
		else
		{
			echo "There is nothing to convert to compact stats";
		}
	}
	else
	{
		echo "You are using verbose stats, there is no need to convert anything";
	}
	
	echo "</td><td><img src='images/spacer.gif' width='30'></td></tr>";
	echo "</body></html>";
}



/*********************************************************/
/* Build overview and call to conversion routines        */
/*********************************************************/

if ($command == 'overview')
{
	if (!phpAds_convertTableExists())
	{
		// Setup a new conversion
		phpAds_convertTableCreate();
		
		$day = array();
		
		// Get views
		$overviewresult = @db_query("SELECT bannerid, count(*) as count, DATE_FORMAT(t_stamp::date, '$date_format') as date_f, DATE_FORMAT(t_stamp::date, 'YYYY-MM-DD') as date FROM $phpAds_tbl_adviews GROUP BY t_stamp::date, bannerid");
		for ($pgc = 0; $overviewrow = @pg_fetch_array($overviewresult, $pgc); $pgc++)
		{
			$day[$overviewrow['date']][$overviewrow['bannerid']]['views'] = $overviewrow['count'];
			$day[$overviewrow['date']][$overviewrow['bannerid']]['date_f'] = $overviewrow['date_f'];
		}

		// Get clicks
		$overviewresult = @db_query("SELECT bannerid, count(*) as count, DATE_FORMAT(t_stamp::date, '$date_format') as date_f, DATE_FORMAT(t_stamp::date, 'YYYY-MM-DD') as date FROM $phpAds_tbl_adclicks GROUP BY t_stamp::date, bannerid");
		for ($pgc = 0; $overviewrow = @pg_fetch_array($overviewresult, $pgc); $pgc++)
		{
			$day[$overviewrow['date']][$overviewrow['bannerid']]['clicks'] = $overviewrow['count'];
			$day[$overviewrow['date']][$overviewrow['bannerid']]['date_f'] = $overviewrow['date_f'];
		}
		
		// Loop through all days
		for (reset($day);$key=key($day);next($day))
		{
			$section_year = substr ($key, 0, 4);
			$section_month  = substr ($key, 5, 2);
			$section_day  = substr ($key, 8, 2);
			
			$begin_stamp = date ("Y-m-d 00:00:00", mktime(0, 0, 0, $section_month, $section_day, $section_year));
			$end_stamp = date ("Y-m-d 00:00:00", mktime(0, 0, 0, $section_month, $section_day, $section_year) + 86400);
			
			$banner = $day[$key];
			
			// Loop through all banners within this day
			for (reset($banner);$bkey=key($banner);next($banner))
			{
				$records = 0;
				if (isset($banner[$bkey]['views'])) $records += $banner[$bkey]['views'];
				if (isset($banner[$bkey]['clicks'])) $records += $banner[$bkey]['clicks'];
				
				// Add this banner/day to the Tasklist
				phpAds_convertAddTask($begin_stamp, $end_stamp, $records, $bkey);
			}
		}
	}
	
	
	
	// Build HTML Taskscheduler :-)
	$result = @db_query("SELECT begin_stamp, DATE_FORMAT(begin_stamp, '$date_format') as date_f, sum(records) as sum FROM phpadsconversiontemp WHERE status='waiting' GROUP BY begin_stamp");
	
	echo "<html><head>";
	echo "<link rel='stylesheet' href='interface.css'>";
	?>
		<script language='JavaScript'>
		<!--
			function StartCleanup()
			{
				document.images.cleanup.src = 'stats-convert.php?command=cleanup';
			}
		//-->
		</script>
	<?php
	echo "</head><body onLoad=\"StartCleanup();\">";
	echo "<table width='100%' cellpadding='0' cellspacing='0' border='0'>";
	
	for ($pgc = 0; $task = @pg_fetch_array($result, $pgc); $pgc++)
	{
		echo "<tr>";
		echo "<td height='25'>&nbsp;&nbsp;<img src='stats-convert.php?command=convert&id=".urlencode($task['begin_stamp'])."' width='16' height='16'></td>";
		echo "<td>".$task['date_f']."</td>";
		echo "<td>".$task['sum']." records to convert...</td>";
		echo "</tr>";
		
		echo "<tr><td colspan='3'><img src='images/break-l.gif' width='100%' height='1'></td></tr>";
	}
	
	
	echo "<tr>";
	echo "<td height='25'>&nbsp;&nbsp;<img name='cleanup' src='images/spacer.gif' width='16' height='16'></td>";
	echo "<td>&nbsp;</td>";
	echo "<td>Cleaning up...</td>";
	echo "</tr>";
	
	echo "<tr><td colspan='3'><img src='images/break-l.gif' width='100%' height='1'></td></tr>";
	
	echo "</table>";
	echo "</body></html>";
}



/*********************************************************/
/* Convert verbose stats to compact stats                */
/*********************************************************/

if ($command == 'convert')
{
	// don't let the user interupt with this process!
	// timeout this script in 10 minutes for safety
	if (!get_cfg_var ('safe_mode'))
	{
		set_time_limit (600);
		ignore_user_abort(1);
	}
	
	// Assume something went wrong until
	// it is certain everything went alright
	$error = true;
	
	if (isset($id) && $id != '')
	{
		// Get a list of waiting tasks for this day
		$result = @db_query("SELECT * FROM phpadsconversiontemp WHERE begin_stamp='$id' AND status='waiting'");
		
		if (@pg_numrows($result) > 0)
		{
			// Get next task
			for ($pgc = 0; $task = @pg_fetch_array($result, $pgc); $pgc++)
			{
				$views = 0;
				$clicks = 0;
				
				$begintime 	= $task['begin_stamp'];
				$endtime 	= $task['end_stamp'];
				$bannerid 	= $task['bannerid'];
				$id		 	= $task['conversionid'];
				
				$day = substr($begintime, 0, 4)."-".substr($begintime, 5, 2)."-".substr($begintime, 8, 2);
				
				// Get views for this task
				$countresult = @db_query("SELECT count(*) as count FROM $phpAds_tbl_adviews WHERE bannerid='$bannerid' AND t_stamp >= '$begintime' AND t_stamp < '$endtime'");
				if ($countrow = @pg_fetch_array($countresult, 0))
				{
					$views = $countrow['count'];
				}
				
				// Get clicks for this task
				$countresult = @db_query("SELECT count(*) as count FROM $phpAds_tbl_adclicks WHERE bannerid='$bannerid' AND t_stamp >= '$begintime' AND t_stamp < '$endtime'"); 
				if ($countrow = @pg_fetch_array($countresult, 0))
				{
					$clicks = $countrow['count'];
				}
				
				// Check for clicks or views to convert
				if ($clicks > 0 || $views > 0)
				{
					// Check for existing compact stats for this task
					$checkresult = @db_query("SELECT count(*) as count FROM $phpAds_tbl_adstats WHERE day='$day' AND bannerid='$bannerid'");
					$checkrow = @pg_fetch_array ($checkresult, 0);
					
					if (isset($checkrow['count']) && $checkrow['count'] > 0)
					{
						// Add clicks / views to existing compact stats
						$updateresult = @db_query("UPDATE $phpAds_tbl_adstats SET clicks=clicks+$clicks, views=views+$views WHERE day='$day' AND bannerid='$bannerid'");
						
						if (@pg_cmdtuples($updateresult) > 0)
						{
							// Everything went alright
							phpAds_convertSetStatus ($id, 'finished');
							$error = false;
						}
						else
							phpAds_convertSetStatus ($id, 'error');
					}
					else
					{
						// Insert a new record to the compact stats
						$updateresult = @db_query("INSERT INTO $phpAds_tbl_adstats (bannerid, day, clicks, views) VALUES('$bannerid', '$day', $clicks, $views)");
						
						if (@pg_cmdtuples($updateresult) > 0)
						{
							// Everything went alright
							phpAds_convertSetStatus ($id, 'finished');
							$error = false;
						}
						else
							phpAds_convertSetStatus ($id, 'error');
					}
				}
			}
		}
	}
	
	
	if ($error)
	{
		// Show X
		header ("Content-type: image/gif");
		include ("../nocache.inc.php");
		$image = @fopen ('images/delete.gif', 'r');
		fpassthru ($image);
		fclose ($image);
	}
	else
	{
		// Show V
		header ("Content-type: image/gif");
		include ("../nocache.inc.php");
		$image = @fopen ('images/save.gif', 'r');
		fpassthru ($image);
		fclose ($image);
	}
}



/*********************************************************/
/* Cleanup mess                                          */
/*********************************************************/

if ($command == 'cleanup')
{
	if (!get_cfg_var ('safe_mode'))
	{
		set_time_limit (600);
		ignore_user_abort(1);
	}
	
	$error = true;
	$status = array();
	
//	db_query("BEGIN");
	
	$result = @db_query("select status, count(*) as count from phpadsconversiontemp group by status");
	for ($pgc = 0; $row = @pg_fetch_array($result, $pgc); $pgc++)
	{
		$status[$row['status']] = $row['count'];
	}
	
	if (sizeof($status) == 1 && isset ($status['finished']))
	{
		// Only one type of status and status = finished
		// Clean up whole table
		@db_query("delete from $phpAds_tbl_adviews");
		phpAds_convertTableDrop();
		$error = false;
	}
	elseif (sizeof($status) == 2 && isset ($status['finished']) && isset ($status['error']))
	{
		$result = @db_query("select * from phpadsconversiontemp where status='error'");
		
		$where = "";
		
		for ($pgc = 0; $error = @pg_fetch_array($result, $pgc); $pgc++)
		{
			$begintime 	= $error['begin_stamp'];
			$endtime 	= $error['end_stamp'];
			$bannerid 	= $error['bannerid'];
			
			if ($where == "")
			{
				$where .= "(bannerid='$bannerid' AND t_stamp >= $begintime AND t_stamp < $endtime)";
			}
			else
			{
				$where .= " OR (bannerid='$bannerid' AND t_stamp >= $begintime AND t_stamp < $endtime)";
			}
		}
		
		if ($where != "")
			$where = "WHERE NOT ($where)";
		
		@db_query("DELETE FROM $phpAds_tbl_adviews $where");
		@db_query("DELETE FROM $phpAds_tbl_adclicks $where");
		
		$error = false;
	}
	
	if ($error)
	{
//		db_query("ROLLBACK");
		header ("Content-type: image/gif");
		include ("../nocache.inc.php");
		$image = @fopen ('images/delete.gif', 'r');
		fpassthru ($image);
		fclose ($image);
	}
	else
	{
//		db_query("COMMIT");
		header ("Content-type: image/gif");
		include ("../nocache.inc.php");
		$image = @fopen ('images/save.gif', 'r');
		fpassthru ($image);
		fclose ($image);
	}
}


function phpAds_convertTableExists()
{
	$available = false;
	$result = @db_query("SELECT * FROM pg_tables WHERE tablename = 'phpadsconversiontemp'");
	
	return (pg_numrows($result) ? true : false);
}


function phpAds_convertTableCreate()
{
	$result = @db_query("
		CREATE TABLE phpadsconversiontemp (
		   conversionid serial,
		   begin_stamp timestamp,
		   end_stamp timestamp,
		   status varchar(32) DEFAULT 'waiting',
		   records int4,
		   bannerid int8,
		   PRIMARY KEY (conversionid)
		)
	");
	
	echo pg_errormessage($GLOBALS["phpAds_db_link"]);
}


function phpAds_convertTableDrop()
{
	$result = @db_query("DROP TABLE phpadsconversiontemp");
	$result = @db_query("DROP SEQUENCE phpadsconversi_conversionid_seq");
}


function phpAds_convertAddTask($begin_stamp, $end_stamp, $records, $bannerid)
{
	$result = @db_query("
		INSERT INTO 
			phpadsconversiontemp (begin_stamp, end_stamp, bannerid, records)
		VALUES ('$begin_stamp', '$end_stamp', '$bannerid', $records)
	");
}

function phpAds_convertSetStatus ($id, $status)
{
	$result = @db_query("
		UPDATE 
			phpadsconversiontemp
		SET
		   	status = '$status'
		WHERE
			conversionid = $id
	");
}

?>
