/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.deploy;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class Deployer {
    private static final int CMD_AMBIGUOUS = -2;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_UNINSTALL = 0;
    private static final int CMD_INSTALL = 1;
    private static final int CMD_REINSTALL = 2;
    private static final int CMD_USER = 3;
    private static final int CMD_PASSWORD = 4;
    private static final int CMD_DATABASE = 5;
    private static final int CMD_HOSTNAME = 6;
    private static final int CMD_PORT = 7;
    private static final int CMD_WINDOWS = 8;
    private final Connection m_connection;
    private static final ArrayList s_commands = new ArrayList();

    private static final int getCommand(String string) {
        int n = s_commands.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!((String)s_commands.get(i)).startsWith(string)) continue;
            if (n2 != -1) {
                return -2;
            }
            n2 = i;
        }
        return n2;
    }

    public static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("usage: java -jar deploy.jar");
        printStream.println("    {-install | -uninstall | -reinstall}");
        printStream.println("    [ -host <hostName>     ]    # default is localhost");
        printStream.println("    [ -port <portNumber>   ]    # default is blank");
        printStream.println("    [ -database <database> ]    # default is name of current user");
        printStream.println("    [ -user <userName>     ]    # default is name of current user");
        printStream.println("    [ -password <password> ]    # default is no password");
        printStream.println("    [ -windows ]                # If the server is on a Windows machine");
    }

    public static void main(String[] stringArray) {
        Object object;
        String string;
        String string2 = "org.postgresql.Driver";
        String string3 = "localhost";
        String string4 = string = System.getProperty("user.name", "postgres");
        String string5 = "postgresql";
        String string6 = null;
        String string7 = null;
        boolean bl = true;
        int n = -1;
        int n2 = stringArray.length;
        block11: for (int i = 0; i < n2; ++i) {
            object = stringArray[i];
            if (((String)object).length() < 2) {
                Deployer.printUsage();
                return;
            }
            if (((String)object).charAt(0) != '-') continue;
            int n3 = Deployer.getCommand(((String)object).substring(1));
            switch (n3) {
                case 0: 
                case 1: 
                case 2: {
                    if (n != -1) {
                        Deployer.printUsage();
                        return;
                    }
                    n = n3;
                    continue block11;
                }
                case 3: {
                    if (++i < n2 && (string = stringArray[i]).length() > 0 && string.charAt(0) != '-') continue block11;
                    Deployer.printUsage();
                    return;
                }
                case 4: {
                    if (++i < n2 && (string6 = stringArray[i]).length() > 0 && string6.charAt(0) != '-') continue block11;
                    Deployer.printUsage();
                    return;
                }
                case 5: {
                    if (++i < n2 && (string4 = stringArray[i]).length() > 0 && string4.charAt(0) != '-') continue block11;
                    Deployer.printUsage();
                    return;
                }
                case 6: {
                    if (++i < n2 && (string3 = stringArray[i]).length() > 0 && string3.charAt(0) != '-') continue block11;
                    Deployer.printUsage();
                    return;
                }
                case 7: {
                    if (++i < n2 && (string7 = stringArray[i]).length() > 0 && string7.charAt(0) != '-') continue block11;
                    Deployer.printUsage();
                    return;
                }
                case 8: {
                    bl = false;
                    continue block11;
                }
                default: {
                    Deployer.printUsage();
                    return;
                }
            }
        }
        if (n == -1) {
            Deployer.printUsage();
            return;
        }
        try {
            Class.forName(string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("jdbc:");
            stringBuffer.append(string5);
            stringBuffer.append("://");
            stringBuffer.append(string3);
            if (string7 != null) {
                stringBuffer.append(':');
                stringBuffer.append(string7);
            }
            stringBuffer.append('/');
            stringBuffer.append(string4);
            object = DriverManager.getConnection(stringBuffer.toString(), string, string6);
            Deployer deployer = new Deployer((Connection)object);
            if (n == 0 || n == 2) {
                deployer.dropSQLJSchema();
            }
            if (n == 1 || n == 2) {
                deployer.createSQLJSchema();
                deployer.initJavaHandler(bl);
                deployer.initializeSQLJSchema();
            }
            object.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Deployer(Connection connection) {
        this.m_connection = connection;
    }

    public void dropSQLJSchema() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        statement.execute("DROP SCHEMA sqlj CASCADE");
        try {
            statement.execute("DROP LANGUAGE java CASCADE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
    }

    public void createSQLJSchema() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        statement.execute("CREATE SCHEMA sqlj");
        statement.close();
    }

    public void initializeSQLJSchema() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        statement.execute("CREATE TABLE sqlj.jar_repository(\tjarId\t\tSERIAL PRIMARY KEY,\tjarName\t\tVARCHAR(100) UNIQUE NOT NULL,   jarOrigin   VARCHAR(500) NOT NULL,   deploymentDesc INT)");
        statement.execute("CREATE TABLE sqlj.jar_entry(   entryId     SERIAL PRIMARY KEY,\tentryName\tVARCHAR(200) NOT NULL,\tjarId\t\tINT NOT NULL REFERENCES sqlj.jar_repository ON DELETE CASCADE,   entryImage  BYTEA NOT NULL,   UNIQUE(jarId, entryName))");
        statement.execute("ALTER TABLE sqlj.jar_repository   ADD FOREIGN KEY (deploymentDesc) REFERENCES sqlj.jar_entry ON DELETE SET NULL");
        statement.execute("CREATE TABLE sqlj.classpath_entry(\tschemaName\tVARCHAR(30) NOT NULL,\tordinal\t\tINT2 NOT NULL,\tjarId\t\tINT NOT NULL REFERENCES sqlj.jar_repository ON DELETE CASCADE,\tPRIMARY KEY(schemaName, ordinal))");
        statement.execute("CREATE FUNCTION sqlj.install_jar(VARCHAR, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.installJar'\tLANGUAGE java");
        statement.execute("CREATE FUNCTION sqlj.replace_jar(VARCHAR, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.replaceJar'\tLANGUAGE java");
        statement.execute("CREATE FUNCTION sqlj.remove_jar(VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.removeJar'\tLANGUAGE java");
        statement.execute("CREATE FUNCTION sqlj.set_classpath(VARCHAR, VARCHAR) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.setClassPath'\tLANGUAGE java");
        statement.execute("CREATE FUNCTION sqlj.get_classpath(VARCHAR) RETURNS VARCHAR\tAS 'org.postgresql.pljava.management.Commands.getClassPath'\tLANGUAGE java STABLE");
        statement.close();
    }

    public void initJavaHandler(boolean bl) throws SQLException {
        Statement statement = this.m_connection.createStatement();
        statement.execute("CREATE FUNCTION sqlj.java_call_handler() RETURNS language_handler AS '" + (bl ? "lib" : "") + "pljava'" + " LANGUAGE C");
        statement.execute("CREATE LANGUAGE java HANDLER sqlj.java_call_handler");
        statement.close();
    }

    static {
        s_commands.add(0, "uninstall");
        s_commands.add(1, "install");
        s_commands.add(2, "reinstall");
        s_commands.add(3, "user");
        s_commands.add(4, "password");
        s_commands.add(5, "database");
        s_commands.add(6, "host");
        s_commands.add(7, "port");
        s_commands.add(8, "windows");
    }
}

