/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.test;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class Tester {
    private static final int CMD_AMBIGUOUS = -2;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_USER = 0;
    private static final int CMD_PASSWORD = 1;
    private static final int CMD_DATABASE = 2;
    private static final int CMD_HOSTNAME = 3;
    private static final int CMD_PORT = 4;
    private final Connection m_connection;
    private static final ArrayList s_commands = new ArrayList();

    private static final int getCommand(String string) {
        int n = s_commands.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!((String)s_commands.get(i)).startsWith(string)) continue;
            if (n2 != -1) {
                return -2;
            }
            n2 = i;
        }
        return n2;
    }

    public static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("usage: java -jar deploy.jar");
        printStream.println("    {-install | -uninstall | -reinstall}");
        printStream.println("    [ -host <hostName>     ]    # default is localhost");
        printStream.println("    [ -port <portNubmer>   ]    # default is blank");
        printStream.println("    [ -database <database> ]    # default is postgres");
        printStream.println("    [ -user <userName>     ]    # default is postgres");
        printStream.println("    [ -password <password> ]    # default is no password");
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = "org.postgresql.Driver";
        String string2 = "localhost";
        String string3 = null;
        String string4 = "postgres";
        String string5 = "postgres";
        String string6 = "postgresql";
        String string7 = null;
        int n = stringArray.length;
        block9: for (int i = 0; i < n; ++i) {
            object = stringArray[i];
            if (((String)object).length() < 2) {
                Tester.printUsage();
                return;
            }
            if (((String)object).charAt(0) != '-') continue;
            int n2 = Tester.getCommand(((String)object).substring(1));
            switch (n2) {
                case 0: {
                    if (++i < n && (string5 = stringArray[i]).length() > 0 && string5.charAt(0) != '-') continue block9;
                    Tester.printUsage();
                    return;
                }
                case 1: {
                    if (++i < n && (string7 = stringArray[i]).length() > 0 && string7.charAt(0) != '-') continue block9;
                    Tester.printUsage();
                    return;
                }
                case 2: {
                    if (++i < n && (string4 = stringArray[i]).length() > 0 && string4.charAt(0) != '-') continue block9;
                    Tester.printUsage();
                    return;
                }
                case 3: {
                    if (++i < n && (string2 = stringArray[i]).length() > 0 && string2.charAt(0) != '-') continue block9;
                    Tester.printUsage();
                    return;
                }
                case 4: {
                    if (++i < n && (string3 = stringArray[i]).length() > 0 && string3.charAt(0) != '-') continue block9;
                    Tester.printUsage();
                    return;
                }
                default: {
                    Tester.printUsage();
                    return;
                }
            }
        }
        try {
            Class.forName(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("jdbc:");
            stringBuffer.append(string6);
            stringBuffer.append("://");
            stringBuffer.append(string2);
            if (string3 != null) {
                stringBuffer.append(':');
                stringBuffer.append(string3);
            }
            stringBuffer.append('/');
            stringBuffer.append(string4);
            object = DriverManager.getConnection(stringBuffer.toString(), string5, string7);
            Tester tester = new Tester((Connection)object);
            tester.testParameters();
            tester.testInsertUsernameTrigger();
            tester.testModdatetimeTrigger();
            tester.testSPIActions();
            tester.testComplexReturn();
            tester.testSetReturn();
            tester.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Tester(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("SET search_path TO javatest,public");
        statement.close();
        this.m_connection = connection;
    }

    public void close() throws SQLException {
        this.m_connection.close();
    }

    public void testParameters() throws SQLException {
        this.testTimestamp();
        this.testInt();
    }

    public void testSPIActions() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        statement.execute("INSERT INTO employees1 VALUES(1, 'Calvin Forrester', 10000)");
        statement.execute("INSERT INTO employees1 VALUES(2, 'Edwin Archer', 20000)");
        statement.execute("INSERT INTO employees1 VALUES(3, 'Rebecka Shawn', 30000)");
        statement.execute("INSERT INTO employees1 VALUES(4, 'Priscilla Johnson', 25000)");
        statement.execute("SELECT transferPeople(20000)");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM employees2");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            String string = resultSet.getString(2);
            int n2 = resultSet.getInt(3);
            System.out.println("Id = \"" + n + "\", name = \"" + string + "\", salary = \"" + n2 + "\"");
        }
        resultSet.close();
    }

    public void testComplexReturn() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT complexReturnToString(complexReturnExample(1, 5))");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            System.out.println(string);
        }
    }

    public void testSetReturn() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT base, incbase, ctime FROM setReturnExample(1, 5)");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            int n2 = resultSet.getInt(2);
            Timestamp timestamp = resultSet.getTimestamp(3);
            System.out.println("Base = \"" + n + "\", incbase = \"" + n2 + "\", ctime = \"" + timestamp + "\"");
        }
    }

    public void testModdatetimeTrigger() throws SQLException {
        Timestamp timestamp;
        String string;
        int n;
        Statement statement = this.m_connection.createStatement();
        statement.execute("INSERT INTO mdt VALUES (1, 'first')");
        statement.execute("INSERT INTO mdt VALUES (2, 'second')");
        statement.execute("INSERT INTO mdt VALUES (3, 'third')");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM mdt");
        while (resultSet.next()) {
            n = resultSet.getInt(1);
            string = resultSet.getString(2);
            timestamp = resultSet.getTimestamp(3);
            System.out.println("Id = \"" + n + "\", idesc = \"" + string + "\", moddate = \"" + timestamp + "\"");
        }
        resultSet.close();
        statement.execute("UPDATE mdt SET id = 4 WHERE id = 1");
        statement.execute("UPDATE mdt SET id = 5 WHERE id = 2");
        statement.execute("UPDATE mdt SET id = 6 WHERE id = 3");
        resultSet = statement.executeQuery("SELECT * FROM mdt");
        while (resultSet.next()) {
            n = resultSet.getInt(1);
            string = resultSet.getString(2);
            timestamp = resultSet.getTimestamp(3);
            System.out.println("Id = \"" + n + "\", idesc = \"" + string + "\", moddate = \"" + timestamp + "\"");
        }
        resultSet.close();
        statement.close();
    }

    public void testInsertUsernameTrigger() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        statement.execute("INSERT INTO username_test VALUES ('nothing', 'thomas')");
        statement.execute("INSERT INTO username_test VALUES ('null', null)");
        statement.execute("INSERT INTO username_test VALUES ('empty string', '')");
        statement.execute("INSERT INTO username_test VALUES ('space', ' ')");
        statement.execute("INSERT INTO username_test VALUES ('tab', '\t')");
        statement.execute("INSERT INTO username_test VALUES ('name', 'name')");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM username_test");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            System.out.println("Name = \"" + string + "\", username = \"" + string2 + "\"");
        }
        resultSet.close();
        statement.close();
    }

    public void testTimestamp() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT java_getTimestamp(), java_getTimestamptz()");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("Timestamp = " + resultSet.getTimestamp(1) + ", Timestamptz = " + resultSet.getTimestamp(2));
        }
        resultSet.close();
        statement.execute("SELECT java_print(current_date)");
        statement.execute("SELECT java_print(current_time)");
        statement.execute("SELECT java_print(current_timestamp)");
        statement.close();
    }

    public void testInt() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT java_addOne(java_addOne(54)), nullOnEven(1), nullOnEven(2)");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("54 + 2 = " + resultSet.getInt(1));
            int n = resultSet.getInt(2);
            System.out.println("nullOnEven(1) = " + (resultSet.wasNull() ? "null" : Integer.toString(n)));
            n = resultSet.getInt(3);
            System.out.println("nullOnEven(2) = " + (resultSet.wasNull() ? "null" : Integer.toString(n)));
        }
        resultSet.close();
        statement.close();
    }

    static {
        s_commands.add(0, "user");
        s_commands.add(1, "password");
        s_commands.add(2, "database");
        s_commands.add(3, "host");
        s_commands.add(4, "port");
    }
}

