
/* Module:          environ.c
 *
 * Description:     This module contains routines related to 
 *                  the environment, such as storing connection handles,
 *                  and returning errors.
 *
 * Classes:         EnvironmentClass (Functions prefix: "EN_")
 *
 * API functions:   None
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */
#include "driver.h"


/* The one instance of the handles */
ConnectionClass *conns[MAX_CONNECTIONS];

/*********************************************************************/
/*
 * EnvironmentClass implementation
 */



EnvironmentClass *EN_Constructor(void)
{
	EnvironmentClass *rv;

    rv = (EnvironmentClass *) malloc(sizeof(EnvironmentClass));
    if( rv)
	{
		rv->errormsg = 0;
		rv->errornumber = 0;
	}

    return rv;
}


char EN_Destructor(EnvironmentClass *self)
{
	int lf;
	char rv = 1;

	mylog("in EN_Destructor, self=%u\n", self);

	/* the error messages are static strings distributed throughout */
	/* the source--they should not be freed */

	/* Free any connections belonging to this environment */
	for (lf = 0; lf < MAX_CONNECTIONS; lf++)
	{
		if (conns[lf] && conns[lf]->henv == self)
		{

			rv = rv && CC_Destructor(conns[lf]);
		}
	}

	mylog("exit EN_Destructor: rv = %d\n", rv);
	return rv;
}

char EN_get_error(EnvironmentClass *self, int *number, char **message)
{
	if(self && self->errormsg && self->errornumber)
	{
		*message = self->errormsg;
		*number = self->errornumber;
		self->errormsg = 0;
		self->errornumber = 0;
		return 1;
	} 
	else 
	{
		return 0;
	}
}

char EN_add_connection(EnvironmentClass *self, ConnectionClass *conn)
{
	int i;

	mylog("EN_add_connection: self = %u, conn = %u\n", self, conn);

	for (i = 0; i < MAX_CONNECTIONS; i++)
	{
		if ( ! conns[i])
		{
			conn->henv = self;
			conns[i] = conn;

			mylog("       added at i =%d, conn->henv = %u, conns[i]->henv = %u\n", i, conn->henv, conns[i]->henv);

			return TRUE;
		}
	}

	return FALSE;
}

char EN_remove_connection(EnvironmentClass *self, ConnectionClass *conn)
{
	int i;

	for (i = 0; i < MAX_CONNECTIONS; i++)
	{
		if (conns[i] == conn && conns[i]->status != CONN_EXECUTING)
		{
			conns[i] = NULL;
			return TRUE;
		}
	}

	return FALSE;
}

void EN_log_error(char *func, char *desc, EnvironmentClass *self)
{
	if (self)
	{
		qlog("ENVIRON ERROR: func=%s, desc='%s', errnum=%d, errmsg='%s'\n", func, desc, self->errornumber, self->errormsg);
	}
	else
	{
		qlog("INVALID ENVIRON HANDLE ERROR: func=%s, desc='%s'\n", func, desc);
	}
}
