/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public abstract class MatchingTask
extends Task {
    protected boolean useDefaultExcludes = true;
    protected FileSet fileset = new FileSet();

    public void setProject(Project project) {
        super.setProject(project);
        this.fileset.setProject(project);
    }

    public PatternSet.NameEntry createInclude() {
        return this.fileset.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        return this.fileset.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        return this.fileset.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        return this.fileset.createExcludesFile();
    }

    public PatternSet createPatternSet() {
        return this.fileset.createPatternSet();
    }

    public void setIncludes(String includes) {
        this.fileset.setIncludes(includes);
    }

    public void XsetItems(String itemString) {
        this.log("The items attribute is deprecated. Please use the includes attribute.", 1);
        if (itemString == null || itemString.equals("*") || itemString.equals(".")) {
            this.createInclude().setName("**");
        } else {
            StringTokenizer tok = new StringTokenizer(itemString, ", ");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken().trim();
                if (pattern.length() <= 0) continue;
                this.createInclude().setName(pattern + "/**");
            }
        }
    }

    public void setExcludes(String excludes) {
        this.fileset.setExcludes(excludes);
    }

    public void XsetIgnore(String ignoreString) {
        this.log("The ignore attribute is deprecated.Please use the excludes attribute.", 1);
        if (ignoreString != null && ignoreString.length() > 0) {
            StringTokenizer tok = new StringTokenizer(ignoreString, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createExclude().setName("**/" + tok.nextToken().trim() + "/**");
            }
        }
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    protected DirectoryScanner getDirectoryScanner(File baseDir) {
        this.fileset.setDir(baseDir);
        this.fileset.setDefaultexcludes(this.useDefaultExcludes);
        return this.fileset.getDirectoryScanner(this.project);
    }

    public void setIncludesfile(File includesfile) {
        this.fileset.setIncludesfile(includesfile);
    }

    public void setExcludesfile(File excludesfile) {
        this.fileset.setExcludesfile(excludesfile);
    }
}

