-- /site/closed_auctions/closed_auction[price/text()>=40.0]/price

SELECT
    xn4.docid,
    xn4.id
FROM
    xml_path xp3,
    xml_node xn3,
    xml_path p1_xp4,
    xml_node p1_xn4,
    xml_node xn4,
    xml_tag xt4
WHERE 
    (
    (xp3.pathexp = '#/site#/closed_auctions#/closed_auction') AND
    xn3.pathid = xp3.pathid AND
    p1_xp4.pathexp = (xp3.pathexp || '#/price#/text()') AND
    (
     p1_xn4.pathid = p1_xp4.pathid AND
    _int_flagment(p1_xn4.dewey,xn3.dewey) AND
    (vchar2real(p1_xn4.value) >= 40.0)
    ) AND
    xn4.parent = xn3.id AND
    (xn4.kind > 0 AND xn4.kind < 5) AND
    xt4.tagid = xn4.tagid AND
    xt4.name = 'price'
    )

/*
QUERY PLAN
Nested Loop  (cost=1.93..4705.32 rows=347 width=298) (actual time=24.40..11940.68 rows=670 loops=1)
  Join Filter: _int_flagment("inner".dewey, "outer".dewey)
  ->  Hash Join  (cost=1.93..2315.91 rows=6 width=239) (actual time=0.78..344.41 rows=975 loops=1)
        Hash Cond: ("outer".tagid = "inner".tagid)
        ->  Nested Loop  (cost=0.00..2311.59 rows=463 width=235) (actual time=0.48..305.46 rows=16575 loops=1)
              ->  Nested Loop  (cost=0.00..395.86 rows=500 width=219) (actual time=0.34..13.94 rows=975 loops=1)
                    ->  Nested Loop  (cost=0.00..11.07 rows=1 width=156) (actual time=0.30..0.31 rows=1 loops=1)
                          ->  Index Scan using xml_path_exp on xml_path xp3  (cost=0.00..5.53 rows=1 width=78) (actual time=0.20..0.21 rows=1 loops=1)
                                Index Cond: (pathexp = '#/site#/closed_auctions#/closed_auction'::character varying)
                          ->  Index Scan using xml_path_exp on xml_path p1_xp4  (cost=0.00..5.53 rows=1 width=78) (actual time=0.07..0.08 rows=1 loops=1)
                                Index Cond: (p1_xp4.pathexp = ("outer".pathexp || '#/price#/text()'::character varying))
                    ->  Index Scan using xml_node_pathid on xml_node xn3  (cost=0.00..371.91 rows=1030 width=63) (actual time=0.03..7.24 rows=975 loops=1)
                          Index Cond: (xn3.pathid = "outer".pathid)
              ->  Index Scan using xml_node_parent on xml_node xn4  (cost=0.00..3.63 rows=16 width=16) (actual time=0.03..0.17 rows=17 loops=975)
                    Index Cond: (xn4.parent = "outer".id)
                    Filter: ((kind > 0) AND (kind < 5))
        ->  Hash  (cost=1.93..1.93 rows=1 width=4) (actual time=0.23..0.23 rows=0 loops=1)
              ->  Seq Scan on xml_tag xt4  (cost=0.00..1.93 rows=1 width=4) (actual time=0.22..0.22 rows=1 loops=1)
                    Filter: (name = 'price'::character varying)
  ->  Index Scan using xml_node_pathid on xml_node p1_xn4  (cost=0.00..377.06 rows=343 width=59) (actual time=0.03..10.17 rows=670 loops=975)
        Index Cond: (p1_xn4.pathid = "outer".pathid)
        Filter: (vchar2real(value) >= 40::double precision)
Total runtime: 11942.17 msec
*/
