#!/bin/sh
 
# default setting
PGSRC=/usr/local/src/postgres/postgresql-7.4beta3

# check user
if [ `id -u` -ne 0 ];then
	echo 'This command in only executed by root'
    exit 1
fi

echo
echo '----- Input your postgres src dirname -----'
echo "default is setted to.. ${PGSRC}"
echo 'press just enter to start with default setting.'
echo
echo 'please input > ' 
read INPUT

if [ -n "$INPUT" ]; then
	echo "postgres src directory is setted to ${INPUT}"
	PGSRC=$INPUT
else
	echo 'continue with default setting..'
fi

if [ ! -d "$PGSRC" ]; then
	echo
	echo "postgres src directory ${PGSRC} was not found."
	echo 'you have to specify the valid path to pgsrc dir.'
	echo
	exit 1;
fi

echo
echo "PGSRC is setted to ${PGSRC}"
echo 'setting is ok ? continue setting ?'
select input in yes no
do
	case $input in
	    'yes')
			break
			;;
	    'no')
	    	echo
	        echo 'quit'
	        exit 1;
	        break
	        ;;
	    *)
	        echo 'input argument is invalid'
	        echo 'please choose number.'
	        ;;
	esac
done

TARGET=$PGSRC/contrib/intarray

echo
echo 'mv old intarray to intarray.old'
rm -rf ${PGSRC}/contrib/intarray.old
mv -v ${PGSRC}/contrib/intarray ${PGSRC}/contrib/intarray.old

echo
echo 'now extracting..'
tar xzf intarray.tar.gz
echo

echo "mv new intarray to ${PGSRC}/contrib"
mv intarray ${PGSRC}/contrib
echo

echo 'prepared !'

sleep 3

echo
echo 'start setting database'
echo
./create.sh ${TARGET}

echo 'finish !'