/**
 - _int_add.sql,v 1.1 2003/07/17 14:10:45 myui Exp
 */


--
-- Create Function of Int4 arrays for XPath
--

-- Adjust this setting to control where the operators, functions, and
-- opclasses get created.
SET search_path = public;
SET autocommit TO 'on';

-- _int_child
--DROP FUNCTION _int_child(_int4, _int4);
CREATE or REPLACE FUNCTION _int_child(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_child(_int4, _int4) IS 'child';

-- _int_descendant
--DROP FUNCTION _int_descendant(_int4, _int4);
CREATE or REPLACE FUNCTION _int_descendant(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_descendant(_int4, _int4) IS 'descendant';

-- _int_descendant-or-self
--DROP FUNCTION _int_descendant_or_self(_int4, _int4);

CREATE or REPLACE FUNCTION _int_descendant_or_self(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_descendant_or_self(_int4, _int4) IS 'descendant-or-self';

-- _int_following_sibling
--DROP FUNCTION _int_following_sibling(_int4, _int4);

CREATE or REPLACE FUNCTION _int_following_sibling(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_following_sibling(_int4, _int4) IS 'following-sibling';

-- _int_following
--DROP FUNCTION _int_following(_int4, _int4);

CREATE or REPLACE FUNCTION _int_following(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_following(_int4, _int4) IS 'following';

-- _int_parent
--DROP FUNCTION _int_parent(_int4, _int4);

CREATE or REPLACE FUNCTION _int_parent(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_parent(_int4, _int4) IS 'parent';

-- _int_ancestor
--DROP FUNCTION _int_ancestor(_int4, _int4);

CREATE or REPLACE FUNCTION _int_ancestor(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_ancestor(_int4, _int4) IS 'ancestor';

-- _int_ancestor-or-self
--DROP FUNCTION _int_ancestor_or_self(_int4, _int4);

CREATE or REPLACE FUNCTION _int_ancestor_or_self(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_ancestor_or_self(_int4, _int4) IS 'ancestor-or-self';

-- _int_preceding
--DROP FUNCTION _int_preceding(_int4, _int4);

CREATE or REPLACE FUNCTION _int_preceding(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_preceding(_int4, _int4) IS 'preceding';

-- _int_preceding_sibling
--DROP FUNCTION _int_preceding_sibling(_int4, _int4);

CREATE or REPLACE FUNCTION _int_preceding_sibling(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_preceding_sibling(_int4, _int4) IS 'preceding-sibling';

-- last
--DROP FUNCTION last(_int4);

CREATE or REPLACE FUNCTION last(_int4) RETURNS int4
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION last(_int4) IS 'extract last value of int array';

-- nextSibling
CREATE or REPLACE FUNCTION nextSibling(_int4) RETURNS _int4
	AS '$libdir/_int', 'next_sibling' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION nextSibling(_int4) IS 'calculate next sibling';

-- previousSibling
CREATE or REPLACE FUNCTION previousSibling(_int4) RETURNS _int4
	AS '$libdir/_int', 'previous_sibling' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION previousSibling(_int4) IS 'calculate previous sibling';

-- _int_to_numstr
--DROP FUNCTION _int_to_numstr(_int4);

CREATE or REPLACE FUNCTION _int_to_numstr(_int4) RETURNS text
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_to_numstr(_int4) IS '_int4 to num_string';

-- _int_dependant
--DROP FUNCTION _int_dependant(_int4, _int4);

CREATE or REPLACE FUNCTION _int_dependant(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_dependant(_int4, _int4) IS 'dependant';

-- _int_flagment
--DROP FUNCTION _int_flagment(_int4, _int4);

CREATE or REPLACE FUNCTION _int_flagment(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_flagment(_int4, _int4) IS 'flagment';

CREATE or REPLACE FUNCTION _int_vdim(_int4, int4) RETURNS INTEGER
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_vdim(_int4, int4) IS 'get nth value of int array';

-- _int_ndim_eq
--DROP FUNCTION _int_ndim_eq(_int4, int4, int4);

CREATE or REPLACE FUNCTION _int_ndim_eq(_int4, int4, int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_ndim_eq(_int4, int4, int4) IS 'nth array equals';

---------------------------------------

-- _int_ge
-- DROP FUNCTION _int_ge(_int4,_int4);

CREATE or REPLACE FUNCTION _int_ge(_int4,_int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_ge(_int4,_int4) IS 'Is Greater or Equal in Document Order';

-- _int_gt
-- DROP FUNCTION _int_gt(_int4,_int4);

CREATE or REPLACE FUNCTION _int_gt(_int4,_int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_gt(_int4,_int4) IS 'Is Greater in Document Order';

-- _int_lt
-- DROP FUNCTION _int_le(_int4,_int4);

CREATE or REPLACE FUNCTION _int_le(_int4,_int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_le(_int4,_int4) IS 'Is Less or Equal in Document Order';

-- _int_le
-- DROP FUNCTION _int_lt(_int4,_int4);

CREATE or REPLACE FUNCTION _int_lt(_int4,_int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_lt(_int4,_int4) IS 'Is Less in Document Order';

-- create the support function too
CREATE or REPLACE FUNCTION intarray_abs_cmp(_int4, _int4) RETURNS INTEGER
   AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

---------------------------

--DROP OPERATOR < (_int4, _int4);
CREATE OPERATOR < (
	LEFTARG = _int4, RIGHTARG = _int4, PROCEDURE = _int_lt,
	COMMUTATOR = '>', NEGATOR = '>=',
	RESTRICT = scalarltsel, JOIN = scalarltjoinsel
);

--DROP OPERATOR <= (_int4, _int4);
CREATE OPERATOR <= (
	LEFTARG = _int4, RIGHTARG = _int4, PROCEDURE = _int_le,
	COMMUTATOR = '>=', NEGATOR = '>',
	RESTRICT = scalarltsel, JOIN = scalarltjoinsel
);

--DROP OPERATOR >= (_int4, _int4);
CREATE OPERATOR >= (
	LEFTARG = _int4, RIGHTARG = _int4, PROCEDURE = _int_ge,
	COMMUTATOR = '<=', NEGATOR = '<',
	RESTRICT = scalargtsel, JOIN = scalargtjoinsel
);

--DROP OPERATOR > (_int4, _int4);
CREATE OPERATOR > (
	LEFTARG = _int4, RIGHTARG = _int4, PROCEDURE = _int_gt,
	COMMUTATOR = '<', NEGATOR = '<=',
	RESTRICT = scalargtsel, JOIN = scalargtjoinsel
);

-----------------------------------------------

/* for PostgreSQL 7.4.2 */

CREATE OPERATOR = (
	LEFTARG = _int4,
	RIGHTARG = _int4,
	PROCEDURE = _int_same,
	COMMUTATOR = '=',
	NEGATOR = '<>',
	RESTRICT = eqsel,
	JOIN = eqjoinsel,
	SORT1 = '<',
	SORT2 = '<'
);

CREATE OPERATOR <> (
	LEFTARG = _int4,
	RIGHTARG = _int4,
	PROCEDURE = _int_different,
	COMMUTATOR = '<>',
	NEGATOR = '=',
	RESTRICT = neqsel,
	JOIN = neqjoinsel
);

-- now we can make the operator class
CREATE OPERATOR CLASS intarray_abs_ops
    DEFAULT FOR TYPE _int4 USING btree AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       intarray_abs_cmp(_int4, _int4);


-- vacuum analyze;