
#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Genereal Ledger
#
#======================================================================
$form->{rowcount}=40;


use SL::salessummary;

1;
# end of main


# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')


sub sales_report_print {
	$form->{print}="true";
	&sales_report;

}

sub sales_report {
  salessummary->all_transactions(\%myconfig, \%$form);
  $form->{title} = $locale->text('Sales Summary');
	&generate_report;

}

sub purchase_report_print {
	$form->{print}="true";
	&purchase_report;

}

sub purchase_report {
  salessummary->all_transactions3(\%myconfig, \%$form);
  $form->{title} = $locale->text('Purchase Summary');
	&generate_report;

}



sub generate_report {
 map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr));


  $callback = "$form->{script}?action=sales_report&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";
  
  if($form->{print} eq "true"){
   $line = "<hr size=2 noshade>";
    $fontsize="size=1";
    $file="print_report";

     $listprint ="class=print";
   $listheading="class=print";
    $listtop="class=print";
    $listrow="class=print";
    $listsubtotal="class=print";
 }else{
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
    $lastline=$locale->text('Click on "Partnumber"  to edit transaction');
     $file="sales_report";
   }

  %acctype = ( 'A' => $locale->text('Asset'),
               'L' => $locale->text('Liability'),
	       'Q' => $locale->text('Equity'),
	       'I' => $locale->text('Income'),
	       'E' => $locale->text('Expense'),
	     );


#   ($customer) = split /--/, $form->{customerno};
   $callback .= "&l_option=$form->{l_option}";
 if ($form->{customerno}) {
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Customer :')." ".$form->{customerno};
  $customer =~ s/ /%20/g;
  $customer=~ s/&/%amp/g;
    $callback .= "&customerno=$form->{customerno}";
  }
 if ($form->{make}) {
    $callback .= "&make=$form->{make}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Make :')." ".$form->{make};
  }
  
  if ($form->{model}) {
    $callback .= "&model=$form->{model}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Model :')." ".$form->{model};
  }

 if ($form->{partnono}) {
    $callback .= "&partnono=$form->{partnono}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Part Num :')." ".$form->{partnono};
  }
 if ($form->{idescno}) {
    $callback .= "&idescno=$form->{idescno}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Item Description :')." ".$form->{idescno};
  }

  if ($form->{datefrom}) {
    $callback .= "&datefrom=$form->{datefrom}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('From :')." ".$locale->date(\%myconfig, $form->{datefrom}, 1);
  }
  if ($form->{dateto}) {
    $callback .= "&dateto=$form->{dateto}";
    if ($form->{datefrom}) {
      $option .= " ";
    } else {
      $option .= "\n<br>" if $option;
    }
    $option .= $locale->text('To :')." ".$locale->date(\%myconfig, $form->{dateto}, 1);
  }


  @columns = $form->sort_columns(qw(partnumber description qty subtotal1 qtykg ));

  #if ($form->{idescno}) {
  #  @columns = grep !/description/, @columns;
  #}


 # if ($form->{partnono}) {
 #   @columns = grep !/partnumber/, @columns;
 # }




  $href = "$callback&sort=$form->{sort}";        # needed for accno
 # $callback += "&sort=$form->{sort}";        # needed for accno

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }

  $callback .= "&category=$form->{category}";
  $href .= "&category=$form->{category}";

  $column_header{partnumber} = "<th  $listprint ><a $listheading href=$callback&sort=partnumber><font color=ffffff>".$locale->text('PARTNUMBER')."</a>$line</th>";
  $column_header{description} = "<th  $listprint ><font color=ffffff>".$locale->text('DESCRIPTION')."$line</th>";
  $column_header{qty} = "<th  $listprint ><font color=ffffff>".$locale->text('QTY')."$line</th>";
  $column_header{subtotal1} = "<th  $listprint ><font color=ffffff>".$locale->text('SUBTOTAL')."$line</th>";

  $column_header{qtykg} = "<th  $listprint ><font color=ffffff>".$locale->text('QTY(kg)')."$line</th>";

  $colspan = $#column_index + 1;

  $form->header;
	    $option ='' if(!$form->{l_option})  ;
  $callback = $form->escape("$callback");

  print  qq|
<body   $listprint bgcolor=ffffff>
<h1   $listprint align=center>$form->{company}<br>$form->{title}</h1><Br>
$option
<table  $listprint  border=0 width=100%>

<tr $listheading bgcolor=336666>
|;

map { print  "$column_header{$_}\n" } @column_index;

print  "</tr>";

  # add sort to callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  # initial item for subtotals
  if (@{ $form->{report} }) {
    $sameitem = $form->{report}->[0]->{$form->{sort}};
#    print  "$sameitem<br>";
 }

  foreach $ref (@{ $form->{report} }) {

    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
    #print  "$sameitem<br>";
 }
    }

    $subtotalqtykg += $ref->{qtykg};
    $subtotaldebit += $ref->{qty};
    $subtotalcredit += $ref->{subtotal1};
 #  print  "$subtotalcredit<br>";

    $totalqtykg += $ref->{qtykg};
    $totaldebit += $ref->{qty};
    $totalcredit += $ref->{subtotal1};

    $pagetotalqtykg += $ref->{qtykg};
    $pagetotaldebit += $ref->{qty};
    $pagetotalcredit += $ref->{subtotal1};

    $ref->{subtotal1} = $form->format_amount(\%myconfig, $ref->{subtotal1}, 2, "&nbsp;");
    #$ref->{credit} = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

    $column_data{partnumber} = "<td  $listprint ><a href=ic.pl?action=edit&showreport=true&id=$ref->{parts_id}&transdateto=$form->{dateto}&transdatefrom=$form->{datefrom}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{partnumber}</a></td>";
    $column_data{description} = "<td  $listprint  >$ref->{description}</td>";
    $column_data{qty} = "<td   $listprint align=right>$ref->{qty}</td>";
    $column_data{subtotal1} = "<td   $listprint align=right>$ref->{subtotal1}</td>";

    $column_data{qtykg} = "<td  $listprint  align=right>$ref->{qtykg}</td>";

    $i++; $i %= 2;$r++;
    print  "<tr $listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >";
    map { print "$column_data{$_}\n" } @column_index;
    print  "</tr>";

    
        
    #pagebreak printing
if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){
$pagenum++;
    print "<tr $listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\"  >";
if($form->{l_sr}){
	print "<td $listprint >$line&nbsp;</td>";
}
	
	  map { $column_data{$_} = "<td $listprint >$line&nbsp;</td>" } @column_index;
     $column_data{description} = "<td $listprint >$line SubTotal</td>";
    $column_data{qtykg} = "<td  $listprint align=right>$line $pagetotalqtykg</td>";
    $column_data{qty} = "<td  $listprint align=right>$line $pagetotaldebit</td>";
    $column_data{subtotal1} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
     map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
</table>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>
<table  $listprint border=0 width=100%>

<tr $listheading >|;
if($form->{l_sr}){
	print "<th $listprint ><font $listheadingcolor>".$locale->text('SR')."$line</font></th>";
}
map { print "\n$column_header{$_}" } @column_index;

print qq|
</tr><tr>
|;
if($form->{l_sr}){
	print "<td $listprint >&nbsp;</td>";
}

 	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
     $column_data{description} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
     $column_data{qtykg} = "<td  $listprint align=right> $pagetotalqtykg</td>";
    $column_data{qty} = "<td  $listprint align=right> $pagetotaldebit </td>";
    $column_data{subtotal1} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
    map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;

}


  }

  &gl_subtotal if ($form->{l_subtotal} eq 'Y');

  map { $column_data{$_} = "<td  $listprint >&nbsp;</td>" } @column_index;

#  $column_data{debit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totaldebit, 2, "&nbsp;")."</th>";
  $column_data{subtotal1} = "<th   $listprint align=right>$line<font color=ffffff>".$form->format_amount(\%myconfig, $totalcredit, 2, "&nbsp;")."</th>";
  $column_data{qty} = "<th  $listprint align=right>$line<font color=ffffff> $subtotaldebit</th>";
  $column_data{qtykg} = "<th  $listprint  align=right>$line<font color=ffffff> $subtotalqtykg</th>";

  print  qq|
<tr $listtotal bgcolor=000000>|;

  map { print  "$column_data{$_}\n" } @column_index;

  print  qq|</tr>
 </table>

<p>
$lastline

</body>
</html>
|;

}


sub stock_value_print {
	$form->{print}="true";
	&stock_value;

}

sub stock_value {
 map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr));

  salessummary->all_transactions2(\%myconfig, \%$form);

  $callback = "$form->{script}?action=stock_value&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";
  
  if($form->{print} eq "true"){
   $line = "<hr size=2 noshade>";
    $fontsize="size=1";
    $file="print_report";

     $listprint ="class=print";
   $listheading="class=print";
    $listtop="class=print";
    $listrow="class=print";
    $listsubtotal="class=print";
 }else{
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
    $lastline=$locale->text('Click on "Partnumber"  to edit transaction');
     $file="stock_value";
   }

  %acctype = ( 'A' => $locale->text('Asset'),
               'L' => $locale->text('Liability'),
	       'Q' => $locale->text('Equity'),
	       'I' => $locale->text('Income'),
	       'E' => $locale->text('Expense'),
	     );

  $form->{title} = $locale->text('Stock Values Report');

#   ($customer) = split /--/, $form->{customerno};
   $callback .= "&l_option=$form->{l_option}";
 if ($form->{customerno}) {
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Customer :')." ".$form->{customerno};
  $customer =~ s/ /%20/g;
  $customer=~ s/&/%amp/g;
    $callback .= "&customerno=$form->{customerno}";
  }
 if ($form->{make}) {
    $callback .= "&make=$form->{make}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Make :')." ".$form->{make};
  }
  
  if ($form->{model}) {
    $callback .= "&model=$form->{model}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Model :')." ".$form->{model};
  }

                  
  
 if ($form->{datefrom}) {
    $callback .= "&datefrom=$form->{datefrom}";
    $option .= "\n<br>" if $option;
    $option .= "<center>".$locale->text('From :')." ".$locale->date(\%myconfig, $form->{datefrom}, 1)."</center>";
  }
  if ($form->{dateto}) {
    $callback .= "&dateto=$form->{dateto}";
    if ($form->{datefrom}) {
      $option .= " ";
    } else {
      $option .= "\n<br>" if $option;
    }
    $option .= "<center>".$locale->text('To :')." ".$locale->date(\%myconfig, $form->{dateto}, 1)."</center>";
  }


 if ($form->{partnono}) {
    $callback .= "&partnono=$form->{partnono}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Part Num :')." ".$form->{partnono};
  }
 if ($form->{idescno}) {
    $callback .= "&idescno=$form->{idescno}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Item Description :')." ".$form->{idescno};
  }

 if ($form->{l_show_only_diff}) {
    $callback .= "&l_show_only_diff=$form->{l_show_only_diff}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Show Only Difference :')
    
    }

  @columns = $form->sort_columns(qw(partnumber description bf sin sout adjust qty onhand diff lastcost value  ));

  #if ($form->{idescno}) {
  #  @columns = grep !/description/, @columns;
  #}


 # if ($form->{partnono}) {
 #   @columns = grep !/partnumber/, @columns;
 # }




  $href = "$callback&sort=$form->{sort}";        # needed for accno
 # $callback += "&sort=$form->{sort}";        # needed for accno

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }

  $callback .= "&category=$form->{category}";
  $href .= "&category=$form->{category}";

  $column_header{partnumber} = "<th  $listprint ><a $listheading href=$callback&sort=partnumber>$line".$locale->text('PARTNUMBER')."</a>$line</th>";
  $column_header{description} = "<th  $listprint >$line".$locale->text('DESCRIPTION')."$line</th>";
  $column_header{bf} = "<th  $listprint >$line".$locale->text('BF')."$line</th>";
  $column_header{sin} = "<th  $listprint >$line".$locale->text('In')."$line</th>";
  $column_header{sout} = "<th  $listprint >$line".$locale->text('Out')."$line</th>";
  $column_header{adjust} = "<th  $listprint >$line".$locale->text('Adjust')."$line</th>";
  $column_header{qty} = "<th  $listprint >$line".$locale->text('Qty')."$line</th>";
   $column_header{onhand} = "<th  $listprint >$line".$locale->text('Onhand')."$line</th>";
   $column_header{diff} = "<th  $listprint >$line".$locale->text('Diff')."$line</th>";
 $column_header{lastcost} = "<th  $listprint >$line".$locale->text('Last Cost')."$line</th>";
  $column_header{value} = "<th  $listprint >$line".$locale->text('Stk value')."$line</th>";

  $colspan = $#column_index + 1;

  $form->header;
	    $option ='' if(!$form->{l_option})  ;
  $callback = $form->escape("$callback");

  print  qq|
<body   $listprint bgcolor=ffffff>
<h1   $listprint align=center>$form->{company}<br>$form->{title}</h1><Br>
<form method=post action=salessummary.pl name=myform>
<table  $listprint  border=0 width=100%>
<tr>
<td $listprint colspan=$colspan>
$option
</td>
</tr>
<tr $listheading >

|;

map { print  "$column_header{$_}\n" } @column_index;

print  "</tr>";

  # add sort to callback
  #$callback = $form->escape($callback . "&sort=$form->{sort}");
   $callback.="&sort=$form->{sort}";
  # initial item for subtotals
  if (@{ $form->{report} }) {
    $sameitem = $form->{report}->[0]->{$form->{sort}};
#    print  "$sameitem<br>";
 }
$r=1;
  foreach $ref (@{ $form->{report} }) {

    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
    #print  "$sameitem<br>";
 }
    }
    
 
 $ref->{bf} = 0 if !$ref->{bf};
$totalqty=$ref->{bf}+$ref->{sin}-$ref->{sout}+$ref->{adjust};
   $total=$ref->{lastcost}*$totalqty;
 
        $diff=$ref->{onhand}-$totalqty;

   if(($diff != 0 && $form->{l_show_only_diff}) || !$form->{l_show_only_diff} ){
   $subtotalqtykg += $ref->{qtykg};
    $subtotaldebit += $totalqty;
    $subtotalcredit += $total;
 #  print  "$subtotalcredit<br>";

    $totalqtykg += $ref->{qtykg};
    $totaldebit += $totalqty;
    $totalcredit += $total;

    $pagetotalqtykg += $ref->{qtykg};
    $pagetotaldebit += $totalqty;
    $pagetotalcredit += $total;

    $ref->{subtotal1} = $form->format_amount(\%myconfig, $ref->{subtotal1}, 2, "&nbsp;");
    #$ref->{credit} = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

    $column_data{partnumber} = "<td  $listprint ><input name=\"parts_id_$r\" type=hidden class=checkbox value=$ref->{parts_id} > <a href=ic.pl?action=edit&showreport=true&id=$ref->{parts_id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{partnumber}</a></td>";
    $column_data{description} = "<td  $listprint  >$ref->{description}</td>";
    $column_data{bf} = "<td   $listprint align=right>$ref->{bf}</td>";
     $column_data{sin} = "<td   $listprint align=right>$ref->{sin}</td>";
    $column_data{sout} = "<td   $listprint align=right>$ref->{sout}</td>";
    $column_data{adjust} = "<td   $listprint align=right>$ref->{adjust}</td>";
        
   $column_data{qty} = "<td   $listprint align=right>$totalqty</td>";
    $column_data{onhand} = "<td   $listprint align=right>$ref->{onhand}</td>";
 	$diff_text="$diff<input name=\"diff_$r\" type=hidden class=checkbox value=$diff > ";    
     
    

    $column_data{diff} = "<td   $listprint align=right>$diff_text</td>";
    $column_data{lastcost} = "<td   $listprint align=right>$ref->{lastcost}</td>";
    $column_data{value} = "<td   $listprint align=right>$total</td>";

    
	$i++; $i %= 2;$r++;
	print  "<tr $listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >";
	map { print "$column_data{$_}\n" } @column_index;
	print  "</tr>";
}


        
    #pagebreak printing
if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){
$pagenum++;
    print "<tr $listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\"  >";
if($form->{l_sr}){
	print "<td $listprint >$line&nbsp;</td>";
}
	
	  map { $column_data{$_} = "<td $listprint >$line&nbsp;</td>" } @column_index;
    # $column_data{description} = "<td $listprint >$line SubTotal</td>";
    #$column_data{qtykg} = "<td  $listprint align=right>$line $pagetotalqtykg</td>";
   # $column_data{qty} = "<td  $listprint align=right>$line $pagetotaldebit</td>";
    #$column_data{subtotal1} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
     map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
</table>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>
<table  $listprint border=0 width=100%>

<tr $listheading >|;
if($form->{l_sr}){
	print "<th $listprint ><font $listheadingcolor>".$locale->text('SR')."$line</font></th>";
}
map { print "\n$column_header{$_}" } @column_index;

print qq|
</tr><tr>
|;
if($form->{l_sr}){
	print "<td $listprint >&nbsp;</td>";
}

 	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
    # $column_data{description} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
   #  $column_data{qtykg} = "<td  $listprint align=right> $pagetotalqtykg</td>";
   # $column_data{qty} = "<td  $listprint align=right> $pagetotaldebit </td>";
   # $column_data{subtotal1} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
    map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;

}


  }

  &gl_subtotal if ($form->{l_subtotal} eq 'Y');

  map { $column_data{$_} = "<td  $listprint >$line&nbsp;</td>" } @column_index;

#  $column_data{debit} = "<th align=right>".$form->format_amount(\%myconfig, $totaldebit, 2, "&nbsp;")."</th>";
  $column_data{value} = "<th   $listprint align=right>$line".$form->format_amount(\%myconfig, $totalcredit, 2, "&nbsp;")."</th>";
  $column_data{qty} = "<th  $listprint align=right>$line $subtotaldebit</th>";
#  $column_data{qtykg} = "<th  $listprint  align=right>$line $subtotalqtykg</th>";

  print  qq|
<tr $listtotal >|;

  map { print  "$column_data{$_}\n" } @column_index;

  print  qq|</tr>
 </table>

 |;
    $callback= $form->unescape($callback);


 if(!$form->{print}){
 print qq| <input class=submit type=submit name=action value="|.$locale->text('Update Quantity').qq|">|;
 }
 $r--;
print qq|
<input type=hidden name=row value=$r>
<input type=hidden name=callback value=$callback>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<p>
$lastline
</form>
</body>
</html>
|;

}

sub update_quantity{
 salessummary->update_quantity(\%myconfig, \%$form);
	
	$form->redirect;
	
#	&stock_value_report;
}

sub gl_subtotal {

  $subtotaldebit = $form->format_amount(\%myconfig, $subtotaldebit, 2, "&nbsp;");
  $subtotalcredit = $form->format_amount(\%myconfig, $subtotalcredit, 2, "&nbsp;");

  map { $column_data{$_} = "<td>&nbsp;</td>" } qw(partnumber description qty );
  $column_data{qty} = "<th align=right>$subtotaldebit</font></td>";
  $column_data{subtotal1} = "<th align=right>$subtotalcredit</font></td>";
  $column_data{qtykg} = "<th align=right>$subtotalqtykg</font></td>";


  print "<tr $listsubtotal bgcolor=333366>";
  map { print "$column_data{$_}\n" } @column_index;
  print "</tr>";

  $subtotaldebit = 0;
  $subtotalcredit = 0;
  $subtotalqtykg=0;
  $sameitem = $ref->{$form->{sort}};

}




sub update_form {

  @a = ();
  $count = 0;
  @flds = (qw(accno debit credit));

  for $i (1 .. $form->{rowcount}) {
    unless (($form->{"debit_$i"} eq "") && ($form->{"credit_$i"} eq "")) {
      # take accno apart
      ($form->{"accno_$i"}) = split(/--/, $form->{"accno_$i"});
      
      push @a, {};
      $j = $#a;
      
      map { $a[$j]->{$_} = $form->{"${_}_$i"} } @flds;
      $count++;
    }
  }

  for $i (1 .. $count) {
    $j = $i - 1;
    map { $form->{"${_}_$i"} = $a[$j]->{$_} } @flds;
  }

  for $i ($count + 1 .. $form->{rowcount}) {
    map { delete $form->{"${_}_$i"} } @flds;
  }

  $form->{rowcount} = $count;

  &display_form;
  
}








sub search {

  $form->{title} = $locale->text('Sales/Purchase')." ".$locale->text('Reports');

  $form->header;
 $form->all_vc(\%myconfig, "customer");

  $selection = "<option selected value=''>" . $locale->text('All Customers') . "\n";

  foreach $ref (@{ $form->{all_customer} }) {
	  $selection .= "<option value='$ref->{customernumber}::$ref->{name}--$ref->{id}'>$ref->{customernumber}--$ref->{name}\n";
  }

   $form->all_vc(\%myconfig, "vendor");

  $selectionvc = "<option selected value=''>" . $locale->text('All Vendors') . "\n";

  foreach $ref (@{ $form->{all_vendor} }) {
	  $selectionvc .= "<option value='$ref->{vendornumber}::$ref->{name}--$ref->{id}'>$ref->{vendornumber}--$ref->{name}\n";
  }
  

  
  if($form->{stockvalue} ){
    $form->{title} = $locale->text('Stock Values')." ".$locale->text('Reports');
$search=qq|
  <input name="l_partnumber" class=checkbox type=checkbox value=Y $form->{l_partnumber}>&nbsp;|.$locale->text('Part number').qq|
    <input name="l_description" class=checkbox type=checkbox value=Y $form->{l_description}>&nbsp;|.$locale->text('Description').qq|<br>
    <input name="l_bf" class=checkbox type=checkbox value=Y $form->{l_bf}>&nbsp;|.$locale->text('Bring Forward').qq|
       <input name="l_sin" class=checkbox type=checkbox value=Y $form->{l_sin}>&nbsp;|.$locale->text('Stock in').qq|
   <input name="l_sout" class=checkbox type=checkbox value=Y $form->{l_sout}>&nbsp;|.$locale->text('Stock out').qq|
   <input name="l_adjust" class=checkbox type=checkbox value=Y $form->{l_adjust}>&nbsp;|.$locale->text('Adjust').qq|<br>
   <input name="l_qty" class=checkbox type=checkbox value=Y $form->{l_qty}>&nbsp;|.$locale->text('QTY').qq|
   <input name="l_onhand" class=checkbox type=checkbox value=Y $form->{l_onhand}>&nbsp;|.$locale->text('Onhand').qq|
   <input name="l_diff" class=checkbox type=checkbox value=Y $form->{l_diff}>&nbsp;|.$locale->text('diff').qq|
   <input name="l_lastcost" class=checkbox type=checkbox value=Y $form->{l_lastcost}>&nbsp;|.$locale->text('Last Cost').qq|
   <input name="l_value" class=checkbox type=checkbox value=Y $form->{l_value}>&nbsp;|.$locale->text('Stock Value').qq|
    <input name="l_subtotal1" class=checkbox type=checkbox value=Y $form->{l_subtotal1}>&nbsp;|.$locale->text('Grand Total').qq|
|;
$button=qq|
<input class=submit type=submit name=action value="|.$locale->text('Stock Value').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Stock Value Print').qq|">

|;

}else{
$search=qq|
    <input name="l_partnumber" class=checkbox type=checkbox value=Y $form->{l_partnumber}>&nbsp;|.$locale->text('Part number').qq|
    <input name="l_description" class=checkbox type=checkbox value=Y $form->{l_description}>&nbsp;|.$locale->text('Description').qq|<br>
    <input name="l_qtykg" class=checkbox type=checkbox value=Y $form->{l_qtykg}>&nbsp;|.$locale->text('Qty(kg)').qq|
    <input name="l_qty" class=checkbox type=checkbox value=Y $form->{l_qty}>&nbsp;|.$locale->text('Quantity').qq|
    <input name="l_subtotal1" class=checkbox type=checkbox value=Y $form->{l_subtotal1}>&nbsp;|.$locale->text('Grand Total').qq|

|;



$button=qq|
<input class=submit type=submit name=action value="|.$locale->text('Sales Report').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Sales Report Print').qq|"><br>

|;


$button2=qq|
<br>
<input class=submit type=submit name=action value="|.$locale->text('Purchase Report').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Purchase Report Print').qq|"><br>

|;
}

$showcustomer = qq|
<tr>
<th align=right>|.$locale->text('Customer').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=customerno onChange="this.form.accno1.value=this.options[this.selectedIndex].value">$selection</select>
		</td>

</tr>
<tr>
<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendorno onChange="this.form.accno1.value=this.options[this.selectedIndex].value">$selectionvc</select>
		</td>


</tr>
|;

$showcustomer="" if($form->{stockvalue});
	

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<input type=hidden name=sort value=partnumber>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>



<tr>
$showcustomer
  <th align=right>|.$locale->text('From').qq| </th>
  <td><input name=datefrom size=11 title=($myconfig{dateformat})>
   <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input name=dateto size=11 title=($myconfig{dateformat})>  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['search'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
</td>

</tr>

<tr>

  <th align=right>|.$locale->text('Part Number.').qq| </th>
  <td><input name=partnono size=11></td>
  <th align=right>|.$locale->text('Item Description').qq|</th>
  <td><input name=idescno size=20></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Make').qq| </th>
  <td><input name=make size=20></td>
  <th align=right>|.$locale->text('Model').qq|</th>
  <td><input name=model size=20></td>

</tr>
<tr>
<td colspan=4>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq||;
    
  if ($form->{stockvalue}){
  print "<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_show_only_diff class=checkbox type=checkbox value=Y  $form->{l_show_only_diff}>&nbsp;".$locale->text('Show only Difference') ;

}

print qq|
</td>
</tr>
<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>

  	$search

    </td>

  </tr>

</table>
</td>

</tr>
</table>

<input type=hidden name=rowcount value=$form->{rowcount}>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<br>
$button
$button2
</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}



sub search_short {

  $form->{title} = $locale->text('Sales/Purchase')." ".$locale->text('Reports');

  $form->header;
 $form->all_vc(\%myconfig, "customer");

  $selection = "<option selected value=''>" . $locale->text('All Customers') . "\n";

  foreach $ref (@{ $form->{all_customer} }) {
	  $selection .= "<option value='$ref->{customernumber}::$ref->{name}--$ref->{id}'>$ref->{customernumber}--$ref->{name}\n";
  }

   $form->all_vc(\%myconfig, "vendor");

  $selectionvc = "<option selected value=''>" . $locale->text('All Vendors') . "\n";

  foreach $ref (@{ $form->{all_vendor} }) {
	  $selectionvc .= "<option value='$ref->{vendornumber}::$ref->{name}--$ref->{id}'>$ref->{vendornumber}--$ref->{name}\n";
  }
  

  
  if($form->{stockvalue} ){
  $form->{title} = $locale->text('Stock Values')." ".$locale->text('Reports');


  $search.=qq|  <input name="l_partnumber" class=checkbox type=hidden value=Y $form->{l_partnumber}>&nbsp;|if $form->{l_partnumber};
  $search.=qq|    <input name="l_description" class=checkbox type=hidden value=Y $form->{l_description}>&nbsp;|if $form->{l_description};
   $search.=qq|   <input name="l_bf" class=checkbox type=hidden value=Y $form->{l_bf}>&nbsp;|if $form->{l_bf};
  $search.=qq|       <input name="l_sin" class=checkbox type=hidden value=Y $form->{l_sin}>&nbsp;|if $form->{l_sin};
  $search.=qq|   <input name="l_sout" class=checkbox type=hidden value=Y $form->{l_sout}>&nbsp;|if $form->{l_sout};
  $search.=qq|   <input name="l_adjust" class=checkbox type=hidden value=Y $form->{l_adjust}>&nbsp;|if $form->{l_adjust};
  $search.=qq|   <input name="l_qty" class=checkbox type=hidden value=Y $form->{l_qty}>&nbsp;|if $form->{l_qty};
  $search.=qq|   <input name="l_onhand" class=checkbox type=hidden value=Y $form->{l_onhand}>&nbsp;|if $form->{l_onhand};
  $search.=qq|   <input name="l_diff" class=checkbox type=hidden value=Y $form->{l_diff}>&nbsp;|if $form->{l_diff};
  $search.=qq|   <input name="l_lastcost" class=checkbox type=hidden value=Y $form->{l_lastcost}>&nbsp;|if $form->{l_lastcost};
  $search.=qq|   <input name="l_value" class=checkbox type=hidden value=Y $form->{l_value}>&nbsp;|if $form->{l_value};
   $search.=qq|   <input name="l_subtotal1" class=checkbox type=hidden value=Y $form->{l_subtotal1}>&nbsp;|if $form->{l_subtotal1};

$button=qq|
<input class=submit type=submit name=action value="|.$locale->text('Stock Value').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Stock Value Print').qq|">
<input class=submit type=submit name=action value="|.$locale->text('More').qq|">

|;

}else{
$search=qq|    <input name="l_partnumber" class=checkbox type=hidden value=Y $form->{l_partnumber}>&nbsp;|if $form->{l_partnumber};
  $search.=qq|    <input name="l_description" class=checkbox type=hidden value=Y $form->{l_description}>&nbsp;|if $form->{l_description};
  $search.=qq|    <input name="l_qtykg" class=checkbox type=hidden value=Y $form->{l_qtykg}>&nbsp;|if $form->{l_qtykg};
  $search.=qq|    <input name="l_qty" class=checkbox type=hidden value=Y $form->{l_qty}>&nbsp;|if $form->{l_qty};
   $search.=qq|   <input name="l_subtotal1" class=checkbox type=hidden value=Y $form->{l_subtotal1}>&nbsp;|if $form->{l_subtotal1};





$button=qq|
<input class=submit type=submit name=action value="|.$locale->text('Sales Report').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Sales Report Print').qq|"><br>

|;


$button2=qq|
<br>
<input class=submit type=submit name=action value="|.$locale->text('Purchase Report').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Purchase Report Print').qq|"><br><br>
<input class=submit type=submit name=action value="|.$locale->text('More').qq|">

|;
}

$showcustomer = qq|
<tr>
<th align=right>|.$locale->text('Customer').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=customerno onChange="this.form.accno1.value=this.options[this.selectedIndex].value">$selection</select>
		</td>

</tr>
<tr>
<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendorno onChange="this.form.accno1.value=this.options[this.selectedIndex].value">$selectionvc</select>
		</td>


</tr>
|;

$showcustomer="" if($form->{stockvalue});
	

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<input type=hidden name=sort value=partnumber>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>



<tr>
$showcustomer
  <th align=right>|.$locale->text('From').qq| </th>
  <td><input name=datefrom size=11 title=($myconfig{dateformat})>
   <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input name=dateto size=11 title=($myconfig{dateformat})>  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['search'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
</td>

</tr>

<tr>

  <th align=right>|.$locale->text('Part Number.').qq| </th>
  <td><input name=partnono size=11></td>
  <th align=right>|.$locale->text('Item Description').qq|</th>
  <td><input name=idescno size=20></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Make').qq| </th>
  <td><input name=make size=20></td>
  <th align=right>|.$locale->text('Model').qq|</th>
  <td><input name=model size=20></td>

</tr>
<tr>
<td colspan=4>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq||;
  if ($form->{stockvalue}){
  print "<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_show_only_diff class=checkbox type=checkbox value=Y  $form->{l_show_only_diff}>&nbsp;".$locale->text('Show only Difference') ;

}

print qq|
</td>
</tr>

  	$search


</table>
</td>

</tr>
</table>

<input type=hidden name=rowcount value=$form->{rowcount}>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=stockvalue value=$form->{stockvalue}>

<br>
$button
$button2
</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}


sub more{
  @columns = qw(partnumber description qty subtotal1 qtykg );
  @columns = qw(partnumber description bf sin sout adjust qty onhand diff lastcost value  ) if $form->{stockvalue};
    map { $form->{"l_$_"} = "checked" if $form->{"l_$_"} eq "Y" } @columns;

 &search;
}

sub continue{
&{"generate_$form->{ptitle}"};
}
sub print_report{
&{"generate_$form->{ptitle}_print"};
}