/*-------------------------------------------------------------------------
 *
 * replicate.h
 *	  Primary include file for replicate server .c files
 *
 * This should be the first file included by replicate modules.
 *
 *-------------------------------------------------------------------------
 */
#ifndef REPLICATE_COM_H
#define	REPLICATE_COM_H 1

#ifndef _SYS_TYPES_H
#include <sys/types.h>
#endif
#ifndef _INTTYPES_H
#include <inttypes.h>
#endif
#ifndef _NETINET_IN_H
#include <netinet/in.h>
#endif

/*  Replication packet id */
#define	CMD_SYS_REPLICATE	'R'

#define CMD_STS_SET_SESSION_AUTHORIZATION	'S'
#define	CMD_STS_TRANSACTION	'T'
#define	CMD_STS_TEMP_TABLE	'E'
#define	CMD_STS_QUERY	'Q'
#define	CMD_STS_COPY	'C'
#define	CMD_STS_OTHER	'O'

#define CMD_TYPE_VACUUM	'V'
#define CMD_TYPE_ANALYZE	'A'
#define CMD_TYPE_REINDEX	'N'
#define CMD_TYPE_SELECT	'S'
#define CMD_TYPE_EXPLAIN	'X'
#define CMD_TYPE_SET	'T'
#define CMD_TYPE_RESET	't'
#define CMD_TYPE_INSERT	'I'
#define CMD_TYPE_DELETE	'D'
#define CMD_TYPE_EXECUTE	'U'
#define CMD_TYPE_UPDATE	'U'
#define CMD_TYPE_BEGIN	'B'
#define CMD_TYPE_COMMIT	'E'
#define CMD_TYPE_ROLLBACK	'R'
#define CMD_TYPE_COPY	'C'
#define CMD_TYPE_COPY_DATA	'd'
#define CMD_TYPE_COPY_DATA_END	'e'
#define CMD_TYPE_SESSION_AUTHORIZATION_BEGIN	'a'
#define CMD_TYPE_SESSION_AUTHORIZATION_END	'b'
#define CMD_TYPE_OTHER	'O'

/* System call packet id */
#define CMD_SYS_CALL		'S'

#define	CMD_STS_NOTICE	'N'
#define	CMD_STS_RESPONSE	'R'
#define	CMD_STS_TRANSACTION_ABORT	'A'

#define CMD_TYPE_COMMIT_CONFIRM	'c'
#define CMD_TYPE_DEADLOCK_DETECT	'd'
#define CMD_TYPE_FRONTEND_CLOSED	'x'

#define PGR_TRANSACTION_SOCKET	(0)
#define PGR_QUERY_SOCKET	(1)

#define	DATA_FREE	(0)
#define	DATA_INIT	(1)
#define	DATA_USE	(2)
#define	DATA_ERR	(90)
#define	DATA_END	(-1)
#define HOSTNAME_MAX_LENGTH     (128)
#define DBNAME_MAX_LENGTH       (128)
#define USERNAME_MAX_LENGTH     (128)
#define TABLENAME_MAX_LENGTH     (128)
#define PATH_MAX_LENGTH        (256)
#define MAX_SERVER_NUM         (128)
#define MAX_RETRY_TIMES	(3)
#define MAX_SOCKET_QUEUE	(100000)
#define TRANSACTION_ERROR_RESULT	"TRANSACTION_ERROR"
#define REPLICATE_SERVER_SHM_KEY (1020)
/* target -> replicate */
#define RECOVERY_PREPARE_REQ	(1)
/* replicate  -> master */
#define RECOVERY_PGDATA_REQ	(2)
/* master -> replicate */
#define RECOVERY_PGDATA_ANS	(3)
/* replicate -> target */
#define RECOVERY_PREPARE_ANS	(4)
/* target -> replicate */
#define RECOVERY_START_REQ	(5)
/* replicate  -> master */
#define RECOVERY_FSYNC_REQ	(6)
/* master -> replicate */
#define RECOVERY_FSYNC_ANS	(7)
/* replicate -> target */
#define RECOVERY_START_ANS	(8)
/* target -> replicate */
#define RECOVERY_FINISH	(9)
#define RECOVERY_ERROR_OCCUPIED	(100)
#define RECOVERY_ERROR_CONNECTION	(101)
#define RECOVERY_ERROR_ANS	(200)
#define REPLICATION_SERVER_INFO_TAG "Replicate_Server_Info"
#define HOST_NAME_TAG	"Host_Name"
#define PORT_TAG	"Port"
#define RECOVERY_PORT_TAG	"Recovery_Port"
#define RSYNC_PATH_TAG	"Rsync_Path"
#define RSYNC_OPTION_TAG	"Rsync_Option"
#define RECOVERY_INIT	(0)
#define RECOVERY_PREPARE_START	(1)
#define RECOVERY_START	(2)
#define RECOVERY_ERROR	(99)

/* response mode */
#define PGR_FAST_MODE	(0)
#define PGR_NORMAL_MODE	(1)
#define PGR_RELIABLE_MODE	(2)

#define RECOVERY_TIMEOUT	(600)
#ifndef COMPLETION_TAG_BUFSIZE
#define	COMPLETION_TAG_BUFSIZE (128)
#endif

#define PGR_SYSTEM_COMMAND_FUNC	"PGR_SYSTEM_COMMAND_FUNCTION"
#define PGR_STARTUP_REPLICATION_SERVER_FUNC_NO	(1)
#define PGR_CHANGE_REPLICATION_SERVER_FUNC_NO	(2)
#define PGR_SET_CURRENT_TIME_FUNC_NO	(3)
#define PGR_NOTICE_DEADLOCK_DETECTION_FUNC_NO	(4)
#define PGR_TRANSACTION_CONFIRM_ANSWER_FUNC_NO	(5)
#define PGR_RELIABLE_MODE_DONE_FUNC_NO		(6)
#define PGR_NOTICE_ABORT_FUNC_NO		(7)
#define PGR_SET_CURRENT_REPLICATION_QUERY_ID_NO (8)
#define PGR_CMD_ARG_NUM	(4)
#define PGR_LOCK_CONFLICT_NOTICE_CMD	"PGR_LOCK_CONFLICT_NOTICE_CMD"
#define PGR_DEADLOCK_DETECT_NOTICE_CMD	"PGR_DEADLOCK_DETECT_NOTICE_CMD"
#define PGR_QUERY_DONE_NOTICE_CMD		"PGR_QUERY_DONE_NOTICE_CMD"
#define PGR_QUERY_ABORTED_NOTICE_CMD	"PGR_QUERY_ABORTED_NOTICE_CMD"
#define PGR_RETRY_LOCK_QUERY_CMD	"PGR_RETRY_LOCK_QUERY_CMD"
#define PGR_NOT_YET_COMMIT		(0)
#define PGR_ALREADY_COMMITTED	(1)

#define COPYBUFSIZ	(8192)
#define MAX_WORDS	(24)
#define MAX_WORD_LETTERS	(48)
#define PGR_MESSAGE_BUFSIZE	(128)
#define INT_LENGTH	(12)

typedef struct ReplicateHeaderType
{
	char cmdSys;
	char cmdSts;	/*
					Q:query 
					T:transaction
					*/
	char cmdType;	/*
				S:select
				I:insert
				D:delete
				U:update
				B:begin
				E:commit/rollback/end
				O:others
					*/
	char dummy;
	uint16_t port;
	uint16_t pid;
	uint32_t query_size;
	char from_host[HOSTNAME_MAX_LENGTH];
	char dbName[DBNAME_MAX_LENGTH];
	char userName[USERNAME_MAX_LENGTH];
	struct timeval tv;
	uint32_t query_id;
        int isAutoCommit; /* 0 if autocommit is off. 1 if autocommit is on */
} ReplicateHeader;

typedef struct RecoveryPacketType
{
	uint16_t packet_no;	/*	
					1:start recovery prepare
					2:ask pgdata
					3:ans pgdata
					4:send master info
					5:start queueing query
					6:requst fsync
					7:ready to fsync
					8:pepared master
					9:finished rsync
					*/
	uint16_t max_connect;
	uint16_t port;
	uint16_t recoveryPort;
	char hostName[HOSTNAME_MAX_LENGTH];
	char pg_data[PATH_MAX_LENGTH]; 
	char userName[USERNAME_MAX_LENGTH];
} RecoveryPacket;

typedef struct
{
	char table[128];
	int rec_no;
	char key[128];
	char value[128];
	char * last;
	char * next;
} ConfDataType;


typedef struct ReplicateServerInfoType
{
	uint32_t useFlag;
	char hostName[HOSTNAME_MAX_LENGTH];
	uint16_t portNumber;
	uint16_t recoveryPortNumber;
	uint32_t sock;
	uint16_t response_mode;
} ReplicateServerInfo;


typedef struct ReplicateNowType
{
	int useFlag;
	int use_seed;
	struct timeval tp;
} ReplicateNow;

typedef struct CopyDataType
{
	int cnt;
	char copy_data[COPYBUFSIZ];
} CopyData;

typedef struct ClusterDBInfoType
{
	int status;
} ClusterDBInfo;

extern ConfDataType * ConfData_Top;
extern ConfDataType * ConfData_End;
extern ReplicateServerInfo * ReplicateServerData;
extern ClusterDBInfo * ClusterDBData;
extern int ReplicateServerShmid;
extern int ClusterDBShmid;

/* in backend/libpq/replicate_com.c */
extern int PGR_Create_Socket_Connect(int * fdP, char * hostName , unsigned short portNumber);
extern void PGR_Close_Sock(int * sock);
extern int PGR_Create_Socket_Bind(int * fdP, char * hostName , unsigned short portNumber);
extern int PGR_Create_Acception(int fd, int * sockP, char * hostName , unsigned short portNumber);
extern int PGR_Free_Conf_Data(void);
extern int PGR_Get_Conf_Data(char * dir , char * fname);
extern void PGRset_recovery_packet_no(RecoveryPacket * packet, int packet_no);
extern unsigned int PGRget_ip_by_name(char * host);

#endif /* REPLICATE_COM_H */
